/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceMedia;

class QSequenceRestrictedMedia
implements QSequenceMedia {
    private final QSequenceMedia media;
    private int leftMin;
    private int rightMin;
    private int leftMax;
    private int rightMax;

    public QSequenceRestrictedMedia(QSequenceMedia qSequenceMedia) {
        this.media = qSequenceMedia;
        this.restrictTo(1, qSequenceMedia.getLeftLength(), 1, qSequenceMedia.getRightLength());
    }

    public void restrictTo(int n2, int n3, int n4, int n5) {
        QSequenceAssert.assertTrue(0 <= n2 && n2 <= n3 + 1);
        QSequenceAssert.assertTrue(n3 <= this.media.getLeftLength());
        QSequenceAssert.assertTrue(0 <= n4 && n4 <= n5 + 1);
        QSequenceAssert.assertTrue(n5 <= this.media.getRightLength());
        this.leftMin = n2;
        this.leftMax = n3;
        this.rightMin = n4;
        this.rightMax = n5;
    }

    public int getLeftLength() {
        return this.leftMax - this.leftMin + 1;
    }

    public int getRightLength() {
        return this.rightMax - this.rightMin + 1;
    }

    public boolean equals(int n2, int n3) {
        QSequenceAssert.assertTrue(1 <= n2 && n2 <= this.leftMax - this.leftMin + 1);
        QSequenceAssert.assertTrue(1 <= n3 && n3 <= this.rightMax - this.rightMin + 1);
        return this.media.equals(this.leftMin + n2 - 2, this.rightMin + n3 - 2);
    }

    public int getLeftMin() {
        return this.leftMin;
    }

    public int getLeftMax() {
        return this.leftMax;
    }

    public int getRightMin() {
        return this.rightMin;
    }

    public int getRightMax() {
        return this.rightMax;
    }
}

