/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceDeePathBackwardExtender;
import de.regnis.q.sequence.core.QSequenceDeePathExtender;
import de.regnis.q.sequence.core.QSequenceDeePathForwardExtender;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.core.QSequenceMiddleSnakeFinderResult;

class QSequenceMiddleSnakeFinder {
    private final QSequenceDeePathForwardExtender forwardDeePathExtender;
    private final QSequenceDeePathBackwardExtender backwardDeePathExtender;
    private final QSequenceMiddleSnakeFinderResult result;
    private final int maximumSearchDepth;

    public QSequenceMiddleSnakeFinder(int n2, int n3, int n4) {
        this.maximumSearchDepth = n4;
        this.forwardDeePathExtender = new QSequenceDeePathForwardExtender(n2, n3);
        this.backwardDeePathExtender = new QSequenceDeePathBackwardExtender(n2, n3);
        this.result = new QSequenceMiddleSnakeFinderResult();
    }

    public QSequenceMiddleSnakeFinderResult getResult() {
        return this.result;
    }

    public int determineMiddleSnake(QSequenceMedia qSequenceMedia) {
        this.result.reset();
        this.forwardDeePathExtender.reset(qSequenceMedia);
        this.backwardDeePathExtender.reset(qSequenceMedia);
        int n2 = qSequenceMedia.getLeftLength() - qSequenceMedia.getRightLength();
        int n3 = (int)Math.ceil(((double)qSequenceMedia.getLeftLength() + (double)qSequenceMedia.getRightLength()) / 2.0);
        for (int i2 = 0; i2 <= n3; ++i2) {
            int n4;
            for (n4 = i2; n4 >= -i2; n4 -= 2) {
                this.forwardDeePathExtender.extendDeePath(qSequenceMedia, i2, n4);
                if (!QSequenceMiddleSnakeFinder.checkForwardOverlapping(n2, n4, i2) || !this.isForwardAndBackwardOverlapping(n4)) continue;
                QSequenceMiddleSnakeFinder.setMiddleSnake(this.result, this.forwardDeePathExtender, n4);
                return 2 * i2 - 1;
            }
            for (n4 = i2; n4 >= -i2; n4 -= 2) {
                int n5 = n4 + n2;
                this.backwardDeePathExtender.extendDeePath(qSequenceMedia, i2, n5);
                if (!QSequenceMiddleSnakeFinder.checkBackwardOverlapping(n2, n4, i2) || !this.isForwardAndBackwardOverlapping(n5)) continue;
                QSequenceMiddleSnakeFinder.setMiddleSnake(this.result, this.backwardDeePathExtender, n5);
                return 2 * i2;
            }
            if (i2 < this.maximumSearchDepth) continue;
            return this.determineBestSnake(qSequenceMedia, i2, n2);
        }
        QSequenceAssert.assertTrue(false);
        return 0;
    }

    private boolean isForwardAndBackwardOverlapping(int n2) {
        int n3;
        int n4 = this.forwardDeePathExtender.getLeft(n2);
        return n4 >= (n3 = this.backwardDeePathExtender.getLeft(n2));
    }

    private int determineBestSnake(QSequenceMedia qSequenceMedia, int n2, int n3) {
        int n4 = this.getBestForwardDiagonal(n2, n3);
        int n5 = this.getBestBackwardDiagonal(n2, n3);
        if (this.forwardDeePathExtender.getProgress(n4) > this.backwardDeePathExtender.getProgress(n5)) {
            int n6 = this.forwardDeePathExtender.getLeft(n4);
            int n7 = this.forwardDeePathExtender.getRight(n4);
            this.result.setMiddleSnake(n6, n7, n6, n7);
            return 2 * n2 - 1;
        }
        int n8 = this.backwardDeePathExtender.getLeft(n5);
        int n9 = this.backwardDeePathExtender.getRight(n5);
        if (n8 < 0 || n9 < 0) {
            this.backwardDeePathExtender.print(qSequenceMedia, -n2 + n3, n2 + n3);
        }
        this.result.setMiddleSnake(n8, n9, n8, n9);
        return 2 * n2;
    }

    private int getBestForwardDiagonal(int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = n4 = n3 >= 0 ? n2 : -n2;
        while (n3 >= 0 ? n4 >= -n2 : n4 <= n2) {
            int n8 = this.forwardDeePathExtender.getProgress(n4);
            if (n8 > n6) {
                n5 = n4;
                n6 = n8;
            }
            n4 += n3 >= 0 ? -2 : 2;
        }
        return n5;
    }

    private int getBestBackwardDiagonal(int n2, int n3) {
        int n4;
        int n5 = n3;
        int n6 = 0;
        int n7 = n4 = n3 >= 0 ? -n2 : n2;
        while (n3 >= 0 ? n4 <= n2 : n4 >= -n2) {
            int n8 = n4 + n3;
            int n9 = this.backwardDeePathExtender.getProgress(n8);
            if (n9 > n6) {
                n5 = n8;
                n6 = n9;
            }
            n4 += n3 >= 0 ? 2 : -2;
        }
        return n5;
    }

    public static void setMiddleSnake(QSequenceMiddleSnakeFinderResult qSequenceMiddleSnakeFinderResult, QSequenceDeePathExtender qSequenceDeePathExtender, int n2) {
        qSequenceMiddleSnakeFinderResult.setMiddleSnake(Math.min(qSequenceDeePathExtender.getLeft(n2), qSequenceDeePathExtender.getSnakeStartLeft()), Math.min(qSequenceDeePathExtender.getRight(n2), qSequenceDeePathExtender.getSnakeStartRight()), Math.max(qSequenceDeePathExtender.getLeft(n2), qSequenceDeePathExtender.getSnakeStartLeft()), Math.max(qSequenceDeePathExtender.getRight(n2), qSequenceDeePathExtender.getSnakeStartRight()));
    }

    private static boolean checkForwardOverlapping(int n2, int n3, int n4) {
        return n3 >= n2 - (n4 - 1) && n3 <= n2 + (n4 - 1);
    }

    private static boolean checkBackwardOverlapping(int n2, int n3, int n4) {
        return n3 + n2 >= -n4 && n3 + n2 <= n4;
    }
}

