/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence.core;

import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.core.QSequenceMiddleSnakeFinder;
import de.regnis.q.sequence.core.QSequenceRestrictedMedia;
import de.regnis.q.sequence.core.QSequenceSnakeRegister;

public class QSequenceAlgorithm {
    public static final boolean ASSERTIONS = true;
    private final QSequenceMedia mainMedia;
    private final QSequenceSnakeRegister snakeRegister;
    private final QSequenceMiddleSnakeFinder finder;

    public QSequenceAlgorithm(QSequenceMedia qSequenceMedia, QSequenceSnakeRegister qSequenceSnakeRegister, int n2) {
        QSequenceAssert.assertTrue(n2 >= 2);
        this.mainMedia = qSequenceMedia;
        this.snakeRegister = qSequenceSnakeRegister;
        this.finder = new QSequenceMiddleSnakeFinder(qSequenceMedia.getLeftLength(), qSequenceMedia.getRightLength(), n2);
    }

    public void produceSnakesInOrder() {
        QSequenceRestrictedMedia qSequenceRestrictedMedia = new QSequenceRestrictedMedia(this.mainMedia);
        this.produceSnakesInOrder(qSequenceRestrictedMedia);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceSnakesInOrder(QSequenceRestrictedMedia qSequenceRestrictedMedia) {
        int n2 = qSequenceRestrictedMedia.getLeftLength();
        int n3 = qSequenceRestrictedMedia.getRightLength();
        if (n2 < 1 || n3 < 1) {
            return;
        }
        int n4 = this.finder.determineMiddleSnake(qSequenceRestrictedMedia);
        if (n4 <= 0) {
            this.registerSnake(qSequenceRestrictedMedia, 1, n2, 1, n3);
            return;
        }
        int n5 = this.finder.getResult().getLeftFrom();
        int n6 = this.finder.getResult().getRightFrom();
        int n7 = this.finder.getResult().getLeftTo();
        int n8 = this.finder.getResult().getRightTo();
        if (n4 == 1) {
            if (n3 == n2 + 1) {
                this.registerSnake(qSequenceRestrictedMedia, 1, n5, 1, n6 - 1);
                this.registerSnake(qSequenceRestrictedMedia, n5 + 1, n7, n6 + 1, n8);
            } else if (n2 == n3 + 1) {
                this.registerSnake(qSequenceRestrictedMedia, 1, n5 - 1, 1, n6);
                this.registerSnake(qSequenceRestrictedMedia, n5 + 1, n7, n6 + 1, n8);
            } else {
                QSequenceAssert.assertTrue(false);
            }
            return;
        }
        int n9 = qSequenceRestrictedMedia.getLeftMin();
        int n10 = qSequenceRestrictedMedia.getRightMin();
        int n11 = qSequenceRestrictedMedia.getLeftMax();
        int n12 = qSequenceRestrictedMedia.getRightMax();
        try {
            qSequenceRestrictedMedia.restrictTo(n9, n9 + n5 - 1, n10, n10 + n6 - 1);
            this.produceSnakesInOrder(qSequenceRestrictedMedia);
            qSequenceRestrictedMedia.restrictTo(n9, n11, n10, n12);
            this.registerSnake(qSequenceRestrictedMedia, n5 + 1, n7, n6 + 1, n8);
            qSequenceRestrictedMedia.restrictTo(n9 + n7 - 1 + 1, n11, n10 + n8 - 1 + 1, n12);
            this.produceSnakesInOrder(qSequenceRestrictedMedia);
        }
        finally {
            qSequenceRestrictedMedia.restrictTo(n9, n11, n10, n12);
        }
    }

    private void registerSnake(QSequenceRestrictedMedia qSequenceRestrictedMedia, int n2, int n3, int n4, int n5) {
        QSequenceAssert.assertTrue(n3 - n2 == n5 - n4);
        if (n2 > n3 || n4 > n5) {
            return;
        }
        for (int i2 = 0; i2 < n3 - n2; ++i2) {
            QSequenceAssert.assertTrue(qSequenceRestrictedMedia.equals(n2 + i2, n4 + i2));
        }
        n2 = qSequenceRestrictedMedia.getLeftMin() + n2 - 1;
        n3 = qSequenceRestrictedMedia.getLeftMin() + n3 - 1;
        n4 = qSequenceRestrictedMedia.getRightMin() + n4 - 1;
        n5 = qSequenceRestrictedMedia.getRightMin() + n5 - 1;
        this.snakeRegister.registerSnake(n2 - 1, n3 - 1, n4 - 1, n5 - 1);
    }
}

