/*
 * Decompiled with CFR 0.152.
 */
package de.regnis.q.sequence;

import de.regnis.q.sequence.QSequenceCommonBlockFactory;
import de.regnis.q.sequence.QSequenceCommonBlocks;
import de.regnis.q.sequence.QSequenceDifferenceBlock;
import de.regnis.q.sequence.core.QSequenceAlgorithm;
import de.regnis.q.sequence.core.QSequenceAssert;
import de.regnis.q.sequence.core.QSequenceMedia;
import de.regnis.q.sequence.core.QSequenceSnakeRegister;
import de.regnis.q.sequence.media.QSequenceMediaIndexTransformer;
import java.util.List;

public class QSequenceDifference
implements QSequenceCommonBlockFactory,
QSequenceSnakeRegister {
    private final QSequenceMedia media;
    private final QSequenceMediaIndexTransformer indexTransformer;
    private final boolean[] leftCommonPoints;
    private final boolean[] rightCommonPoints;
    private final int maximumSearchDepth;

    public QSequenceDifference(QSequenceMedia qSequenceMedia, QSequenceMediaIndexTransformer qSequenceMediaIndexTransformer) {
        this(qSequenceMedia, qSequenceMediaIndexTransformer, Integer.MAX_VALUE);
    }

    public QSequenceDifference(QSequenceMedia qSequenceMedia, QSequenceMediaIndexTransformer qSequenceMediaIndexTransformer, int n2) {
        QSequenceAssert.assertNotNull(qSequenceMedia);
        QSequenceAssert.assertNotNull(qSequenceMediaIndexTransformer);
        this.media = qSequenceMedia;
        this.indexTransformer = qSequenceMediaIndexTransformer;
        this.leftCommonPoints = new boolean[qSequenceMediaIndexTransformer.getMediaLeftLength()];
        this.rightCommonPoints = new boolean[qSequenceMediaIndexTransformer.getMediaRightLength()];
        this.maximumSearchDepth = n2;
    }

    public void registerSnake(int n2, int n3, int n4, int n5) {
        int n6;
        for (n6 = n2; n6 <= n3; ++n6) {
            QSequenceAssert.assertTrue(!this.leftCommonPoints[this.indexTransformer.getMediaLeftIndex(n6)]);
            this.leftCommonPoints[this.indexTransformer.getMediaLeftIndex((int)n6)] = true;
        }
        for (n6 = n4; n6 <= n5; ++n6) {
            QSequenceAssert.assertTrue(!this.rightCommonPoints[this.indexTransformer.getMediaRightIndex(n6)]);
            this.rightCommonPoints[this.indexTransformer.getMediaRightIndex((int)n6)] = true;
        }
    }

    public Object createCommonBlock(int n2, int n3, int n4, int n5) {
        return null;
    }

    public Object createDistinctBlock(int n2, int n3, int n4, int n5) {
        return new QSequenceDifferenceBlock(n2, n3, n4, n5);
    }

    public List getBlocks() {
        QSequenceAlgorithm qSequenceAlgorithm = new QSequenceAlgorithm(this.media, this, this.maximumSearchDepth);
        qSequenceAlgorithm.produceSnakesInOrder();
        return QSequenceCommonBlocks.createBlocks(this.leftCommonPoints, this.rightCommonPoints, this);
    }
}

