/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.transport;

import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.ConnectionMonitor;
import com.trilead.ssh2.DHGexParameters;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.HTTPProxyException;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.crypto.CryptoWishList;
import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.digest.MAC;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.PacketDisconnect;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.transport.ClientServerHello;
import com.trilead.ssh2.transport.KexManager;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.TransportConnection;
import com.trilead.ssh2.transport.TransportManager$1;
import com.trilead.ssh2.transport.TransportManager$AsynchronousWorker;
import com.trilead.ssh2.transport.TransportManager$HandlerEntry;
import com.trilead.ssh2.util.Tokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Vector;

public class TransportManager {
    private static final Logger log = Logger.getLogger(TransportManager.class);
    private final Vector asynchronousQueue = new Vector();
    private Thread asynchronousThread = null;
    String hostname;
    int port;
    final Socket sock = new Socket();
    Object connectionSemaphore = new Object();
    boolean flagKexOngoing = false;
    boolean connectionClosed = false;
    Throwable reasonClosedCause = null;
    TransportConnection tc;
    KexManager km;
    Vector messageHandlers = new Vector();
    Thread receiveThread;
    Vector connectionMonitors = new Vector();
    boolean monitorsWereInformed = false;
    private ClientServerHello versions;

    private InetAddress createInetAddress(String string) {
        InetAddress inetAddress = this.parseIPv4Address(string);
        if (inetAddress != null) {
            return inetAddress;
        }
        return InetAddress.getByName(string);
    }

    private InetAddress parseIPv4Address(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = Tokenizer.parseTokens(string, '.');
        if (stringArray == null || stringArray.length != 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            int n2 = 0;
            if (stringArray[i2].length() == 0 || stringArray[i2].length() > 3) {
                return null;
            }
            for (int i3 = 0; i3 < stringArray[i2].length(); ++i3) {
                char c2 = stringArray[i2].charAt(i3);
                if (c2 < '0' || c2 > '9') {
                    return null;
                }
                n2 = n2 * 10 + (c2 - 48);
            }
            if (n2 > 255) {
                return null;
            }
            byArray[i2] = (byte)n2;
        }
        return InetAddress.getByAddress(string, byArray);
    }

    public TransportManager(String string, int n2) {
        this.hostname = string;
        this.port = n2;
    }

    public int getPacketOverheadEstimate() {
        return this.tc.getPacketOverheadEstimate();
    }

    public void setTcpNoDelay(boolean bl2) {
        this.sock.setTcpNoDelay(bl2);
    }

    public void setSoTimeout(int n2) {
        this.sock.setSoTimeout(n2);
    }

    public ConnectionInfo getConnectionInfo(int n2) {
        return this.km.getOrWaitForConnectionInfo(n2);
    }

    public ClientServerHello getVersionInfo() {
        return this.versions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getReasonClosedCause() {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            return this.reasonClosedCause;
        }
    }

    public byte[] getSessionIdentifier() {
        return this.km.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Throwable throwable, boolean bl2) {
        Object object;
        if (!bl2) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object2 = this.connectionSemaphore;
        synchronized (object2) {
            if (!this.connectionClosed) {
                if (bl2) {
                    try {
                        object = new PacketDisconnect(11, throwable.getMessage(), "").getPayload();
                        if (this.tc != null) {
                            this.tc.sendMessage((byte[])object);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        this.sock.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.connectionClosed = true;
                this.reasonClosedCause = throwable;
            }
            this.connectionSemaphore.notifyAll();
        }
        object2 = null;
        object = this;
        synchronized (object) {
            if (!this.monitorsWereInformed) {
                this.monitorsWereInformed = true;
                object2 = (Vector)this.connectionMonitors.clone();
            }
        }
        if (object2 != null) {
            for (int i2 = 0; i2 < ((Vector)object2).size(); ++i2) {
                try {
                    ConnectionMonitor connectionMonitor = (ConnectionMonitor)((Vector)object2).elementAt(i2);
                    connectionMonitor.connectionLost(this.reasonClosedCause);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void establishConnection(ProxyData proxyData, int n2, int n3) {
        if (proxyData == null) {
            InetAddress inetAddress = this.createInetAddress(this.hostname);
            this.sock.connect(new InetSocketAddress(inetAddress, this.port), n2);
            this.sock.setSoTimeout(n3);
            return;
        }
        if (proxyData instanceof HTTPProxyData) {
            Object[] objectArray;
            Object object;
            HTTPProxyData hTTPProxyData = (HTTPProxyData)proxyData;
            InetAddress inetAddress = this.createInetAddress(hTTPProxyData.proxyHost);
            this.sock.connect(new InetSocketAddress(inetAddress, hTTPProxyData.proxyPort), n2);
            this.sock.setSoTimeout(n3);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CONNECT ");
            stringBuffer.append(this.hostname);
            stringBuffer.append(':');
            stringBuffer.append(this.port);
            stringBuffer.append(" HTTP/1.0\r\n");
            if (hTTPProxyData.proxyUser != null && hTTPProxyData.proxyPass != null) {
                object = hTTPProxyData.proxyUser + ":" + hTTPProxyData.proxyPass;
                objectArray = Base64.encode(((String)object).getBytes("ISO-8859-1"));
                stringBuffer.append("Proxy-Authorization: Basic ");
                stringBuffer.append((char[])objectArray);
                stringBuffer.append("\r\n");
            }
            if (hTTPProxyData.requestHeaderLines != null) {
                for (int i2 = 0; i2 < hTTPProxyData.requestHeaderLines.length; ++i2) {
                    if (hTTPProxyData.requestHeaderLines[i2] == null) continue;
                    stringBuffer.append(hTTPProxyData.requestHeaderLines[i2]);
                    stringBuffer.append("\r\n");
                }
            }
            stringBuffer.append("\r\n");
            object = this.sock.getOutputStream();
            ((OutputStream)object).write(stringBuffer.toString().getBytes("ISO-8859-1"));
            ((OutputStream)object).flush();
            objectArray = new byte[1024];
            InputStream inputStream = this.sock.getInputStream();
            int n4 = ClientServerHello.readLineRN(inputStream, (byte[])objectArray);
            String string = new String((byte[])objectArray, 0, n4, "ISO-8859-1");
            if (!string.startsWith("HTTP/")) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (string.length() < 14 || string.charAt(8) != ' ' || string.charAt(12) != ' ') {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            int n5 = 0;
            try {
                n5 = Integer.parseInt(string.substring(9, 12));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (n5 < 0 || n5 > 999) {
                throw new IOException("The proxy did not send back a valid HTTP response.");
            }
            if (n5 != 200) {
                throw new HTTPProxyException(string.substring(13), n5);
            }
            while ((n4 = ClientServerHello.readLineRN(inputStream, (byte[])objectArray)) != 0) {
            }
            return;
        }
        throw new IOException("Unsupported ProxyData");
    }

    public void initialize(CryptoWishList cryptoWishList, ServerHostKeyVerifier serverHostKeyVerifier, DHGexParameters dHGexParameters, int n2, SecureRandom secureRandom, ProxyData proxyData) {
        this.initialize(cryptoWishList, serverHostKeyVerifier, dHGexParameters, n2, 0, secureRandom, proxyData);
    }

    public void initialize(CryptoWishList cryptoWishList, ServerHostKeyVerifier serverHostKeyVerifier, DHGexParameters dHGexParameters, int n2, int n3, SecureRandom secureRandom, ProxyData proxyData) {
        ClientServerHello clientServerHello;
        this.establishConnection(proxyData, n2, n3);
        this.versions = clientServerHello = new ClientServerHello(this.sock.getInputStream(), this.sock.getOutputStream());
        this.tc = new TransportConnection(this.sock.getInputStream(), this.sock.getOutputStream(), secureRandom);
        this.km = new KexManager(this, clientServerHello, cryptoWishList, this.hostname, this.port, serverHostKeyVerifier, secureRandom);
        this.km.initiateKEX(cryptoWishList, dHGexParameters);
        this.receiveThread = new Thread(new TransportManager$1(this));
        this.receiveThread.setDaemon(true);
        this.receiveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageHandler(MessageHandler messageHandler, int n2, int n3) {
        TransportManager$HandlerEntry transportManager$HandlerEntry = new TransportManager$HandlerEntry(this);
        transportManager$HandlerEntry.mh = messageHandler;
        transportManager$HandlerEntry.low = n2;
        transportManager$HandlerEntry.high = n3;
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            this.messageHandlers.addElement(transportManager$HandlerEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageHandler(MessageHandler messageHandler, int n2, int n3) {
        Vector vector = this.messageHandlers;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.messageHandlers.size(); ++i2) {
                TransportManager$HandlerEntry transportManager$HandlerEntry = (TransportManager$HandlerEntry)this.messageHandlers.elementAt(i2);
                if (transportManager$HandlerEntry.mh != messageHandler || transportManager$HandlerEntry.low != n2 || transportManager$HandlerEntry.high != n3) continue;
                this.messageHandlers.removeElementAt(i2);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendKexMessage(byte[] byArray) {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            if (this.connectionClosed) {
                throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
            }
            this.flagKexOngoing = true;
            try {
                this.tc.sendMessage(byArray);
            }
            catch (IOException iOException) {
                this.close(iOException, false);
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kexFinished() {
        Object object = this.connectionSemaphore;
        synchronized (object) {
            this.flagKexOngoing = false;
            this.connectionSemaphore.notifyAll();
        }
    }

    public void forceKeyExchange(CryptoWishList cryptoWishList, DHGexParameters dHGexParameters) {
        this.km.initiateKEX(cryptoWishList, dHGexParameters);
    }

    public void changeRecvCipher(BlockCipher blockCipher, MAC mAC) {
        this.tc.changeRecvCipher(blockCipher, mAC);
    }

    public void changeSendCipher(BlockCipher blockCipher, MAC mAC) {
        this.tc.changeSendCipher(blockCipher, mAC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsynchronousMessage(byte[] byArray) {
        Vector vector = this.asynchronousQueue;
        synchronized (vector) {
            this.asynchronousQueue.addElement(byArray);
            if (this.asynchronousQueue.size() > 100) {
                throw new IOException("Error: the peer is not consuming our asynchronous replies.");
            }
            if (this.asynchronousThread == null) {
                this.asynchronousThread = new TransportManager$AsynchronousWorker(this);
                this.asynchronousThread.setDaemon(true);
                this.asynchronousThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionMonitors(Vector vector) {
        TransportManager transportManager = this;
        synchronized (transportManager) {
            this.connectionMonitors = (Vector)vector.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(byte[] byArray) {
        if (Thread.currentThread() == this.receiveThread) {
            throw new IOException("Assertion error: sendMessage may never be invoked by the receiver thread!");
        }
        Object object = this.connectionSemaphore;
        synchronized (object) {
            while (true) {
                if (this.connectionClosed) {
                    throw (IOException)new IOException("Sorry, this connection is closed.").initCause(this.reasonClosedCause);
                }
                if (!this.flagKexOngoing) break;
                try {
                    this.connectionSemaphore.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.tc.sendMessage(byArray);
            }
            catch (IOException iOException) {
                this.close(iOException, false);
                throw iOException;
            }
        }
    }

    public void receiveLoop() {
        byte[] byArray = new byte[35000];
        while (true) {
            int n2;
            Object object;
            int n3 = this.tc.receiveMessage(byArray, 0, byArray.length);
            int n4 = byArray[0] & 0xFF;
            if (n4 == 2) continue;
            if (n4 == 4) {
                if (!log.isEnabled()) continue;
                object = new TypesReader(byArray, 0, n3);
                ((TypesReader)object).readByte();
                ((TypesReader)object).readBoolean();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(((TypesReader)object).readString("UTF-8"));
                for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
                    n2 = stringBuffer.charAt(i2);
                    if (n2 >= 32 && n2 <= 126) continue;
                    stringBuffer.setCharAt(i2, '\ufffd');
                }
                log.log(50, "DEBUG Message from remote: '" + stringBuffer.toString() + "'");
                continue;
            }
            if (n4 == 3) {
                throw new IOException("Peer sent UNIMPLEMENTED message, that should not happen.");
            }
            if (n4 == 1) {
                object = new TypesReader(byArray, 0, n3);
                ((TypesReader)object).readByte();
                int n5 = ((TypesReader)object).readUINT32();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(((TypesReader)object).readString("UTF-8"));
                if (stringBuffer.length() > 255) {
                    stringBuffer.setLength(255);
                    stringBuffer.setCharAt(254, '.');
                    stringBuffer.setCharAt(253, '.');
                    stringBuffer.setCharAt(252, '.');
                }
                for (n2 = 0; n2 < stringBuffer.length(); ++n2) {
                    char c2 = stringBuffer.charAt(n2);
                    if (c2 >= ' ' && c2 <= '~') continue;
                    stringBuffer.setCharAt(n2, '\ufffd');
                }
                throw new IOException("Peer sent DISCONNECT message (reason code " + n5 + "): " + stringBuffer.toString());
            }
            if (n4 == 20 || n4 == 21 || n4 >= 30 && n4 <= 49) {
                this.km.handleMessage(byArray, n3);
                continue;
            }
            object = null;
            for (int i3 = 0; i3 < this.messageHandlers.size(); ++i3) {
                TransportManager$HandlerEntry transportManager$HandlerEntry = (TransportManager$HandlerEntry)this.messageHandlers.elementAt(i3);
                if (transportManager$HandlerEntry.low > n4 || n4 > transportManager$HandlerEntry.high) continue;
                object = transportManager$HandlerEntry.mh;
                break;
            }
            if (object == null) {
                throw new IOException("Unexpected SSH message (type " + n4 + ")");
            }
            object.handleMessage(byArray, n3);
        }
    }

    static /* synthetic */ Vector access$000(TransportManager transportManager) {
        return transportManager.asynchronousQueue;
    }

    static /* synthetic */ Thread access$102(TransportManager transportManager, Thread thread) {
        transportManager.asynchronousThread = thread;
        return transportManager.asynchronousThread;
    }

    static /* synthetic */ Logger access$200() {
        return log;
    }
}

