/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.transport;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.cipher.CipherInputStream;
import com.trilead.ssh2.crypto.cipher.CipherOutputStream;
import com.trilead.ssh2.crypto.cipher.NullCipher;
import com.trilead.ssh2.crypto.digest.MAC;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.Packets;
import com.trilead.ssh2.transport.ClientServerHello;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public class TransportConnection {
    private static final Logger log = Logger.getLogger(TransportConnection.class);
    int send_seq_number = 0;
    int recv_seq_number = 0;
    CipherInputStream cis;
    CipherOutputStream cos;
    boolean useRandomPadding = false;
    MAC send_mac;
    byte[] send_mac_buffer;
    int send_padd_blocksize = 8;
    MAC recv_mac;
    byte[] recv_mac_buffer;
    byte[] recv_mac_buffer_cmp;
    int recv_padd_blocksize = 8;
    final byte[] send_padding_buffer = new byte[256];
    final byte[] send_packet_header_buffer = new byte[5];
    final byte[] recv_padding_buffer = new byte[256];
    final byte[] recv_packet_header_buffer = new byte[5];
    boolean recv_packet_header_present = false;
    ClientServerHello csh;
    final SecureRandom rnd;

    public TransportConnection(InputStream inputStream, OutputStream outputStream, SecureRandom secureRandom) {
        this.cis = new CipherInputStream(new NullCipher(), inputStream);
        this.cos = new CipherOutputStream(new NullCipher(), outputStream);
        this.rnd = secureRandom;
    }

    public void changeRecvCipher(BlockCipher blockCipher, MAC mAC) {
        this.cis.changeCipher(blockCipher);
        this.recv_mac = mAC;
        this.recv_mac_buffer = mAC != null ? new byte[mAC.size()] : null;
        this.recv_mac_buffer_cmp = mAC != null ? new byte[mAC.size()] : null;
        this.recv_padd_blocksize = blockCipher.getBlockSize();
        if (this.recv_padd_blocksize < 8) {
            this.recv_padd_blocksize = 8;
        }
    }

    public void changeSendCipher(BlockCipher blockCipher, MAC mAC) {
        if (!(blockCipher instanceof NullCipher)) {
            this.useRandomPadding = true;
        }
        this.cos.changeCipher(blockCipher);
        this.send_mac = mAC;
        this.send_mac_buffer = mAC != null ? new byte[mAC.size()] : null;
        this.send_padd_blocksize = blockCipher.getBlockSize();
        if (this.send_padd_blocksize < 8) {
            this.send_padd_blocksize = 8;
        }
    }

    public void sendMessage(byte[] byArray) {
        this.sendMessage(byArray, 0, byArray.length, 0);
    }

    public void sendMessage(byte[] byArray, int n2, int n3) {
        this.sendMessage(byArray, n2, n3, 0);
    }

    public int getPacketOverheadEstimate() {
        return 9 + (this.send_padd_blocksize - 1) + this.send_mac_buffer.length;
    }

    public void sendMessage(byte[] byArray, int n2, int n3, int n4) {
        if (n4 < 4) {
            n4 = 4;
        } else if (n4 > 64) {
            n4 = 64;
        }
        int n5 = 5 + n3 + n4;
        int n6 = n5 % this.send_padd_blocksize;
        if (n6 != 0) {
            n5 += this.send_padd_blocksize - n6;
        }
        if (n5 < 16) {
            n5 = 16;
        }
        int n7 = n5 - (5 + n3);
        if (this.useRandomPadding) {
            for (int i2 = 0; i2 < n7; i2 += 4) {
                int n8 = this.rnd.nextInt();
                this.send_padding_buffer[i2] = (byte)n8;
                this.send_padding_buffer[i2 + 1] = (byte)(n8 >> 8);
                this.send_padding_buffer[i2 + 2] = (byte)(n8 >> 16);
                this.send_padding_buffer[i2 + 3] = (byte)(n8 >> 24);
            }
        } else {
            for (int i3 = 0; i3 < n7; ++i3) {
                this.send_padding_buffer[i3] = 0;
            }
        }
        this.send_packet_header_buffer[0] = (byte)(n5 - 4 >> 24);
        this.send_packet_header_buffer[1] = (byte)(n5 - 4 >> 16);
        this.send_packet_header_buffer[2] = (byte)(n5 - 4 >> 8);
        this.send_packet_header_buffer[3] = (byte)(n5 - 4);
        this.send_packet_header_buffer[4] = (byte)n7;
        this.cos.write(this.send_packet_header_buffer, 0, 5);
        this.cos.write(byArray, n2, n3);
        this.cos.write(this.send_padding_buffer, 0, n7);
        if (this.send_mac != null) {
            this.send_mac.initMac(this.send_seq_number);
            this.send_mac.update(this.send_packet_header_buffer, 0, 5);
            this.send_mac.update(byArray, n2, n3);
            this.send_mac.update(this.send_padding_buffer, 0, n7);
            this.send_mac.getMac(this.send_mac_buffer, 0);
            this.cos.writePlain(this.send_mac_buffer, 0, this.send_mac_buffer.length);
        }
        this.cos.flush();
        if (log.isEnabled()) {
            log.log(90, "Sent " + Packets.getMessageName(byArray[n2] & 0xFF) + " " + n3 + " bytes payload");
        }
        ++this.send_seq_number;
    }

    public int peekNextMessageLength() {
        if (!this.recv_packet_header_present) {
            this.cis.read(this.recv_packet_header_buffer, 0, 5);
            this.recv_packet_header_present = true;
        }
        int n2 = (this.recv_packet_header_buffer[0] & 0xFF) << 24 | (this.recv_packet_header_buffer[1] & 0xFF) << 16 | (this.recv_packet_header_buffer[2] & 0xFF) << 8 | this.recv_packet_header_buffer[3] & 0xFF;
        int n3 = this.recv_packet_header_buffer[4] & 0xFF;
        if (n2 > 35000 || n2 < 12) {
            throw new IOException("Illegal packet size! (" + n2 + ")");
        }
        int n4 = n2 - n3 - 1;
        if (n4 < 0) {
            throw new IOException("Illegal padding_length in packet from remote (" + n3 + ")");
        }
        return n4;
    }

    public int receiveMessage(byte[] byArray, int n2, int n3) {
        if (!this.recv_packet_header_present) {
            this.cis.read(this.recv_packet_header_buffer, 0, 5);
        } else {
            this.recv_packet_header_present = false;
        }
        int n4 = (this.recv_packet_header_buffer[0] & 0xFF) << 24 | (this.recv_packet_header_buffer[1] & 0xFF) << 16 | (this.recv_packet_header_buffer[2] & 0xFF) << 8 | this.recv_packet_header_buffer[3] & 0xFF;
        int n5 = this.recv_packet_header_buffer[4] & 0xFF;
        if (n4 > 35000 || n4 < 12) {
            throw new IOException("Illegal packet size! (" + n4 + ")");
        }
        int n6 = n4 - n5 - 1;
        if (n6 < 0) {
            throw new IOException("Illegal padding_length in packet from remote (" + n5 + ")");
        }
        if (n6 >= n3) {
            throw new IOException("Receive buffer too small (" + n3 + ", need " + n6 + ")");
        }
        this.cis.read(byArray, n2, n6);
        this.cis.read(this.recv_padding_buffer, 0, n5);
        if (this.recv_mac != null) {
            this.cis.readPlain(this.recv_mac_buffer, 0, this.recv_mac_buffer.length);
            this.recv_mac.initMac(this.recv_seq_number);
            this.recv_mac.update(this.recv_packet_header_buffer, 0, 5);
            this.recv_mac.update(byArray, n2, n6);
            this.recv_mac.update(this.recv_padding_buffer, 0, n5);
            this.recv_mac.getMac(this.recv_mac_buffer_cmp, 0);
            for (int i2 = 0; i2 < this.recv_mac_buffer.length; ++i2) {
                if (this.recv_mac_buffer[i2] == this.recv_mac_buffer_cmp[i2]) continue;
                throw new IOException("Remote sent corrupt MAC.");
            }
        }
        ++this.recv_seq_number;
        if (log.isEnabled()) {
            log.log(90, "Received " + Packets.getMessageName(byArray[n2] & 0xFF) + " " + n6 + " bytes payload");
        }
        return n6;
    }
}

