/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class TypesWriter {
    byte[] arr = new byte[256];
    int pos = 0;

    private void resize(int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.arr, 0, byArray, 0, this.arr.length);
        this.arr = byArray;
    }

    public int length() {
        return this.pos;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.arr, 0, byArray, 0, this.pos);
        return byArray;
    }

    public void getBytes(byte[] byArray) {
        System.arraycopy(this.arr, 0, byArray, 0, this.pos);
    }

    public void writeUINT32(int n2, int n3) {
        if (n3 + 4 > this.arr.length) {
            this.resize(n3 + 32);
        }
        this.arr[n3++] = (byte)(n2 >> 24);
        this.arr[n3++] = (byte)(n2 >> 16);
        this.arr[n3++] = (byte)(n2 >> 8);
        this.arr[n3++] = (byte)n2;
    }

    public void writeUINT32(int n2) {
        this.writeUINT32(n2, this.pos);
        this.pos += 4;
    }

    public void writeUINT64(long l2) {
        if (this.pos + 8 > this.arr.length) {
            this.resize(this.arr.length + 32);
        }
        this.arr[this.pos++] = (byte)(l2 >> 56);
        this.arr[this.pos++] = (byte)(l2 >> 48);
        this.arr[this.pos++] = (byte)(l2 >> 40);
        this.arr[this.pos++] = (byte)(l2 >> 32);
        this.arr[this.pos++] = (byte)(l2 >> 24);
        this.arr[this.pos++] = (byte)(l2 >> 16);
        this.arr[this.pos++] = (byte)(l2 >> 8);
        this.arr[this.pos++] = (byte)l2;
    }

    public void writeBoolean(boolean bl2) {
        if (this.pos + 1 > this.arr.length) {
            this.resize(this.arr.length + 32);
        }
        this.arr[this.pos++] = bl2 ? (byte)1 : 0;
    }

    public void writeByte(int n2, int n3) {
        if (n3 + 1 > this.arr.length) {
            this.resize(n3 + 32);
        }
        this.arr[n3] = (byte)n2;
    }

    public void writeByte(int n2) {
        this.writeByte(n2, this.pos);
        ++this.pos;
    }

    public void writeMPInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == 1 && byArray[0] == 0) {
            this.writeUINT32(0);
        } else {
            this.writeString(byArray, 0, byArray.length);
        }
    }

    public void writeBytes(byte[] byArray) {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) {
        if (this.pos + n3 > this.arr.length) {
            this.resize(this.arr.length + n3 + 32);
        }
        System.arraycopy(byArray, n2, this.arr, this.pos, n3);
        this.pos += n3;
    }

    public void writeString(byte[] byArray, int n2, int n3) {
        this.writeUINT32(n3);
        this.writeBytes(byArray, n2, n3);
    }

    public void writeString(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        this.writeUINT32(byArray.length);
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeString(String string, String string2) {
        byte[] byArray = string2 == null ? string.getBytes() : string.getBytes(string2);
        this.writeUINT32(byArray.length);
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeNameList(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i2]);
        }
        this.writeString(stringBuffer.toString());
    }
}

