/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.util.Tokenizer;
import java.io.IOException;
import java.math.BigInteger;

public class TypesReader {
    byte[] arr;
    int pos = 0;
    int max = 0;

    public TypesReader(byte[] byArray) {
        this.arr = byArray;
        this.pos = 0;
        this.max = byArray.length;
    }

    public TypesReader(byte[] byArray, int n2) {
        this.arr = byArray;
        this.pos = n2;
        this.max = byArray.length;
        if (this.pos < 0 || this.pos > byArray.length) {
            throw new IllegalArgumentException("Illegal offset.");
        }
    }

    public TypesReader(byte[] byArray, int n2, int n3) {
        this.arr = byArray;
        this.pos = n2;
        this.max = n2 + n3;
        if (this.pos < 0 || this.pos > byArray.length) {
            throw new IllegalArgumentException("Illegal offset.");
        }
        if (this.max < 0 || this.max > byArray.length) {
            throw new IllegalArgumentException("Illegal length.");
        }
    }

    public int readByte() {
        if (this.pos >= this.max) {
            throw new IOException("Packet too short.");
        }
        return this.arr[this.pos++] & 0xFF;
    }

    public byte[] readBytes(int n2) {
        if (this.pos + n2 > this.max) {
            throw new IOException("Packet too short.");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.arr, this.pos, byArray, 0, n2);
        this.pos += n2;
        return byArray;
    }

    public void readBytes(byte[] byArray, int n2, int n3) {
        if (this.pos + n3 > this.max) {
            throw new IOException("Packet too short.");
        }
        System.arraycopy(this.arr, this.pos, byArray, n2, n3);
        this.pos += n3;
    }

    public boolean readBoolean() {
        if (this.pos >= this.max) {
            throw new IOException("Packet too short.");
        }
        return this.arr[this.pos++] != 0;
    }

    public int readUINT32() {
        if (this.pos + 4 > this.max) {
            throw new IOException("Packet too short.");
        }
        return (this.arr[this.pos++] & 0xFF) << 24 | (this.arr[this.pos++] & 0xFF) << 16 | (this.arr[this.pos++] & 0xFF) << 8 | this.arr[this.pos++] & 0xFF;
    }

    public long readUINT64() {
        if (this.pos + 8 > this.max) {
            throw new IOException("Packet too short.");
        }
        long l2 = (this.arr[this.pos++] & 0xFF) << 24 | (this.arr[this.pos++] & 0xFF) << 16 | (this.arr[this.pos++] & 0xFF) << 8 | this.arr[this.pos++] & 0xFF;
        long l3 = (this.arr[this.pos++] & 0xFF) << 24 | (this.arr[this.pos++] & 0xFF) << 16 | (this.arr[this.pos++] & 0xFF) << 8 | this.arr[this.pos++] & 0xFF;
        return l2 << 32 | l3 & 0xFFFFFFFFL;
    }

    public BigInteger readMPINT() {
        byte[] byArray = this.readByteString();
        BigInteger bigInteger = byArray.length == 0 ? BigInteger.ZERO : new BigInteger(byArray);
        return bigInteger;
    }

    public byte[] readByteString() {
        int n2 = this.readUINT32();
        if (n2 + this.pos > this.max) {
            throw new IOException("Malformed SSH byte string.");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.arr, this.pos, byArray, 0, n2);
        this.pos += n2;
        return byArray;
    }

    public String readString(String string) {
        int n2 = this.readUINT32();
        if (n2 + this.pos > this.max) {
            throw new IOException("Malformed SSH string.");
        }
        String string2 = string == null ? new String(this.arr, this.pos, n2) : new String(this.arr, this.pos, n2, string);
        this.pos += n2;
        return string2;
    }

    public String readString() {
        int n2 = this.readUINT32();
        if (n2 + this.pos > this.max) {
            throw new IOException("Malformed SSH string.");
        }
        String string = new String(this.arr, this.pos, n2, "ISO-8859-1");
        this.pos += n2;
        return string;
    }

    public String[] readNameList() {
        return Tokenizer.parseTokens(this.readString(), ',');
    }

    public int remain() {
        return this.max - this.pos;
    }
}

