/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketUserauthRequestPublicKey {
    byte[] payload;
    String userName;
    String serviceName;
    String password;
    String pkAlgoName;
    byte[] pk;
    byte[] sig;

    public PacketUserauthRequestPublicKey(String string, String string2, String string3, byte[] byArray, byte[] byArray2) {
        this.serviceName = string;
        this.userName = string2;
        this.pkAlgoName = string3;
        this.pk = byArray;
        this.sig = byArray2;
    }

    public PacketUserauthRequestPublicKey(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 50) {
            throw new IOException("This is not a SSH_MSG_USERAUTH_REQUEST! (" + n4 + ")");
        }
        throw new IOException("Not implemented!");
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(50);
            typesWriter.writeString(this.userName);
            typesWriter.writeString(this.serviceName);
            typesWriter.writeString("publickey");
            typesWriter.writeBoolean(true);
            typesWriter.writeString(this.pkAlgoName);
            typesWriter.writeString(this.pk, 0, this.pk.length);
            typesWriter.writeString(this.sig, 0, this.sig.length);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

