/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import java.io.IOException;

public class PacketUserauthInfoRequest {
    byte[] payload;
    String name;
    String instruction;
    String languageTag;
    int numPrompts;
    String[] prompt;
    boolean[] echo;

    public PacketUserauthInfoRequest(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 60) {
            throw new IOException("This is not a SSH_MSG_USERAUTH_INFO_REQUEST! (" + n4 + ")");
        }
        this.name = typesReader.readString();
        this.instruction = typesReader.readString();
        this.languageTag = typesReader.readString();
        this.numPrompts = typesReader.readUINT32();
        this.prompt = new String[this.numPrompts];
        this.echo = new boolean[this.numPrompts];
        for (int i2 = 0; i2 < this.numPrompts; ++i2) {
            this.prompt[i2] = typesReader.readString();
            this.echo[i2] = typesReader.readBoolean();
        }
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_USERAUTH_INFO_REQUEST packet!");
        }
    }

    public boolean[] getEcho() {
        return this.echo;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getLanguageTag() {
        return this.languageTag;
    }

    public String getName() {
        return this.name;
    }

    public int getNumPrompts() {
        return this.numPrompts;
    }

    public String[] getPrompt() {
        return this.prompt;
    }
}

