/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketUserauthBanner {
    byte[] payload;
    String message;
    String language;

    public PacketUserauthBanner(String string, String string2) {
        this.message = string;
        this.language = string2;
    }

    public String getBanner() {
        return this.message;
    }

    public PacketUserauthBanner(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 53) {
            throw new IOException("This is not a SSH_MSG_USERAUTH_BANNER! (" + n4 + ")");
        }
        this.message = typesReader.readString("UTF-8");
        this.language = typesReader.readString();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_USERAUTH_REQUEST packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(53);
            typesWriter.writeString(this.message);
            typesWriter.writeString(this.language);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

