/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketServiceRequest {
    byte[] payload;
    String serviceName;

    public PacketServiceRequest(String string) {
        this.serviceName = string;
    }

    public PacketServiceRequest(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 5) {
            throw new IOException("This is not a SSH_MSG_SERVICE_REQUEST! (" + n4 + ")");
        }
        this.serviceName = typesReader.readString();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_SERVICE_REQUEST packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(5);
            typesWriter.writeString(this.serviceName);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

