/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketOpenSessionChannel {
    byte[] payload;
    int channelID;
    int initialWindowSize;
    int maxPacketSize;

    public PacketOpenSessionChannel(int n2, int n3, int n4) {
        this.channelID = n2;
        this.initialWindowSize = n3;
        this.maxPacketSize = n4;
    }

    public PacketOpenSessionChannel(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray);
        int n4 = typesReader.readByte();
        if (n4 != 90) {
            throw new IOException("This is not a SSH_MSG_CHANNEL_OPEN! (" + n4 + ")");
        }
        this.channelID = typesReader.readUINT32();
        this.initialWindowSize = typesReader.readUINT32();
        this.maxPacketSize = typesReader.readUINT32();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_CHANNEL_OPEN packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(90);
            typesWriter.writeString("session");
            typesWriter.writeUINT32(this.channelID);
            typesWriter.writeUINT32(this.initialWindowSize);
            typesWriter.writeUINT32(this.maxPacketSize);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

