/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import java.io.IOException;
import java.math.BigInteger;

public class PacketKexDhGexReply {
    byte[] payload;
    byte[] hostKey;
    BigInteger f;
    byte[] signature;

    public PacketKexDhGexReply(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 33) {
            throw new IOException("This is not a SSH_MSG_KEX_DH_GEX_REPLY! (" + n4 + ")");
        }
        this.hostKey = typesReader.readByteString();
        this.f = typesReader.readMPINT();
        this.signature = typesReader.readByteString();
        if (typesReader.remain() != 0) {
            throw new IOException("PADDING IN SSH_MSG_KEX_DH_GEX_REPLY!");
        }
    }

    public BigInteger getF() {
        return this.f;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

