/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import java.io.IOException;
import java.math.BigInteger;

public class PacketKexDhGexGroup {
    byte[] payload;
    BigInteger p;
    BigInteger g;

    public PacketKexDhGexGroup(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 31) {
            throw new IllegalArgumentException("This is not a SSH_MSG_KEX_DH_GEX_GROUP! (" + n4 + ")");
        }
        this.p = typesReader.readMPINT();
        this.g = typesReader.readMPINT();
        if (typesReader.remain() != 0) {
            throw new IOException("PADDING IN SSH_MSG_KEX_DH_GEX_GROUP!");
        }
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getP() {
        return this.p;
    }
}

