/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketIgnore {
    byte[] payload;
    byte[] data;

    public void setData(byte[] byArray) {
        this.data = byArray;
        this.payload = null;
    }

    public PacketIgnore() {
    }

    public PacketIgnore(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 2) {
            throw new IOException("This is not a SSH_MSG_IGNORE packet! (" + n4 + ")");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(2);
            if (this.data != null) {
                typesWriter.writeString(this.data, 0, this.data.length);
            } else {
                typesWriter.writeString("");
            }
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

