/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketChannelWindowAdjust {
    byte[] payload;
    public int recipientChannelID;
    public int windowChange;

    public PacketChannelWindowAdjust(int n2, int n3) {
        this.recipientChannelID = n2;
        this.windowChange = n3;
    }

    public PacketChannelWindowAdjust(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 93) {
            throw new IOException("This is not a SSH_MSG_CHANNEL_WINDOW_ADJUST! (" + n4 + ")");
        }
        this.recipientChannelID = typesReader.readUINT32();
        this.windowChange = typesReader.readUINT32();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_CHANNEL_WINDOW_ADJUST packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(93);
            typesWriter.writeUINT32(this.recipientChannelID);
            typesWriter.writeUINT32(this.windowChange);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

