/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketChannelOpenFailure {
    byte[] payload;
    public int recipientChannelID;
    public int reasonCode;
    public String description;
    public String languageTag;

    public PacketChannelOpenFailure(int n2, int n3, String string, String string2) {
        this.recipientChannelID = n2;
        this.reasonCode = n3;
        this.description = string;
        this.languageTag = string2;
    }

    public PacketChannelOpenFailure(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 92) {
            throw new IOException("This is not a SSH_MSG_CHANNEL_OPEN_FAILURE! (" + n4 + ")");
        }
        this.recipientChannelID = typesReader.readUINT32();
        this.reasonCode = typesReader.readUINT32();
        this.description = typesReader.readString();
        this.languageTag = typesReader.readString();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_CHANNEL_OPEN_FAILURE packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(92);
            typesWriter.writeUINT32(this.recipientChannelID);
            typesWriter.writeUINT32(this.reasonCode);
            typesWriter.writeString(this.description);
            typesWriter.writeString(this.languageTag);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

