/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.packets;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;

public class PacketChannelOpenConfirmation {
    byte[] payload;
    public int recipientChannelID;
    public int senderChannelID;
    public int initialWindowSize;
    public int maxPacketSize;

    public PacketChannelOpenConfirmation(int n2, int n3, int n4, int n5) {
        this.recipientChannelID = n2;
        this.senderChannelID = n3;
        this.initialWindowSize = n4;
        this.maxPacketSize = n5;
    }

    public PacketChannelOpenConfirmation(byte[] byArray, int n2, int n3) {
        this.payload = new byte[n3];
        System.arraycopy(byArray, n2, this.payload, 0, n3);
        TypesReader typesReader = new TypesReader(byArray, n2, n3);
        int n4 = typesReader.readByte();
        if (n4 != 91) {
            throw new IOException("This is not a SSH_MSG_CHANNEL_OPEN_CONFIRMATION! (" + n4 + ")");
        }
        this.recipientChannelID = typesReader.readUINT32();
        this.senderChannelID = typesReader.readUINT32();
        this.initialWindowSize = typesReader.readUINT32();
        this.maxPacketSize = typesReader.readUINT32();
        if (typesReader.remain() != 0) {
            throw new IOException("Padding in SSH_MSG_CHANNEL_OPEN_CONFIRMATION packet!");
        }
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeByte(91);
            typesWriter.writeUINT32(this.recipientChannelID);
            typesWriter.writeUINT32(this.senderChannelID);
            typesWriter.writeUINT32(this.initialWindowSize);
            typesWriter.writeUINT32(this.maxPacketSize);
            this.payload = typesWriter.getBytes();
        }
        return this.payload;
    }
}

