/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.digest;

import com.trilead.ssh2.crypto.digest.Digest;

public final class MD5
implements Digest {
    private int state0;
    private int state1;
    private int state2;
    private int state3;
    private long count;
    private final byte[] block = new byte[64];
    private final int[] x = new int[16];
    private static final byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public MD5() {
        this.reset();
    }

    private static final int FF(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n2 += (n3 & n4 | ~n3 & n5) + n6 + n8) << n7 | n2 >>> 32 - n7) + n3;
    }

    private static final int GG(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n2 += (n3 & n5 | n4 & ~n5) + n6 + n8) << n7 | n2 >>> 32 - n7) + n3;
    }

    private static final int HH(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n2 += (n3 ^ n4 ^ n5) + n6 + n8) << n7 | n2 >>> 32 - n7) + n3;
    }

    private static final int II(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n2 += (n4 ^ (n3 | ~n5)) + n6 + n8) << n7 | n2 >>> 32 - n7) + n3;
    }

    private static final void encode(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)n3;
        byArray[n2 + 1] = (byte)(n3 >> 8);
        byArray[n2 + 2] = (byte)(n3 >> 16);
        byArray[n2 + 3] = (byte)(n3 >> 24);
    }

    private final void transform(byte[] byArray, int n2) {
        int n3 = this.state0;
        int n4 = this.state1;
        int n5 = this.state2;
        int n6 = this.state3;
        int n7 = 0;
        while (n7 < 16) {
            this.x[n7] = byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
            ++n7;
            n2 += 4;
        }
        n3 = MD5.FF(n3, n4, n5, n6, this.x[0], 7, -680876936);
        n6 = MD5.FF(n6, n3, n4, n5, this.x[1], 12, -389564586);
        n5 = MD5.FF(n5, n6, n3, n4, this.x[2], 17, 606105819);
        n4 = MD5.FF(n4, n5, n6, n3, this.x[3], 22, -1044525330);
        n3 = MD5.FF(n3, n4, n5, n6, this.x[4], 7, -176418897);
        n6 = MD5.FF(n6, n3, n4, n5, this.x[5], 12, 1200080426);
        n5 = MD5.FF(n5, n6, n3, n4, this.x[6], 17, -1473231341);
        n4 = MD5.FF(n4, n5, n6, n3, this.x[7], 22, -45705983);
        n3 = MD5.FF(n3, n4, n5, n6, this.x[8], 7, 1770035416);
        n6 = MD5.FF(n6, n3, n4, n5, this.x[9], 12, -1958414417);
        n5 = MD5.FF(n5, n6, n3, n4, this.x[10], 17, -42063);
        n4 = MD5.FF(n4, n5, n6, n3, this.x[11], 22, -1990404162);
        n3 = MD5.FF(n3, n4, n5, n6, this.x[12], 7, 1804603682);
        n6 = MD5.FF(n6, n3, n4, n5, this.x[13], 12, -40341101);
        n5 = MD5.FF(n5, n6, n3, n4, this.x[14], 17, -1502002290);
        n4 = MD5.FF(n4, n5, n6, n3, this.x[15], 22, 1236535329);
        n3 = MD5.GG(n3, n4, n5, n6, this.x[1], 5, -165796510);
        n6 = MD5.GG(n6, n3, n4, n5, this.x[6], 9, -1069501632);
        n5 = MD5.GG(n5, n6, n3, n4, this.x[11], 14, 643717713);
        n4 = MD5.GG(n4, n5, n6, n3, this.x[0], 20, -373897302);
        n3 = MD5.GG(n3, n4, n5, n6, this.x[5], 5, -701558691);
        n6 = MD5.GG(n6, n3, n4, n5, this.x[10], 9, 38016083);
        n5 = MD5.GG(n5, n6, n3, n4, this.x[15], 14, -660478335);
        n4 = MD5.GG(n4, n5, n6, n3, this.x[4], 20, -405537848);
        n3 = MD5.GG(n3, n4, n5, n6, this.x[9], 5, 568446438);
        n6 = MD5.GG(n6, n3, n4, n5, this.x[14], 9, -1019803690);
        n5 = MD5.GG(n5, n6, n3, n4, this.x[3], 14, -187363961);
        n4 = MD5.GG(n4, n5, n6, n3, this.x[8], 20, 1163531501);
        n3 = MD5.GG(n3, n4, n5, n6, this.x[13], 5, -1444681467);
        n6 = MD5.GG(n6, n3, n4, n5, this.x[2], 9, -51403784);
        n5 = MD5.GG(n5, n6, n3, n4, this.x[7], 14, 1735328473);
        n4 = MD5.GG(n4, n5, n6, n3, this.x[12], 20, -1926607734);
        n3 = MD5.HH(n3, n4, n5, n6, this.x[5], 4, -378558);
        n6 = MD5.HH(n6, n3, n4, n5, this.x[8], 11, -2022574463);
        n5 = MD5.HH(n5, n6, n3, n4, this.x[11], 16, 1839030562);
        n4 = MD5.HH(n4, n5, n6, n3, this.x[14], 23, -35309556);
        n3 = MD5.HH(n3, n4, n5, n6, this.x[1], 4, -1530992060);
        n6 = MD5.HH(n6, n3, n4, n5, this.x[4], 11, 1272893353);
        n5 = MD5.HH(n5, n6, n3, n4, this.x[7], 16, -155497632);
        n4 = MD5.HH(n4, n5, n6, n3, this.x[10], 23, -1094730640);
        n3 = MD5.HH(n3, n4, n5, n6, this.x[13], 4, 681279174);
        n6 = MD5.HH(n6, n3, n4, n5, this.x[0], 11, -358537222);
        n5 = MD5.HH(n5, n6, n3, n4, this.x[3], 16, -722521979);
        n4 = MD5.HH(n4, n5, n6, n3, this.x[6], 23, 76029189);
        n3 = MD5.HH(n3, n4, n5, n6, this.x[9], 4, -640364487);
        n6 = MD5.HH(n6, n3, n4, n5, this.x[12], 11, -421815835);
        n5 = MD5.HH(n5, n6, n3, n4, this.x[15], 16, 530742520);
        n4 = MD5.HH(n4, n5, n6, n3, this.x[2], 23, -995338651);
        n3 = MD5.II(n3, n4, n5, n6, this.x[0], 6, -198630844);
        n6 = MD5.II(n6, n3, n4, n5, this.x[7], 10, 1126891415);
        n5 = MD5.II(n5, n6, n3, n4, this.x[14], 15, -1416354905);
        n4 = MD5.II(n4, n5, n6, n3, this.x[5], 21, -57434055);
        n3 = MD5.II(n3, n4, n5, n6, this.x[12], 6, 1700485571);
        n6 = MD5.II(n6, n3, n4, n5, this.x[3], 10, -1894986606);
        n5 = MD5.II(n5, n6, n3, n4, this.x[10], 15, -1051523);
        n4 = MD5.II(n4, n5, n6, n3, this.x[1], 21, -2054922799);
        n3 = MD5.II(n3, n4, n5, n6, this.x[8], 6, 1873313359);
        n6 = MD5.II(n6, n3, n4, n5, this.x[15], 10, -30611744);
        n5 = MD5.II(n5, n6, n3, n4, this.x[6], 15, -1560198380);
        n4 = MD5.II(n4, n5, n6, n3, this.x[13], 21, 1309151649);
        n3 = MD5.II(n3, n4, n5, n6, this.x[4], 6, -145523070);
        n6 = MD5.II(n6, n3, n4, n5, this.x[11], 10, -1120210379);
        n5 = MD5.II(n5, n6, n3, n4, this.x[2], 15, 718787259);
        n4 = MD5.II(n4, n5, n6, n3, this.x[9], 21, -343485551);
        this.state0 += n3;
        this.state1 += n4;
        this.state2 += n5;
        this.state3 += n6;
    }

    public final void reset() {
        this.count = 0L;
        this.state0 = 1732584193;
        this.state1 = -271733879;
        this.state2 = -1732584194;
        this.state3 = 271733878;
        for (int i2 = 0; i2 < 16; ++i2) {
            this.x[i2] = 0;
        }
    }

    public final void update(byte by) {
        int n2 = 64 - (int)(this.count & 0x3FL);
        ++this.count;
        this.block[64 - n2] = by;
        if (n2 == 1) {
            this.transform(this.block, 0);
        }
    }

    public final void update(byte[] byArray, int n2, int n3) {
        int n4 = 64 - (int)(this.count & 0x3FL);
        this.count += (long)n3;
        while (n3 > 0) {
            if (n3 < n4) {
                System.arraycopy(byArray, n2, this.block, 64 - n4, n3);
                break;
            }
            if (n4 == 64) {
                this.transform(byArray, n2);
            } else {
                System.arraycopy(byArray, n2, this.block, 64 - n4, n4);
                this.transform(this.block, 0);
            }
            n2 += n4;
            n3 -= n4;
            n4 = 64;
        }
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final void digest(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[8];
        MD5.encode(byArray2, 0, (int)(this.count << 3));
        MD5.encode(byArray2, 4, (int)(this.count >> 29));
        int n3 = (int)this.count & 0x3F;
        int n4 = n3 < 56 ? 56 - n3 : 120 - n3;
        this.update(padding, 0, n4);
        this.update(byArray2, 0, 8);
        MD5.encode(byArray, n2, this.state0);
        MD5.encode(byArray, n2 + 4, this.state1);
        MD5.encode(byArray, n2 + 8, this.state2);
        MD5.encode(byArray, n2 + 12, this.state3);
        this.reset();
    }

    public final void digest(byte[] byArray) {
        this.digest(byArray, 0);
    }

    public final int getDigestLength() {
        return 16;
    }
}

