/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.digest;

import com.trilead.ssh2.crypto.digest.Digest;
import com.trilead.ssh2.crypto.digest.HMAC;
import com.trilead.ssh2.crypto.digest.MD5;
import com.trilead.ssh2.crypto.digest.SHA1;

public final class MAC {
    Digest mac;
    int size;

    public static final String[] getMacList() {
        return new String[]{"hmac-sha1-96", "hmac-sha1", "hmac-md5-96", "hmac-md5"};
    }

    public static final void checkMacList(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            MAC.getKeyLen(stringArray[i2]);
        }
    }

    public static final int getKeyLen(String string) {
        if (string.equals("hmac-sha1")) {
            return 20;
        }
        if (string.equals("hmac-sha1-96")) {
            return 20;
        }
        if (string.equals("hmac-md5")) {
            return 16;
        }
        if (string.equals("hmac-md5-96")) {
            return 16;
        }
        throw new IllegalArgumentException("Unkown algorithm " + string);
    }

    public MAC(String string, byte[] byArray) {
        if (string.equals("hmac-sha1")) {
            this.mac = new HMAC(new SHA1(), byArray, 20);
        } else if (string.equals("hmac-sha1-96")) {
            this.mac = new HMAC(new SHA1(), byArray, 12);
        } else if (string.equals("hmac-md5")) {
            this.mac = new HMAC(new MD5(), byArray, 16);
        } else if (string.equals("hmac-md5-96")) {
            this.mac = new HMAC(new MD5(), byArray, 12);
        } else {
            throw new IllegalArgumentException("Unkown algorithm " + string);
        }
        this.size = this.mac.getDigestLength();
    }

    public final void initMac(int n2) {
        this.mac.reset();
        this.mac.update((byte)(n2 >> 24));
        this.mac.update((byte)(n2 >> 16));
        this.mac.update((byte)(n2 >> 8));
        this.mac.update((byte)n2);
    }

    public final void update(byte[] byArray, int n2, int n3) {
        this.mac.update(byArray, n2, n3);
    }

    public final void getMac(byte[] byArray, int n2) {
        this.mac.digest(byArray, n2);
    }

    public final int size() {
        return this.size;
    }
}

