/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import java.io.IOException;
import java.io.OutputStream;

public class CipherOutputStream {
    BlockCipher currentCipher;
    OutputStream bo;
    byte[] buffer;
    byte[] enc;
    int blockSize;
    int pos;
    final int BUFF_SIZE = 8196;
    byte[] out_buffer = new byte[8196];
    int out_buffer_pos = 0;

    public CipherOutputStream(BlockCipher blockCipher, OutputStream outputStream) {
        this.bo = outputStream;
        this.changeCipher(blockCipher);
    }

    private void internal_write(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = 8196 - this.out_buffer_pos;
            int n5 = n3 > n4 ? n4 : n3;
            System.arraycopy(byArray, n2, this.out_buffer, this.out_buffer_pos, n5);
            n2 += n5;
            this.out_buffer_pos += n5;
            n3 -= n5;
            if (this.out_buffer_pos < 8196) continue;
            this.bo.write(this.out_buffer, 0, 8196);
            this.out_buffer_pos = 0;
        }
    }

    private void internal_write(int n2) {
        this.out_buffer[this.out_buffer_pos++] = (byte)n2;
        if (this.out_buffer_pos >= 8196) {
            this.bo.write(this.out_buffer, 0, 8196);
            this.out_buffer_pos = 0;
        }
    }

    public void flush() {
        if (this.pos != 0) {
            throw new IOException("FATAL: cannot flush since crypto buffer is not aligned.");
        }
        if (this.out_buffer_pos > 0) {
            this.bo.write(this.out_buffer, 0, this.out_buffer_pos);
            this.out_buffer_pos = 0;
        }
        this.bo.flush();
    }

    public void changeCipher(BlockCipher blockCipher) {
        this.currentCipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.enc = new byte[this.blockSize];
        this.pos = 0;
    }

    private void writeBlock() {
        try {
            this.currentCipher.transformBlock(this.buffer, 0, this.enc, 0);
        }
        catch (Exception exception) {
            throw (IOException)new IOException("Error while decrypting block.").initCause(exception);
        }
        this.internal_write(this.enc, 0, this.blockSize);
        this.pos = 0;
    }

    public void write(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = this.blockSize - this.pos;
            int n5 = Math.min(n4, n3);
            System.arraycopy(byArray, n2, this.buffer, this.pos, n5);
            this.pos += n5;
            n2 += n5;
            n3 -= n5;
            if (this.pos < this.blockSize) continue;
            this.writeBlock();
        }
    }

    public void write(int n2) {
        this.buffer[this.pos++] = (byte)n2;
        if (this.pos >= this.blockSize) {
            this.writeBlock();
        }
    }

    public void writePlain(int n2) {
        if (this.pos != 0) {
            throw new IOException("Cannot write plain since crypto buffer is not aligned.");
        }
        this.internal_write(n2);
    }

    public void writePlain(byte[] byArray, int n2, int n3) {
        if (this.pos != 0) {
            throw new IOException("Cannot write plain since crypto buffer is not aligned.");
        }
        this.internal_write(byArray, n2, n3);
    }
}

