/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import java.io.IOException;
import java.io.InputStream;

public class CipherInputStream {
    BlockCipher currentCipher;
    InputStream bi;
    byte[] buffer;
    byte[] enc;
    int blockSize;
    int pos;
    final int BUFF_SIZE = 8196;
    byte[] input_buffer = new byte[8196];
    int input_buffer_pos = 0;
    int input_buffer_size = 0;

    public CipherInputStream(BlockCipher blockCipher, InputStream inputStream) {
        this.bi = inputStream;
        this.changeCipher(blockCipher);
    }

    private int fill_buffer() {
        this.input_buffer_pos = 0;
        this.input_buffer_size = this.bi.read(this.input_buffer, 0, 8196);
        return this.input_buffer_size;
    }

    private int internal_read(byte[] byArray, int n2, int n3) {
        if (this.input_buffer_size < 0) {
            return -1;
        }
        if (this.input_buffer_pos >= this.input_buffer_size && this.fill_buffer() <= 0) {
            return -1;
        }
        int n4 = this.input_buffer_size - this.input_buffer_pos;
        int n5 = n3 > n4 ? n4 : n3;
        System.arraycopy(this.input_buffer, this.input_buffer_pos, byArray, n2, n5);
        this.input_buffer_pos += n5;
        return n5;
    }

    public void changeCipher(BlockCipher blockCipher) {
        this.currentCipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
        this.enc = new byte[this.blockSize];
        this.pos = this.blockSize;
    }

    private void getBlock() {
        int n2;
        for (int i2 = 0; i2 < this.blockSize; i2 += n2) {
            n2 = this.internal_read(this.enc, i2, this.blockSize - i2);
            if (n2 >= 0) continue;
            throw new IOException("Cannot read full block, EOF reached.");
        }
        try {
            this.currentCipher.transformBlock(this.enc, 0, this.buffer, 0);
        }
        catch (Exception exception) {
            throw new IOException("Error while decrypting block.");
        }
        this.pos = 0;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n3 > 0) {
            if (this.pos >= this.blockSize) {
                this.getBlock();
            }
            int n5 = this.blockSize - this.pos;
            int n6 = Math.min(n5, n3);
            System.arraycopy(this.buffer, this.pos, byArray, n2, n6);
            this.pos += n6;
            n2 += n6;
            n3 -= n6;
            n4 += n6;
        }
        return n4;
    }

    public int read() {
        if (this.pos >= this.blockSize) {
            this.getBlock();
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int readPlain(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        if (this.pos != this.blockSize) {
            throw new IOException("Cannot read plain since crypto buffer is not aligned.");
        }
        for (n4 = 0; n4 < n3; n4 += n5) {
            n5 = this.internal_read(byArray, n2 + n4, n3 - n4);
            if (n5 >= 0) continue;
            throw new IOException("Cannot fill buffer, EOF reached.");
        }
        return n4;
    }
}

