/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;

public class CTRMode
implements BlockCipher {
    byte[] X;
    byte[] Xenc;
    BlockCipher bc;
    int blockSize;
    boolean doEncrypt;
    int count = 0;

    public void init(boolean bl2, byte[] byArray) {
    }

    public CTRMode(BlockCipher blockCipher, byte[] byArray, boolean bl2) {
        this.bc = blockCipher;
        this.blockSize = this.bc.getBlockSize();
        this.doEncrypt = bl2;
        if (this.blockSize != byArray.length) {
            throw new IllegalArgumentException("IV must be " + this.blockSize + " bytes long! (currently " + byArray.length + ")");
        }
        this.X = new byte[this.blockSize];
        this.Xenc = new byte[this.blockSize];
        System.arraycopy(byArray, 0, this.X, 0, this.blockSize);
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public final void transformBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        this.bc.transformBlock(this.X, 0, this.Xenc, 0);
        for (n4 = 0; n4 < this.blockSize; ++n4) {
            byArray2[n3 + n4] = (byte)(byArray[n2 + n4] ^ this.Xenc[n4]);
        }
        for (n4 = this.blockSize - 1; n4 >= 0; --n4) {
            int n5 = n4;
            this.X[n5] = (byte)(this.X[n5] + 1);
            if (this.X[n4] != 0) break;
        }
    }
}

