/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;

public class CBCMode
implements BlockCipher {
    BlockCipher tc;
    int blockSize;
    boolean doEncrypt;
    byte[] cbc_vector;
    byte[] tmp_vector;

    public void init(boolean bl2, byte[] byArray) {
    }

    public CBCMode(BlockCipher blockCipher, byte[] byArray, boolean bl2) {
        this.tc = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.doEncrypt = bl2;
        if (this.blockSize != byArray.length) {
            throw new IllegalArgumentException("IV must be " + this.blockSize + " bytes long! (currently " + byArray.length + ")");
        }
        this.cbc_vector = new byte[this.blockSize];
        this.tmp_vector = new byte[this.blockSize];
        System.arraycopy(byArray, 0, this.cbc_vector, 0, this.blockSize);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    private void encryptBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        for (int i2 = 0; i2 < this.blockSize; ++i2) {
            int n4 = i2;
            this.cbc_vector[n4] = (byte)(this.cbc_vector[n4] ^ byArray[n2 + i2]);
        }
        this.tc.transformBlock(this.cbc_vector, 0, byArray2, n3);
        System.arraycopy(byArray2, n3, this.cbc_vector, 0, this.blockSize);
    }

    private void decryptBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        System.arraycopy(byArray, n2, this.tmp_vector, 0, this.blockSize);
        this.tc.transformBlock(byArray, n2, byArray2, n3);
        for (int i2 = 0; i2 < this.blockSize; ++i2) {
            int n4 = n3 + i2;
            byArray2[n4] = (byte)(byArray2[n4] ^ this.cbc_vector[i2]);
        }
        byte[] byArray3 = this.cbc_vector;
        this.cbc_vector = this.tmp_vector;
        this.tmp_vector = byArray3;
    }

    public void transformBlock(byte[] byArray, int n2, byte[] byArray2, int n3) {
        if (this.doEncrypt) {
            this.encryptBlock(byArray, n2, byArray2, n3);
        } else {
            this.decryptBlock(byArray, n2, byArray2, n3);
        }
    }
}

