/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.cipher.BlockCipherFactory$CipherEntry;
import com.trilead.ssh2.crypto.cipher.CBCMode;
import com.trilead.ssh2.crypto.cipher.CTRMode;
import java.util.Vector;

public class BlockCipherFactory {
    static Vector ciphers = new Vector();

    public static String[] getDefaultCipherList() {
        String[] stringArray = new String[ciphers.size()];
        for (int i2 = 0; i2 < ciphers.size(); ++i2) {
            BlockCipherFactory$CipherEntry blockCipherFactory$CipherEntry = (BlockCipherFactory$CipherEntry)ciphers.elementAt(i2);
            stringArray[i2] = new String(blockCipherFactory$CipherEntry.type);
        }
        return stringArray;
    }

    public static void checkCipherList(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            BlockCipherFactory.getEntry(stringArray[i2]);
        }
    }

    public static BlockCipher createCipher(String string, boolean bl2, byte[] byArray, byte[] byArray2) {
        try {
            BlockCipherFactory$CipherEntry blockCipherFactory$CipherEntry = BlockCipherFactory.getEntry(string);
            Class<?> clazz = Class.forName(blockCipherFactory$CipherEntry.cipherClass);
            BlockCipher blockCipher = (BlockCipher)clazz.newInstance();
            if (string.endsWith("-cbc")) {
                blockCipher.init(bl2, byArray);
                return new CBCMode(blockCipher, byArray2, bl2);
            }
            if (string.endsWith("-ctr")) {
                blockCipher.init(true, byArray);
                return new CTRMode(blockCipher, byArray2, bl2);
            }
            throw new IllegalArgumentException("Cannot instantiate " + string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Cannot instantiate " + string);
        }
    }

    private static BlockCipherFactory$CipherEntry getEntry(String string) {
        for (int i2 = 0; i2 < ciphers.size(); ++i2) {
            BlockCipherFactory$CipherEntry blockCipherFactory$CipherEntry = (BlockCipherFactory$CipherEntry)ciphers.elementAt(i2);
            if (!blockCipherFactory$CipherEntry.type.equals(string)) continue;
            return blockCipherFactory$CipherEntry;
        }
        throw new IllegalArgumentException("Unkown algorithm " + string);
    }

    public static int getBlockSize(String string) {
        BlockCipherFactory$CipherEntry blockCipherFactory$CipherEntry = BlockCipherFactory.getEntry(string);
        return blockCipherFactory$CipherEntry.blocksize;
    }

    public static int getKeySize(String string) {
        BlockCipherFactory$CipherEntry blockCipherFactory$CipherEntry = BlockCipherFactory.getEntry(string);
        return blockCipherFactory$CipherEntry.keysize;
    }

    static {
        ciphers.addElement(new BlockCipherFactory$CipherEntry("aes256-ctr", 16, 32, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("aes192-ctr", 16, 24, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("aes128-ctr", 16, 16, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("blowfish-ctr", 8, 16, "com.trilead.ssh2.crypto.cipher.BlowFish"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("aes256-cbc", 16, 32, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("aes192-cbc", 16, 24, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("aes128-cbc", 16, 16, "com.trilead.ssh2.crypto.cipher.AES"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("blowfish-cbc", 8, 16, "com.trilead.ssh2.crypto.cipher.BlowFish"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("3des-ctr", 8, 24, "com.trilead.ssh2.crypto.cipher.DESede"));
        ciphers.addElement(new BlockCipherFactory$CipherEntry("3des-cbc", 8, 24, "com.trilead.ssh2.crypto.cipher.DESede"));
    }
}

