/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto;

import java.io.IOException;
import java.math.BigInteger;

public class SimpleDERReader {
    byte[] buffer;
    int pos;
    int count;

    public SimpleDERReader(byte[] byArray) {
        this.resetInput(byArray);
    }

    public SimpleDERReader(byte[] byArray, int n2, int n3) {
        this.resetInput(byArray, n2, n3);
    }

    public void resetInput(byte[] byArray) {
        this.resetInput(byArray, 0, byArray.length);
    }

    public void resetInput(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.pos = n2;
        this.count = n3;
    }

    private byte readByte() {
        if (this.count <= 0) {
            throw new IOException("DER byte array: out of data");
        }
        --this.count;
        return this.buffer[this.pos++];
    }

    private byte[] readBytes(int n2) {
        if (n2 > this.count) {
            throw new IOException("DER byte array: out of data");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buffer, this.pos, byArray, 0, n2);
        this.pos += n2;
        this.count -= n2;
        return byArray;
    }

    public int available() {
        return this.count;
    }

    private int readLength() {
        int n2 = this.readByte() & 0xFF;
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        int n3 = n2 & 0x7F;
        if (n3 == 0) {
            return -1;
        }
        n2 = 0;
        while (n3 > 0) {
            n2 <<= 8;
            n2 |= this.readByte() & 0xFF;
            --n3;
        }
        return n2;
    }

    public int ignoreNextObject() {
        int n2 = this.readByte() & 0xFF;
        int n3 = this.readLength();
        if (n3 < 0 || n3 > this.available()) {
            throw new IOException("Illegal len in DER object (" + n3 + ")");
        }
        this.readBytes(n3);
        return n2;
    }

    public BigInteger readInt() {
        int n2 = this.readByte() & 0xFF;
        if (n2 != 2) {
            throw new IOException("Expected DER Integer, but found type " + n2);
        }
        int n3 = this.readLength();
        if (n3 < 0 || n3 > this.available()) {
            throw new IOException("Illegal len in DER object (" + n3 + ")");
        }
        byte[] byArray = this.readBytes(n3);
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger;
    }

    public byte[] readSequenceAsByteArray() {
        int n2 = this.readByte() & 0xFF;
        if (n2 != 48) {
            throw new IOException("Expected DER Sequence, but found type " + n2);
        }
        int n3 = this.readLength();
        if (n3 < 0 || n3 > this.available()) {
            throw new IOException("Illegal len in DER object (" + n3 + ")");
        }
        byte[] byArray = this.readBytes(n3);
        return byArray;
    }

    public byte[] readOctetString() {
        int n2 = this.readByte() & 0xFF;
        if (n2 != 4) {
            throw new IOException("Expected DER Octetstring, but found type " + n2);
        }
        int n3 = this.readLength();
        if (n3 < 0 || n3 > this.available()) {
            throw new IOException("Illegal len in DER object (" + n3 + ")");
        }
        byte[] byArray = this.readBytes(n3);
        return byArray;
    }
}

