/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto;

import com.trilead.ssh2.crypto.digest.HashForSSH2Types;
import java.math.BigInteger;

public class KeyMaterial {
    public byte[] initial_iv_client_to_server;
    public byte[] initial_iv_server_to_client;
    public byte[] enc_key_client_to_server;
    public byte[] enc_key_server_to_client;
    public byte[] integrity_key_client_to_server;
    public byte[] integrity_key_server_to_client;

    private static byte[] calculateKey(HashForSSH2Types hashForSSH2Types, BigInteger bigInteger, byte[] byArray, byte by, byte[] byArray2, int n2) {
        byte[] byArray3 = new byte[n2];
        int n3 = hashForSSH2Types.getDigestLength();
        int n4 = (n2 + n3 - 1) / n3;
        byte[][] byArrayArray = new byte[n4][];
        hashForSSH2Types.reset();
        hashForSSH2Types.updateBigInt(bigInteger);
        hashForSSH2Types.updateBytes(byArray);
        hashForSSH2Types.updateByte(by);
        hashForSSH2Types.updateBytes(byArray2);
        byArrayArray[0] = hashForSSH2Types.getDigest();
        int n5 = 0;
        int n6 = Math.min(n3, n2);
        System.arraycopy(byArrayArray[0], 0, byArray3, n5, n6);
        n2 -= n6;
        n5 += n6;
        for (int i2 = 1; i2 < n4; ++i2) {
            hashForSSH2Types.updateBigInt(bigInteger);
            hashForSSH2Types.updateBytes(byArray);
            for (int i3 = 0; i3 < i2; ++i3) {
                hashForSSH2Types.updateBytes(byArrayArray[i3]);
            }
            byArrayArray[i2] = hashForSSH2Types.getDigest();
            n6 = Math.min(n3, n2);
            System.arraycopy(byArrayArray[i2], 0, byArray3, n5, n6);
            n2 -= n6;
            n5 += n6;
        }
        return byArray3;
    }

    public static KeyMaterial create(String string, byte[] byArray, BigInteger bigInteger, byte[] byArray2, int n2, int n3, int n4, int n5, int n6, int n7) {
        KeyMaterial keyMaterial = new KeyMaterial();
        HashForSSH2Types hashForSSH2Types = new HashForSSH2Types(string);
        keyMaterial.initial_iv_client_to_server = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)65, byArray2, n3);
        keyMaterial.initial_iv_server_to_client = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)66, byArray2, n6);
        keyMaterial.enc_key_client_to_server = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)67, byArray2, n2);
        keyMaterial.enc_key_server_to_client = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)68, byArray2, n5);
        keyMaterial.integrity_key_client_to_server = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)69, byArray2, n4);
        keyMaterial.integrity_key_server_to_client = KeyMaterial.calculateKey(hashForSSH2Types, bigInteger, byArray, (byte)70, byArray2, n7);
        return keyMaterial;
    }
}

