/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.Channel;
import com.trilead.ssh2.channel.ChannelInputStream;
import com.trilead.ssh2.channel.ChannelOutputStream;
import com.trilead.ssh2.channel.StreamForwarder;
import com.trilead.ssh2.channel.X11ServerData;
import com.trilead.ssh2.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class RemoteX11AcceptThread
extends Thread {
    private static final Logger log = Logger.getLogger(RemoteX11AcceptThread.class);
    Channel c;
    String remoteOriginatorAddress;
    int remoteOriginatorPort;
    Socket s;

    public RemoteX11AcceptThread(Channel channel, String string, int n2) {
        this.c = channel;
        this.remoteOriginatorAddress = string;
        this.remoteOriginatorPort = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object;
            Object object2;
            this.c.cm.sendOpenConfirmation(this.c);
            ChannelOutputStream channelOutputStream = this.c.getStdinStream();
            ChannelInputStream channelInputStream = this.c.getStdoutStream();
            byte[] byArray = new byte[6];
            if (((InputStream)channelInputStream).read(byArray) != 6) {
                throw new IOException("Unexpected EOF on X11 startup!");
            }
            if (byArray[0] != 66 && byArray[0] != 108) {
                throw new IOException("Unknown endian format in X11 message!");
            }
            int n2 = byArray[0] == 66 ? 0 : 1;
            byte[] byArray2 = new byte[6];
            if (((InputStream)channelInputStream).read(byArray2) != 6) {
                throw new IOException("Unexpected EOF on X11 startup!");
            }
            int n3 = (byArray2[n2] & 0xFF) << 8 | byArray2[1 - n2] & 0xFF;
            int n4 = (byArray2[2 + n2] & 0xFF) << 8 | byArray2[3 - n2] & 0xFF;
            if (n3 > 256 || n4 > 256) {
                throw new IOException("Buggy X11 authorization data");
            }
            int n5 = (4 - n3 % 4) % 4;
            int n6 = (4 - n4 % 4) % 4;
            byte[] byArray3 = new byte[n3];
            byte[] byArray4 = new byte[n4];
            byte[] byArray5 = new byte[4];
            if (((InputStream)channelInputStream).read(byArray3) != n3) {
                throw new IOException("Unexpected EOF on X11 startup! (authProtocolName)");
            }
            if (((InputStream)channelInputStream).read(byArray5, 0, n5) != n5) {
                throw new IOException("Unexpected EOF on X11 startup! (authProtocolNamePadding)");
            }
            if (((InputStream)channelInputStream).read(byArray4) != n4) {
                throw new IOException("Unexpected EOF on X11 startup! (authProtocolData)");
            }
            if (((InputStream)channelInputStream).read(byArray5, 0, n6) != n6) {
                throw new IOException("Unexpected EOF on X11 startup! (authProtocolDataPadding)");
            }
            if (!"MIT-MAGIC-COOKIE-1".equals(new String(byArray3, "ISO-8859-1"))) {
                throw new IOException("Unknown X11 authorization protocol!");
            }
            if (n4 != 16) {
                throw new IOException("Wrong data length for X11 authorization data!");
            }
            StringBuffer stringBuffer = new StringBuffer(32);
            for (int i2 = 0; i2 < byArray4.length; ++i2) {
                object2 = Integer.toHexString(byArray4[i2] & 0xFF);
                stringBuffer.append((String)(((String)object2).length() == 2 ? object2 : "0" + (String)object2));
            }
            String string = stringBuffer.toString();
            object2 = this.c;
            synchronized (object2) {
                this.c.hexX11FakeCookie = string;
            }
            object2 = this.c.cm.checkX11Cookie(string);
            if (object2 == null) {
                throw new IOException("Invalid X11 cookie received.");
            }
            this.s = new Socket(((X11ServerData)object2).hostname, ((X11ServerData)object2).port);
            OutputStream outputStream = this.s.getOutputStream();
            InputStream inputStream = this.s.getInputStream();
            outputStream.write(byArray);
            if (((X11ServerData)object2).x11_magic_cookie == null) {
                object = new byte[6];
                outputStream.write((byte[])object);
            } else {
                if (((X11ServerData)object2).x11_magic_cookie.length != 16) {
                    throw new IOException("The real X11 cookie has an invalid length!");
                }
                outputStream.write(byArray2);
                outputStream.write(byArray3);
                outputStream.write(byArray5, 0, n5);
                outputStream.write(((X11ServerData)object2).x11_magic_cookie);
                outputStream.write(byArray5, 0, n6);
            }
            outputStream.flush();
            object = new StreamForwarder(this.c, null, null, channelInputStream, outputStream, "RemoteToX11");
            StreamForwarder streamForwarder = new StreamForwarder(this.c, null, null, inputStream, channelOutputStream, "X11ToRemote");
            ((Thread)object).setDaemon(true);
            ((Thread)object).start();
            streamForwarder.run();
            while (((Thread)object).isAlive()) {
                try {
                    ((Thread)object).join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.c.cm.closeChannel(this.c, "EOF on both X11 streams reached.", true);
            this.s.close();
        }
        catch (IOException iOException) {
            log.log(50, "IOException in X11 proxy code: " + iOException.getMessage());
            try {
                this.c.cm.closeChannel(this.c, "IOException in X11 proxy code (" + iOException.getMessage() + ")", true);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                if (this.s != null) {
                    this.s.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
    }
}

