/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.Channel;
import com.trilead.ssh2.channel.StreamForwarder;
import com.trilead.ssh2.log.Logger;
import java.io.IOException;
import java.net.Socket;

public class RemoteAcceptThread
extends Thread {
    private static final Logger log = Logger.getLogger(RemoteAcceptThread.class);
    Channel c;
    String remoteConnectedAddress;
    int remoteConnectedPort;
    String remoteOriginatorAddress;
    int remoteOriginatorPort;
    String targetAddress;
    int targetPort;
    Socket s;

    public RemoteAcceptThread(Channel channel, String string, int n2, String string2, int n3, String string3, int n4) {
        this.c = channel;
        this.remoteConnectedAddress = string;
        this.remoteConnectedPort = n2;
        this.remoteOriginatorAddress = string2;
        this.remoteOriginatorPort = n3;
        this.targetAddress = string3;
        this.targetPort = n4;
        if (log.isEnabled()) {
            log.log(20, "RemoteAcceptThread: " + string + "/" + n2 + ", R: " + string2 + "/" + n3);
        }
    }

    public void run() {
        try {
            this.c.cm.sendOpenConfirmation(this.c);
            this.s = new Socket(this.targetAddress, this.targetPort);
            StreamForwarder streamForwarder = new StreamForwarder(this.c, null, null, this.c.getStdoutStream(), this.s.getOutputStream(), "RemoteToLocal");
            StreamForwarder streamForwarder2 = new StreamForwarder(this.c, null, null, this.s.getInputStream(), this.c.getStdinStream(), "LocalToRemote");
            streamForwarder.setDaemon(true);
            streamForwarder.start();
            streamForwarder2.run();
            while (streamForwarder.isAlive()) {
                try {
                    streamForwarder.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.c.cm.closeChannel(this.c, "EOF on both streams reached.", true);
            this.s.close();
        }
        catch (IOException iOException) {
            log.log(50, "IOException in proxy code: " + iOException.getMessage());
            try {
                this.c.cm.closeChannel(this.c, "IOException in proxy code (" + iOException.getMessage() + ")", true);
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                if (this.s != null) {
                    this.s.close();
                }
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
    }
}

