/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.Channel;
import java.io.IOException;
import java.io.OutputStream;

public final class ChannelOutputStream
extends OutputStream {
    Channel c;
    boolean isClosed = false;

    ChannelOutputStream(Channel channel) {
        this.c = channel;
    }

    public void write(int n2) {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.c.cm.sendEOF(this.c);
        }
    }

    public void flush() {
        if (this.isClosed) {
            throw new IOException("This OutputStream is closed.");
        }
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (this.isClosed) {
            throw new IOException("This OutputStream is closed.");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0 || n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        this.c.cm.sendData(this.c, byArray, n2, n3);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }
}

