/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.Channel;
import com.trilead.ssh2.channel.IChannelWorkerThread;
import com.trilead.ssh2.channel.RemoteAcceptThread;
import com.trilead.ssh2.channel.RemoteForwardingData;
import com.trilead.ssh2.channel.RemoteX11AcceptThread;
import com.trilead.ssh2.channel.X11ServerData;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.PacketChannelOpenConfirmation;
import com.trilead.ssh2.packets.PacketChannelOpenFailure;
import com.trilead.ssh2.packets.PacketChannelTrileadPing;
import com.trilead.ssh2.packets.PacketGlobalCancelForwardRequest;
import com.trilead.ssh2.packets.PacketGlobalForwardRequest;
import com.trilead.ssh2.packets.PacketGlobalTrileadPing;
import com.trilead.ssh2.packets.PacketOpenDirectTCPIPChannel;
import com.trilead.ssh2.packets.PacketOpenSessionChannel;
import com.trilead.ssh2.packets.PacketSessionExecCommand;
import com.trilead.ssh2.packets.PacketSessionPtyRequest;
import com.trilead.ssh2.packets.PacketSessionStartShell;
import com.trilead.ssh2.packets.PacketSessionSubsystemRequest;
import com.trilead.ssh2.packets.PacketSessionX11Request;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Vector;

public class ChannelManager
implements MessageHandler {
    private static final Logger log = Logger.getLogger(ChannelManager.class);
    private HashMap x11_magic_cookies = new HashMap();
    private TransportManager tm;
    private Vector channels = new Vector();
    private int nextLocalChannel = 100;
    private boolean shutdown = false;
    private int globalSuccessCounter = 0;
    private int globalFailedCounter = 0;
    private HashMap remoteForwardings = new HashMap();
    private Vector listenerThreads = new Vector();
    private boolean listenerThreadsAllowed = true;

    public ChannelManager(TransportManager transportManager) {
        this.tm = transportManager;
        transportManager.registerMessageHandler(this, 80, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(int n2) {
        Vector vector = this.channels;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.channels.size(); ++i2) {
                Channel channel = (Channel)this.channels.elementAt(i2);
                if (channel.localID != n2) continue;
                return channel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(int n2) {
        Vector vector = this.channels;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.channels.size(); ++i2) {
                Channel channel = (Channel)this.channels.elementAt(i2);
                if (channel.localID != n2) continue;
                this.channels.removeElementAt(i2);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addChannel(Channel channel) {
        Vector vector = this.channels;
        synchronized (vector) {
            this.channels.addElement(channel);
            return this.nextLocalChannel++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilChannelOpen(Channel channel) {
        Channel channel2 = channel;
        synchronized (channel2) {
            while (channel.state == 1) {
                try {
                    channel.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            if (channel.state != 2) {
                this.removeChannel(channel.localID);
                String string = channel.getReasonClosed();
                if (string == null) {
                    string = "state: " + channel.state;
                }
                throw new IOException("Could not open channel (" + string + ")");
            }
        }
    }

    private final boolean waitForGlobalRequestResult() {
        Vector vector = this.channels;
        synchronized (vector) {
            while (this.globalSuccessCounter == 0 && this.globalFailedCounter == 0) {
                if (this.shutdown) {
                    throw new IOException("The connection is being shutdown");
                }
                try {
                    this.channels.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            if (this.globalFailedCounter == 0 && this.globalSuccessCounter == 1) {
                return true;
            }
            if (this.globalFailedCounter == 1 && this.globalSuccessCounter == 0) {
                return false;
            }
            throw new IOException("Illegal state. The server sent " + this.globalSuccessCounter + " SSH_MSG_REQUEST_SUCCESS and " + this.globalFailedCounter + " SSH_MSG_REQUEST_FAILURE messages.");
        }
    }

    private final boolean waitForChannelRequestResult(Channel channel) {
        Channel channel2 = channel;
        synchronized (channel2) {
            while (channel.successCounter == 0 && channel.failedCounter == 0) {
                if (channel.state != 2) {
                    String string = channel.getReasonClosed();
                    if (string == null) {
                        string = "state: " + channel.state;
                    }
                    throw new IOException("This SSH2 channel is not open (" + string + ")");
                }
                try {
                    channel.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            if (channel.failedCounter == 0 && channel.successCounter == 1) {
                return true;
            }
            if (channel.failedCounter == 1 && channel.successCounter == 0) {
                return false;
            }
            throw new IOException("Illegal state. The server sent " + channel.successCounter + " SSH_MSG_CHANNEL_SUCCESS and " + channel.failedCounter + " SSH_MSG_CHANNEL_FAILURE messages.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerX11Cookie(String string, X11ServerData x11ServerData) {
        HashMap hashMap = this.x11_magic_cookies;
        synchronized (hashMap) {
            this.x11_magic_cookies.put(string, x11ServerData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterX11Cookie(String string, boolean bl2) {
        if (string == null) {
            throw new IllegalStateException("hexFakeCookie may not be null");
        }
        Cloneable cloneable = this.x11_magic_cookies;
        synchronized (cloneable) {
            this.x11_magic_cookies.remove(string);
        }
        if (!bl2) {
            return;
        }
        if (log.isEnabled()) {
            log.log(50, "Closing all X11 channels for the given fake cookie");
        }
        Vector vector = this.channels;
        synchronized (vector) {
            cloneable = (Vector)this.channels.clone();
        }
        for (int i2 = 0; i2 < ((Vector)cloneable).size(); ++i2) {
            Channel channel;
            Channel channel2 = channel = (Channel)((Vector)cloneable).elementAt(i2);
            synchronized (channel2) {
                if (!string.equals(channel.hexX11FakeCookie)) {
                    continue;
                }
            }
            try {
                this.closeChannel(channel, "Closing X11 channel since the corresponding session is closing", true);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X11ServerData checkX11Cookie(String string) {
        HashMap hashMap = this.x11_magic_cookies;
        synchronized (hashMap) {
            if (string != null) {
                return (X11ServerData)this.x11_magic_cookies.get(string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllChannels() {
        Vector vector;
        if (log.isEnabled()) {
            log.log(50, "Closing all channels");
        }
        Vector vector2 = this.channels;
        synchronized (vector2) {
            vector = (Vector)this.channels.clone();
        }
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            Channel channel = (Channel)vector.elementAt(i2);
            try {
                this.closeChannel(channel, "Closing all channels", true);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel channel, String string, boolean bl2) {
        byte[] byArray = new byte[5];
        Object object = channel;
        synchronized (object) {
            if (bl2) {
                channel.state = 4;
                channel.EOF = true;
            }
            channel.setReasonClosed(string);
            byArray[0] = 97;
            byArray[1] = (byte)(channel.remoteID >> 24);
            byArray[2] = (byte)(channel.remoteID >> 16);
            byArray[3] = (byte)(channel.remoteID >> 8);
            byArray[4] = (byte)channel.remoteID;
            channel.notifyAll();
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(byArray);
            channel.closeMessageSent = true;
        }
        if (log.isEnabled()) {
            log.log(50, "Sent SSH_MSG_CHANNEL_CLOSE (channel " + channel.localID + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEOF(Channel channel) {
        byte[] byArray = new byte[5];
        Object object = channel;
        synchronized (object) {
            if (channel.state != 2) {
                return;
            }
            byArray[0] = 96;
            byArray[1] = (byte)(channel.remoteID >> 24);
            byArray[2] = (byte)(channel.remoteID >> 16);
            byArray[3] = (byte)(channel.remoteID >> 8);
            byArray[4] = (byte)channel.remoteID;
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(byArray);
        }
        if (log.isEnabled()) {
            log.log(50, "Sent EOF (Channel " + channel.localID + "/" + channel.remoteID + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendOpenConfirmation(Channel channel) {
        PacketChannelOpenConfirmation packetChannelOpenConfirmation = null;
        Object object = channel;
        synchronized (object) {
            if (channel.state != 1) {
                return;
            }
            channel.state = 2;
            packetChannelOpenConfirmation = new PacketChannelOpenConfirmation(channel.remoteID, channel.localID, channel.localWindow, channel.localMaxPacketSize);
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                return;
            }
            this.tm.sendMessage(packetChannelOpenConfirmation.getPayload());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendData(Channel channel, byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            byte[] byArray2;
            int n4 = 0;
            Object object = channel;
            synchronized (object) {
                while (true) {
                    if (channel.state == 4) {
                        throw new IOException("SSH channel is closed. (" + channel.getReasonClosed() + ")");
                    }
                    if (channel.state != 2) {
                        throw new IOException("SSH channel in strange state. (" + channel.state + ")");
                    }
                    if (channel.remoteWindow != 0L) break;
                    try {
                        channel.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new InterruptedIOException();
                    }
                }
                n4 = channel.remoteWindow >= (long)n3 ? n3 : (int)channel.remoteWindow;
                int n5 = channel.remoteMaxPacketSize - (this.tm.getPacketOverheadEstimate() + 9);
                if (n5 <= 0) {
                    n5 = 1;
                }
                if (n4 > n5) {
                    n4 = n5;
                }
                channel.remoteWindow -= (long)n4;
                byArray2 = new byte[9 + n4];
                byArray2[0] = 94;
                byArray2[1] = (byte)(channel.remoteID >> 24);
                byArray2[2] = (byte)(channel.remoteID >> 16);
                byArray2[3] = (byte)(channel.remoteID >> 8);
                byArray2[4] = (byte)channel.remoteID;
                byArray2[5] = (byte)(n4 >> 24);
                byArray2[6] = (byte)(n4 >> 16);
                byArray2[7] = (byte)(n4 >> 8);
                byArray2[8] = (byte)n4;
                System.arraycopy(byArray, n2, byArray2, 9, n4);
            }
            object = channel.channelSendLock;
            synchronized (object) {
                if (channel.closeMessageSent) {
                    throw new IOException("SSH channel is closed. (" + channel.getReasonClosed() + ")");
                }
                this.tm.sendMessage(byArray2);
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestGlobalForward(String string, int n2, String string2, int n3) {
        RemoteForwardingData remoteForwardingData = new RemoteForwardingData();
        remoteForwardingData.bindAddress = string;
        remoteForwardingData.bindPort = n2;
        remoteForwardingData.targetAddress = string2;
        remoteForwardingData.targetPort = n3;
        Object object = this.remoteForwardings;
        synchronized (object) {
            Integer n4 = n2;
            if (this.remoteForwardings.get(n4) != null) {
                throw new IOException("There is already a forwarding for remote port " + n2);
            }
            this.remoteForwardings.put(n4, remoteForwardingData);
        }
        object = this.channels;
        synchronized (object) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        object = new PacketGlobalForwardRequest(true, string, n2);
        this.tm.sendMessage(((PacketGlobalForwardRequest)object).getPayload());
        if (log.isEnabled()) {
            log.log(50, "Requesting a remote forwarding ('" + string + "', " + n2 + ")");
        }
        try {
            if (!this.waitForGlobalRequestResult()) {
                throw new IOException("The server denied the request (did you enable port forwarding?)");
            }
        }
        catch (IOException iOException) {
            HashMap hashMap = this.remoteForwardings;
            synchronized (hashMap) {
                this.remoteForwardings.remove(remoteForwardingData);
            }
            throw iOException;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancelGlobalForward(int n2) {
        RemoteForwardingData remoteForwardingData = null;
        Object object = this.remoteForwardings;
        synchronized (object) {
            remoteForwardingData = (RemoteForwardingData)this.remoteForwardings.get(n2);
            if (remoteForwardingData == null) {
                throw new IOException("Sorry, there is no known remote forwarding for remote port " + n2);
            }
        }
        object = this.channels;
        synchronized (object) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        object = new PacketGlobalCancelForwardRequest(true, remoteForwardingData.bindAddress, remoteForwardingData.bindPort);
        this.tm.sendMessage(((PacketGlobalCancelForwardRequest)object).getPayload());
        if (log.isEnabled()) {
            log.log(50, "Requesting cancelation of remote forward ('" + remoteForwardingData.bindAddress + "', " + remoteForwardingData.bindPort + ")");
        }
        try {
            if (!this.waitForGlobalRequestResult()) {
                throw new IOException("The server denied the request.");
            }
        }
        finally {
            HashMap hashMap = this.remoteForwardings;
            synchronized (hashMap) {
                this.remoteForwardings.remove(remoteForwardingData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(IChannelWorkerThread iChannelWorkerThread) {
        Vector vector = this.listenerThreads;
        synchronized (vector) {
            if (!this.listenerThreadsAllowed) {
                throw new IOException("Too late, this connection is closed.");
            }
            this.listenerThreads.addElement(iChannelWorkerThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel openDirectTCPIPChannel(String string, int n2, String string2, int n3) {
        Channel channel = new Channel(this);
        Object object = channel;
        synchronized (object) {
            channel.localID = this.addChannel(channel);
        }
        object = new PacketOpenDirectTCPIPChannel(channel.localID, channel.localWindow, channel.localMaxPacketSize, string, n2, string2, n3);
        this.tm.sendMessage(((PacketOpenDirectTCPIPChannel)object).getPayload());
        this.waitUntilChannelOpen(channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel openSessionChannel() {
        Channel channel = new Channel(this);
        Object object = channel;
        synchronized (object) {
            channel.localID = this.addChannel(channel);
        }
        if (log.isEnabled()) {
            log.log(50, "Sending SSH_MSG_CHANNEL_OPEN (Channel " + channel.localID + ")");
        }
        object = new PacketOpenSessionChannel(channel.localID, channel.localWindow, channel.localMaxPacketSize);
        this.tm.sendMessage(((PacketOpenSessionChannel)object).getPayload());
        this.waitUntilChannelOpen(channel);
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestGlobalTrileadPing() {
        Object object = this.channels;
        synchronized (object) {
            this.globalFailedCounter = 0;
            this.globalSuccessCounter = 0;
        }
        object = new PacketGlobalTrileadPing();
        this.tm.sendMessage(((PacketGlobalTrileadPing)object).getPayload());
        if (log.isEnabled()) {
            log.log(50, "Sending SSH_MSG_GLOBAL_REQUEST 'trilead-ping'.");
        }
        try {
            if (this.waitForGlobalRequestResult()) {
                throw new IOException("Your server is alive - but buggy. It replied with SSH_MSG_REQUEST_SUCCESS when it actually should not.");
            }
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("The ping request failed.").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestChannelTrileadPing(Channel channel) {
        PacketChannelTrileadPing packetChannelTrileadPing;
        Object object = channel;
        synchronized (object) {
            if (channel.state != 2) {
                throw new IOException("Cannot ping this channel (" + channel.getReasonClosed() + ")");
            }
            packetChannelTrileadPing = new PacketChannelTrileadPing(channel.remoteID);
            channel.failedCounter = 0;
            channel.successCounter = 0;
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                throw new IOException("Cannot ping this channel (" + channel.getReasonClosed() + ")");
            }
            this.tm.sendMessage(packetChannelTrileadPing.getPayload());
        }
        try {
            if (this.waitForChannelRequestResult(channel)) {
                throw new IOException("Your server is alive - but buggy. It replied with SSH_MSG_SESSION_SUCCESS when it actually should not.");
            }
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("The ping request failed.").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPTY(Channel channel, String string, int n2, int n3, int n4, int n5, byte[] byArray) {
        PacketSessionPtyRequest packetSessionPtyRequest;
        Object object = channel;
        synchronized (object) {
            if (channel.state != 2) {
                throw new IOException("Cannot request PTY on this channel (" + channel.getReasonClosed() + ")");
            }
            packetSessionPtyRequest = new PacketSessionPtyRequest(channel.remoteID, true, string, n2, n3, n4, n5, byArray);
            channel.failedCounter = 0;
            channel.successCounter = 0;
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                throw new IOException("Cannot request PTY on this channel (" + channel.getReasonClosed() + ")");
            }
            this.tm.sendMessage(packetSessionPtyRequest.getPayload());
        }
        try {
            if (!this.waitForChannelRequestResult(channel)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("PTY request failed").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestX11(Channel channel, boolean bl2, String string, String string2, int n2) {
        PacketSessionX11Request packetSessionX11Request;
        Object object = channel;
        synchronized (object) {
            if (channel.state != 2) {
                throw new IOException("Cannot request X11 on this channel (" + channel.getReasonClosed() + ")");
            }
            packetSessionX11Request = new PacketSessionX11Request(channel.remoteID, true, bl2, string, string2, n2);
            channel.failedCounter = 0;
            channel.successCounter = 0;
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                throw new IOException("Cannot request X11 on this channel (" + channel.getReasonClosed() + ")");
            }
            this.tm.sendMessage(packetSessionX11Request.getPayload());
        }
        if (log.isEnabled()) {
            log.log(50, "Requesting X11 forwarding (Channel " + channel.localID + "/" + channel.remoteID + ")");
        }
        try {
            if (!this.waitForChannelRequestResult(channel)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("The X11 request failed.").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestSubSystem(Channel channel, String string) {
        PacketSessionSubsystemRequest packetSessionSubsystemRequest;
        Object object = channel;
        synchronized (object) {
            if (channel.state != 2) {
                throw new IOException("Cannot request subsystem on this channel (" + channel.getReasonClosed() + ")");
            }
            packetSessionSubsystemRequest = new PacketSessionSubsystemRequest(channel.remoteID, true, string);
            channel.failedCounter = 0;
            channel.successCounter = 0;
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                throw new IOException("Cannot request subsystem on this channel (" + channel.getReasonClosed() + ")");
            }
            this.tm.sendMessage(packetSessionSubsystemRequest.getPayload());
        }
        try {
            if (!this.waitForChannelRequestResult(channel)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("The subsystem request failed.").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestExecCommand(Channel channel, String string) {
        PacketSessionExecCommand packetSessionExecCommand;
        Object object = channel;
        synchronized (object) {
            if (channel.state != 2) {
                throw new IOException("Cannot execute command on this channel (" + channel.getReasonClosed() + ")");
            }
            packetSessionExecCommand = new PacketSessionExecCommand(channel.remoteID, true, string);
            channel.failedCounter = 0;
            channel.successCounter = 0;
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                throw new IOException("Cannot execute command on this channel (" + channel.getReasonClosed() + ")");
            }
            this.tm.sendMessage(packetSessionExecCommand.getPayload());
        }
        if (log.isEnabled()) {
            log.log(50, "Executing command (channel " + channel.localID + ", '" + string + "')");
        }
        try {
            if (!this.waitForChannelRequestResult(channel)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("The execute request failed.").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestShell(Channel channel) {
        PacketSessionStartShell packetSessionStartShell;
        Object object = channel;
        synchronized (object) {
            if (channel.state != 2) {
                throw new IOException("Cannot start shell on this channel (" + channel.getReasonClosed() + ")");
            }
            packetSessionStartShell = new PacketSessionStartShell(channel.remoteID, true);
            channel.failedCounter = 0;
            channel.successCounter = 0;
        }
        object = channel.channelSendLock;
        synchronized (object) {
            if (channel.closeMessageSent) {
                throw new IOException("Cannot start shell on this channel (" + channel.getReasonClosed() + ")");
            }
            this.tm.sendMessage(packetSessionStartShell.getPayload());
        }
        try {
            if (!this.waitForChannelRequestResult(channel)) {
                throw new IOException("The server denied the request.");
            }
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("The shell request failed.").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelExtendedData(byte[] byArray, int n2) {
        if (n2 <= 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong size (" + n2 + ")");
        }
        int n3 = (byArray[1] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n4 = (byArray[5] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 8 | byArray[8] & 0xFF;
        int n5 = (byArray[9] & 0xFF) << 24 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 8 | byArray[12] & 0xFF;
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EXTENDED_DATA message for non-existent channel " + n3);
        }
        if (n4 != 1) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has unknown type (" + n4 + ")");
        }
        if (n5 != n2 - 13) {
            throw new IOException("SSH_MSG_CHANNEL_EXTENDED_DATA message has wrong len (calculated " + (n2 - 13) + ", got " + n5 + ")");
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_EXTENDED_DATA (channel " + n3 + ", " + n5 + ")");
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            if (channel.state == 4) {
                return;
            }
            if (channel.state != 2) {
                throw new IOException("Got SSH_MSG_CHANNEL_EXTENDED_DATA, but channel is not in correct state (" + channel.state + ")");
            }
            if (channel.localWindow < n5) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            channel.localWindow -= n5;
            System.arraycopy(byArray, 13, channel.stderrBuffer, channel.stderrWritepos, n5);
            channel.stderrWritepos += n5;
            channel.notifyAll();
        }
    }

    public int waitForCondition(Channel channel, long l2, int n2) {
        long l3 = 0L;
        boolean bl2 = false;
        Channel channel2 = channel;
        synchronized (channel2) {
            block5: while (true) {
                while (true) {
                    int n3 = 0;
                    int n4 = channel.stdoutWritepos - channel.stdoutReadpos;
                    int n5 = channel.stderrWritepos - channel.stderrReadpos;
                    if (n4 > 0) {
                        n3 |= 4;
                    }
                    if (n5 > 0) {
                        n3 |= 8;
                    }
                    if (channel.EOF) {
                        n3 |= 0x10;
                    }
                    if (channel.getExitStatus() != null) {
                        n3 |= 0x20;
                    }
                    if (channel.getExitSignal() != null) {
                        n3 |= 0x40;
                    }
                    if (channel.state == 4) {
                        return n3 | 2 | 0x10;
                    }
                    if ((n3 & n2) != 0) {
                        return n3;
                    }
                    if (l2 > 0L) {
                        if (!bl2) {
                            l3 = System.currentTimeMillis() + l2;
                            bl2 = true;
                        } else {
                            l2 = l3 - System.currentTimeMillis();
                            if (l2 <= 0L) {
                                return n3 | 1;
                            }
                        }
                    }
                    try {
                        if (l2 > 0L) {
                            channel.wait(l2);
                            continue block5;
                        }
                        channel.wait();
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailable(Channel channel, boolean bl2) {
        Channel channel2 = channel;
        synchronized (channel2) {
            int n2 = bl2 ? channel.stderrWritepos - channel.stderrReadpos : channel.stdoutWritepos - channel.stdoutReadpos;
            return n2 > 0 ? n2 : (channel.EOF ? -1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelData(Channel channel, boolean bl2, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Object object = channel;
        synchronized (object) {
            int n8 = 0;
            int n9 = 0;
            while (true) {
                n8 = channel.stdoutWritepos - channel.stdoutReadpos;
                n9 = channel.stderrWritepos - channel.stderrReadpos;
                if (!bl2 && n8 != 0 || bl2 && n9 != 0) break;
                if (channel.EOF || channel.state != 2) {
                    return -1;
                }
                try {
                    channel.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
            }
            if (!bl2) {
                n4 = n8 > n3 ? n3 : n8;
                System.arraycopy(channel.stdoutBuffer, channel.stdoutReadpos, byArray, n2, n4);
                channel.stdoutReadpos += n4;
                if (channel.stdoutReadpos != channel.stdoutWritepos) {
                    System.arraycopy(channel.stdoutBuffer, channel.stdoutReadpos, channel.stdoutBuffer, 0, channel.stdoutWritepos - channel.stdoutReadpos);
                }
                channel.stdoutWritepos -= channel.stdoutReadpos;
                channel.stdoutReadpos = 0;
            } else {
                n4 = n9 > n3 ? n3 : n9;
                System.arraycopy(channel.stderrBuffer, channel.stderrReadpos, byArray, n2, n4);
                channel.stderrReadpos += n4;
                if (channel.stderrReadpos != channel.stderrWritepos) {
                    System.arraycopy(channel.stderrBuffer, channel.stderrReadpos, channel.stderrBuffer, 0, channel.stderrWritepos - channel.stderrReadpos);
                }
                channel.stderrWritepos -= channel.stderrReadpos;
                channel.stderrReadpos = 0;
            }
            if (channel.state != 2) {
                return n4;
            }
            if (channel.localWindow < 0x100000) {
                int n10 = Math.min(0x200000 - channel.stdoutWritepos, 0x200000 - channel.stderrWritepos);
                n5 = n10 - channel.localWindow;
                channel.localWindow = n10;
            }
            n6 = channel.remoteID;
            n7 = channel.localID;
        }
        if (n5 > 0) {
            if (log.isEnabled()) {
                log.log(80, "Sending SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + n7 + ", " + n5 + ")");
            }
            object = channel.channelSendLock;
            synchronized (object) {
                byte[] byArray2 = channel.msgWindowAdjust;
                byArray2[0] = 93;
                byArray2[1] = (byte)(n6 >> 24);
                byArray2[2] = (byte)(n6 >> 16);
                byArray2[3] = (byte)(n6 >> 8);
                byArray2[4] = (byte)n6;
                byArray2[5] = (byte)(n5 >> 24);
                byArray2[6] = (byte)(n5 >> 16);
                byArray2[7] = (byte)(n5 >> 8);
                byArray2[8] = (byte)n5;
                if (!channel.closeMessageSent) {
                    this.tm.sendMessage(byArray2);
                }
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelData(byte[] byArray, int n2) {
        if (n2 <= 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong size (" + n2 + ")");
        }
        int n3 = (byArray[1] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n4 = (byArray[5] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 8 | byArray[8] & 0xFF;
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_DATA message for non-existent channel " + n3);
        }
        if (n4 != n2 - 9) {
            throw new IOException("SSH_MSG_CHANNEL_DATA message has wrong len (calculated " + (n2 - 9) + ", got " + n4 + ")");
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_DATA (channel " + n3 + ", " + n4 + ")");
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            if (channel.state == 4) {
                return;
            }
            if (channel.state != 2) {
                throw new IOException("Got SSH_MSG_CHANNEL_DATA, but channel is not in correct state (" + channel.state + ")");
            }
            if (channel.localWindow < n4) {
                throw new IOException("Remote sent too much data, does not fit into window.");
            }
            channel.localWindow -= n4;
            System.arraycopy(byArray, 9, channel.stdoutBuffer, channel.stdoutWritepos, n4);
            channel.stdoutWritepos += n4;
            channel.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelWindowAdjust(byte[] byArray, int n2) {
        if (n2 != 9) {
            throw new IOException("SSH_MSG_CHANNEL_WINDOW_ADJUST message has wrong size (" + n2 + ")");
        }
        int n3 = (byArray[1] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        int n4 = (byArray[5] & 0xFF) << 24 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 8 | byArray[8] & 0xFF;
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_WINDOW_ADJUST message for non-existent channel " + n3);
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            long l2 = 0xFFFFFFFFL;
            channel.remoteWindow += (long)n4 & 0xFFFFFFFFL;
            if (channel.remoteWindow > 0xFFFFFFFFL) {
                channel.remoteWindow = 0xFFFFFFFFL;
            }
            channel.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_WINDOW_ADJUST (channel " + n3 + ", " + n4 + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpen(byte[] byArray, int n2) {
        TypesReader typesReader = new TypesReader(byArray, 0, n2);
        typesReader.readByte();
        String string = typesReader.readString();
        int n3 = typesReader.readUINT32();
        int n4 = typesReader.readUINT32();
        int n5 = typesReader.readUINT32();
        if ("x11".equals(string)) {
            Object object = this.x11_magic_cookies;
            synchronized (object) {
                if (this.x11_magic_cookies.size() == 0) {
                    PacketChannelOpenFailure packetChannelOpenFailure = new PacketChannelOpenFailure(n3, 1, "X11 forwarding not activated", "");
                    this.tm.sendAsynchronousMessage(packetChannelOpenFailure.getPayload());
                    if (log.isEnabled()) {
                        log.log(20, "Unexpected X11 request, denying it!");
                    }
                    return;
                }
            }
            object = typesReader.readString();
            int n6 = typesReader.readUINT32();
            Channel channel = new Channel(this);
            Object object2 = channel;
            synchronized (object2) {
                channel.remoteID = n3;
                channel.remoteWindow = (long)n4 & 0xFFFFFFFFL;
                channel.remoteMaxPacketSize = n5;
                channel.localID = this.addChannel(channel);
            }
            object2 = new RemoteX11AcceptThread(channel, (String)object, n6);
            ((Thread)object2).setDaemon(true);
            ((Thread)object2).start();
            return;
        }
        if ("forwarded-tcpip".equals(string)) {
            String string2 = typesReader.readString();
            int n7 = typesReader.readUINT32();
            String string3 = typesReader.readString();
            int n8 = typesReader.readUINT32();
            RemoteForwardingData remoteForwardingData = null;
            Object object = this.remoteForwardings;
            synchronized (object) {
                remoteForwardingData = (RemoteForwardingData)this.remoteForwardings.get(n7);
            }
            if (remoteForwardingData == null) {
                object = new PacketChannelOpenFailure(n3, 1, "No thanks, unknown port in forwarded-tcpip request", "");
                this.tm.sendAsynchronousMessage(((PacketChannelOpenFailure)object).getPayload());
                if (log.isEnabled()) {
                    log.log(20, "Unexpected forwarded-tcpip request, denying it!");
                }
                return;
            }
            Object object3 = object = new Channel(this);
            synchronized (object3) {
                ((Channel)object).remoteID = n3;
                ((Channel)object).remoteWindow = (long)n4 & 0xFFFFFFFFL;
                ((Channel)object).remoteMaxPacketSize = n5;
                ((Channel)object).localID = this.addChannel((Channel)object);
            }
            object3 = new RemoteAcceptThread((Channel)object, string2, n7, string3, n8, remoteForwardingData.targetAddress, remoteForwardingData.targetPort);
            ((Thread)object3).setDaemon(true);
            ((Thread)object3).start();
            return;
        }
        PacketChannelOpenFailure packetChannelOpenFailure = new PacketChannelOpenFailure(n3, 3, "Unknown channel type", "");
        this.tm.sendAsynchronousMessage(packetChannelOpenFailure.getPayload());
        if (log.isEnabled()) {
            log.log(20, "The peer tried to open an unsupported channel type (" + string + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelRequest(byte[] byArray, int n2) {
        TypesReader typesReader = new TypesReader(byArray, 0, n2);
        typesReader.readByte();
        int n3 = typesReader.readUINT32();
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_REQUEST message for non-existent channel " + n3);
        }
        String string = typesReader.readString("US-ASCII");
        boolean bl2 = typesReader.readBoolean();
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_REQUEST (channel " + n3 + ", '" + string + "')");
        }
        if (string.equals("exit-status")) {
            if (bl2) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message, 'want reply' is true");
            }
            int n4 = typesReader.readUINT32();
            if (typesReader.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Channel channel2 = channel;
            synchronized (channel2) {
                channel.exit_status = n4;
                channel.notifyAll();
            }
            if (log.isEnabled()) {
                log.log(50, "Got EXIT STATUS (channel " + n3 + ", status " + n4 + ")");
            }
            return;
        }
        if (string.equals("exit-signal")) {
            if (bl2) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message, 'want reply' is true");
            }
            String string2 = typesReader.readString("US-ASCII");
            typesReader.readBoolean();
            typesReader.readString();
            typesReader.readString();
            if (typesReader.remain() != 0) {
                throw new IOException("Badly formatted SSH_MSG_CHANNEL_REQUEST message");
            }
            Channel channel3 = channel;
            synchronized (channel3) {
                channel.exit_signal = string2;
                channel.notifyAll();
            }
            if (log.isEnabled()) {
                log.log(50, "Got EXIT SIGNAL (channel " + n3 + ", signal " + string2 + ")");
            }
            return;
        }
        if (bl2) {
            byte[] byArray2 = new byte[]{100, (byte)(channel.remoteID >> 24), (byte)(channel.remoteID >> 16), (byte)(channel.remoteID >> 8), (byte)channel.remoteID};
            this.tm.sendAsynchronousMessage(byArray2);
        }
        if (log.isEnabled()) {
            log.log(50, "Channel request '" + string + "' is not known, ignoring it");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelEOF(byte[] byArray, int n2) {
        if (n2 != 5) {
            throw new IOException("SSH_MSG_CHANNEL_EOF message has wrong size (" + n2 + ")");
        }
        int n3 = (byArray[1] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_EOF message for non-existent channel " + n3);
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.EOF = true;
            channel.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_EOF (channel " + n3 + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelClose(byte[] byArray, int n2) {
        if (n2 != 5) {
            throw new IOException("SSH_MSG_CHANNEL_CLOSE message has wrong size (" + n2 + ")");
        }
        int n3 = (byArray[1] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_CLOSE message for non-existent channel " + n3);
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.EOF = true;
            channel.state = 4;
            channel.setReasonClosed("Close requested by remote");
            channel.closeMessageRecv = true;
            this.removeChannel(channel.localID);
            channel.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_CLOSE (channel " + n3 + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelSuccess(byte[] byArray, int n2) {
        if (n2 != 5) {
            throw new IOException("SSH_MSG_CHANNEL_SUCCESS message has wrong size (" + n2 + ")");
        }
        int n3 = (byArray[1] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_SUCCESS message for non-existent channel " + n3);
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            ++channel.successCounter;
            channel.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_CHANNEL_SUCCESS (channel " + n3 + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelFailure(byte[] byArray, int n2) {
        if (n2 != 5) {
            throw new IOException("SSH_MSG_CHANNEL_FAILURE message has wrong size (" + n2 + ")");
        }
        int n3 = (byArray[1] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_FAILURE message for non-existent channel " + n3);
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            ++channel.failedCounter;
            channel.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_FAILURE (channel " + n3 + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenConfirmation(byte[] byArray, int n2) {
        PacketChannelOpenConfirmation packetChannelOpenConfirmation = new PacketChannelOpenConfirmation(byArray, 0, n2);
        Channel channel = this.getChannel(packetChannelOpenConfirmation.recipientChannelID);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for non-existent channel " + packetChannelOpenConfirmation.recipientChannelID);
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            if (channel.state != 1) {
                throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_CONFIRMATION message for channel " + packetChannelOpenConfirmation.recipientChannelID);
            }
            channel.remoteID = packetChannelOpenConfirmation.senderChannelID;
            channel.remoteWindow = (long)packetChannelOpenConfirmation.initialWindowSize & 0xFFFFFFFFL;
            channel.remoteMaxPacketSize = packetChannelOpenConfirmation.maxPacketSize;
            channel.state = 2;
            channel.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_OPEN_CONFIRMATION (channel " + packetChannelOpenConfirmation.recipientChannelID + " / remote: " + packetChannelOpenConfirmation.senderChannelID + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgChannelOpenFailure(byte[] byArray, int n2) {
        if (n2 < 5) {
            throw new IOException("SSH_MSG_CHANNEL_OPEN_FAILURE message has wrong size (" + n2 + ")");
        }
        TypesReader typesReader = new TypesReader(byArray, 0, n2);
        typesReader.readByte();
        int n3 = typesReader.readUINT32();
        Channel channel = this.getChannel(n3);
        if (channel == null) {
            throw new IOException("Unexpected SSH_MSG_CHANNEL_OPEN_FAILURE message for non-existent channel " + n3);
        }
        int n4 = typesReader.readUINT32();
        String string = typesReader.readString("UTF-8");
        String string2 = null;
        switch (n4) {
            case 1: {
                string2 = "SSH_OPEN_ADMINISTRATIVELY_PROHIBITED";
                break;
            }
            case 2: {
                string2 = "SSH_OPEN_CONNECT_FAILED";
                break;
            }
            case 3: {
                string2 = "SSH_OPEN_UNKNOWN_CHANNEL_TYPE";
                break;
            }
            case 4: {
                string2 = "SSH_OPEN_RESOURCE_SHORTAGE";
                break;
            }
            default: {
                string2 = "UNKNOWN REASON CODE (" + n4 + ")";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
            char c2 = stringBuffer.charAt(i2);
            if (c2 >= ' ' && c2 <= '~') continue;
            stringBuffer.setCharAt(i2, '\ufffd');
        }
        Channel channel2 = channel;
        synchronized (channel2) {
            channel.EOF = true;
            channel.state = 4;
            channel.setReasonClosed("The server refused to open the channel (" + string2 + ", '" + stringBuffer.toString() + "')");
            channel.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(50, "Got SSH_MSG_CHANNEL_OPEN_FAILURE (channel " + n3 + ")");
        }
    }

    public void msgGlobalRequest(byte[] byArray, int n2) {
        TypesReader typesReader = new TypesReader(byArray, 0, n2);
        typesReader.readByte();
        String string = typesReader.readString();
        boolean bl2 = typesReader.readBoolean();
        if (bl2) {
            byte[] byArray2 = new byte[]{82};
            this.tm.sendAsynchronousMessage(byArray2);
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_GLOBAL_REQUEST (" + string + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgGlobalSuccess() {
        Vector vector = this.channels;
        synchronized (vector) {
            ++this.globalSuccessCounter;
            this.channels.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_REQUEST_SUCCESS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgGlobalFailure() {
        Vector vector = this.channels;
        synchronized (vector) {
            ++this.globalFailedCounter;
            this.channels.notifyAll();
        }
        if (log.isEnabled()) {
            log.log(80, "Got SSH_MSG_REQUEST_FAILURE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(byte[] byArray, int n2) {
        if (byArray == null) {
            Object object;
            int n3;
            if (log.isEnabled()) {
                log.log(50, "HandleMessage: got shutdown");
            }
            Vector vector = this.listenerThreads;
            synchronized (vector) {
                for (n3 = 0; n3 < this.listenerThreads.size(); ++n3) {
                    object = (IChannelWorkerThread)this.listenerThreads.elementAt(n3);
                    object.stopWorking();
                }
                this.listenerThreadsAllowed = false;
            }
            vector = this.channels;
            synchronized (vector) {
                this.shutdown = true;
                for (n3 = 0; n3 < this.channels.size(); ++n3) {
                    Object object2 = object = (Channel)this.channels.elementAt(n3);
                    synchronized (object2) {
                        ((Channel)object).EOF = true;
                        ((Channel)object).state = 4;
                        ((Channel)object).setReasonClosed("The connection is being shutdown");
                        ((Channel)object).closeMessageRecv = true;
                        object.notifyAll();
                        continue;
                    }
                }
                this.channels.setSize(0);
                this.channels.trimToSize();
                this.channels.notifyAll();
                return;
            }
        }
        switch (byArray[0]) {
            case 91: {
                this.msgChannelOpenConfirmation(byArray, n2);
                break;
            }
            case 93: {
                this.msgChannelWindowAdjust(byArray, n2);
                break;
            }
            case 94: {
                this.msgChannelData(byArray, n2);
                break;
            }
            case 95: {
                this.msgChannelExtendedData(byArray, n2);
                break;
            }
            case 98: {
                this.msgChannelRequest(byArray, n2);
                break;
            }
            case 96: {
                this.msgChannelEOF(byArray, n2);
                break;
            }
            case 90: {
                this.msgChannelOpen(byArray, n2);
                break;
            }
            case 97: {
                this.msgChannelClose(byArray, n2);
                break;
            }
            case 99: {
                this.msgChannelSuccess(byArray, n2);
                break;
            }
            case 100: {
                this.msgChannelFailure(byArray, n2);
                break;
            }
            case 92: {
                this.msgChannelOpenFailure(byArray, n2);
                break;
            }
            case 80: {
                this.msgGlobalRequest(byArray, n2);
                break;
            }
            case 81: {
                this.msgGlobalSuccess();
                break;
            }
            case 82: {
                this.msgGlobalFailure();
                break;
            }
            default: {
                throw new IOException("Cannot handle unknown channel message " + (byArray[0] & 0xFF));
            }
        }
    }
}

