/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.Channel;
import java.io.InputStream;

public final class ChannelInputStream
extends InputStream {
    Channel c;
    boolean isClosed = false;
    boolean isEOF = false;
    boolean extendedFlag = false;

    ChannelInputStream(Channel channel, boolean bl2) {
        this.c = channel;
        this.extendedFlag = bl2;
    }

    public int available() {
        if (this.isEOF) {
            return 0;
        }
        int n2 = this.c.cm.getAvailable(this.c, this.extendedFlag);
        return n2 > 0 ? n2 : 0;
    }

    public void close() {
        this.isClosed = true;
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0 || n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.isEOF) {
            return -1;
        }
        int n4 = this.c.cm.getChannelData(this.c, this.extendedFlag, byArray, n2, n3);
        if (n4 == -1) {
            this.isEOF = true;
        }
        return n4;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        if (n2 != 1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }
}

