/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.auth;

import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.auth.AgentIdentity;
import com.trilead.ssh2.auth.AgentProxy;
import com.trilead.ssh2.crypto.PEMDecoder;
import com.trilead.ssh2.packets.PacketServiceAccept;
import com.trilead.ssh2.packets.PacketServiceRequest;
import com.trilead.ssh2.packets.PacketUserauthBanner;
import com.trilead.ssh2.packets.PacketUserauthFailure;
import com.trilead.ssh2.packets.PacketUserauthInfoRequest;
import com.trilead.ssh2.packets.PacketUserauthInfoResponse;
import com.trilead.ssh2.packets.PacketUserauthRequestInteractive;
import com.trilead.ssh2.packets.PacketUserauthRequestNone;
import com.trilead.ssh2.packets.PacketUserauthRequestPassword;
import com.trilead.ssh2.packets.PacketUserauthRequestPublicKey;
import com.trilead.ssh2.packets.TypesWriter;
import com.trilead.ssh2.signature.DSAPrivateKey;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.DSASignature;
import com.trilead.ssh2.signature.RSAPrivateKey;
import com.trilead.ssh2.signature.RSASHA1Verify;
import com.trilead.ssh2.signature.RSASignature;
import com.trilead.ssh2.transport.MessageHandler;
import com.trilead.ssh2.transport.TransportManager;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Vector;

public class AuthenticationManager
implements MessageHandler {
    TransportManager tm;
    Vector packets = new Vector();
    boolean connectionClosed = false;
    String banner;
    String[] remainingMethods = new String[0];
    boolean isPartialSuccess = false;
    boolean authenticated = false;
    boolean initDone = false;

    public AuthenticationManager(TransportManager transportManager) {
        this.tm = transportManager;
    }

    boolean methodPossible(String string) {
        if (this.remainingMethods == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.remainingMethods.length; ++i2) {
            if (this.remainingMethods[i2].compareTo(string) != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] deQueue() {
        Vector vector = this.packets;
        synchronized (vector) {
            while (this.packets.size() == 0) {
                if (this.connectionClosed) {
                    throw (IOException)new IOException("The connection is closed.").initCause(this.tm.getReasonClosedCause());
                }
                try {
                    this.packets.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            byte[] byArray = (byte[])this.packets.firstElement();
            this.packets.removeElementAt(0);
            return byArray;
        }
    }

    byte[] getNextMessage() {
        byte[] byArray;
        while ((byArray = this.deQueue())[0] == 53) {
            PacketUserauthBanner packetUserauthBanner = new PacketUserauthBanner(byArray, 0, byArray.length);
            this.banner = packetUserauthBanner.getBanner();
        }
        return byArray;
    }

    public String[] getRemainingMethods(String string) {
        this.initialize(string);
        return this.remainingMethods;
    }

    public boolean getPartialSuccess() {
        return this.isPartialSuccess;
    }

    private boolean initialize(String string) {
        if (!this.initDone) {
            this.tm.registerMessageHandler(this, 0, 255);
            PacketServiceRequest packetServiceRequest = new PacketServiceRequest("ssh-userauth");
            this.tm.sendMessage(packetServiceRequest.getPayload());
            PacketUserauthRequestNone packetUserauthRequestNone = new PacketUserauthRequestNone("ssh-connection", string);
            this.tm.sendMessage(packetUserauthRequestNone.getPayload());
            byte[] byArray = this.getNextMessage();
            new PacketServiceAccept(byArray, 0, byArray.length);
            byArray = this.getNextMessage();
            this.initDone = true;
            if (byArray[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (byArray[0] == 51) {
                PacketUserauthFailure packetUserauthFailure = new PacketUserauthFailure(byArray, 0, byArray.length);
                this.remainingMethods = packetUserauthFailure.getAuthThatCanContinue();
                this.isPartialSuccess = packetUserauthFailure.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + byArray[0] + ")");
        }
        return this.authenticated;
    }

    public boolean authenticatePublicKey(String string, AgentProxy agentProxy) {
        this.initialize(string);
        boolean bl2 = false;
        for (AgentIdentity agentIdentity : agentProxy.getIdentities()) {
            bl2 = this.authenticatePublicKey(string, agentProxy, agentIdentity);
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    boolean authenticatePublicKey(String string, AgentProxy agentProxy, AgentIdentity agentIdentity) {
        if (!this.methodPossible("publickey")) {
            throw new IOException("Authentication method publickey not supported by the server at this stage.");
        }
        byte[] byArray = agentIdentity.getPublicKeyBlob();
        if (byArray == null) {
            return false;
        }
        TypesWriter typesWriter = new TypesWriter();
        byte[] byArray2 = this.tm.getSessionIdentifier();
        typesWriter.writeString(byArray2, 0, byArray2.length);
        typesWriter.writeByte(50);
        typesWriter.writeString(string);
        typesWriter.writeString("ssh-connection");
        typesWriter.writeString("publickey");
        typesWriter.writeBoolean(true);
        typesWriter.writeString(agentIdentity.getAlgName());
        typesWriter.writeString(byArray, 0, byArray.length);
        byte[] byArray3 = typesWriter.getBytes();
        byte[] byArray4 = agentIdentity.sign(byArray3);
        PacketUserauthRequestPublicKey packetUserauthRequestPublicKey = new PacketUserauthRequestPublicKey("ssh-connection", string, agentIdentity.getAlgName(), byArray, byArray4);
        this.tm.sendMessage(packetUserauthRequestPublicKey.getPayload());
        byte[] byArray5 = this.getNextMessage();
        if (byArray5[0] == 52) {
            this.authenticated = true;
            this.tm.removeMessageHandler(this, 0, 255);
            return true;
        }
        if (byArray5[0] == 51) {
            PacketUserauthFailure packetUserauthFailure = new PacketUserauthFailure(byArray5, 0, byArray5.length);
            this.remainingMethods = packetUserauthFailure.getAuthThatCanContinue();
            this.isPartialSuccess = packetUserauthFailure.isPartialSuccess();
            return false;
        }
        throw new IOException("Unexpected SSH message (type " + byArray5[0] + ")");
    }

    public boolean authenticatePublicKey(String string, char[] cArray, String string2, SecureRandom secureRandom) {
        try {
            Object object;
            Object object2;
            this.initialize(string);
            if (!this.methodPossible("publickey")) {
                throw new IOException("Authentication method publickey not supported by the server at this stage.");
            }
            Object object3 = PEMDecoder.decode(cArray, string2);
            if (object3 instanceof DSAPrivateKey) {
                object2 = (DSAPrivateKey)object3;
                object = DSASHA1Verify.encodeSSHDSAPublicKey(((DSAPrivateKey)object2).getPublicKey());
                TypesWriter typesWriter = new TypesWriter();
                byte[] byArray = this.tm.getSessionIdentifier();
                typesWriter.writeString(byArray, 0, byArray.length);
                typesWriter.writeByte(50);
                typesWriter.writeString(string);
                typesWriter.writeString("ssh-connection");
                typesWriter.writeString("publickey");
                typesWriter.writeBoolean(true);
                typesWriter.writeString("ssh-dss");
                typesWriter.writeString((byte[])object, 0, ((byte[])object).length);
                byte[] byArray2 = typesWriter.getBytes();
                DSASignature dSASignature = DSASHA1Verify.generateSignature(byArray2, (DSAPrivateKey)object2, secureRandom);
                byte[] byArray3 = DSASHA1Verify.encodeSSHDSASignature(dSASignature);
                PacketUserauthRequestPublicKey packetUserauthRequestPublicKey = new PacketUserauthRequestPublicKey("ssh-connection", string, "ssh-dss", (byte[])object, byArray3);
                this.tm.sendMessage(packetUserauthRequestPublicKey.getPayload());
            } else if (object3 instanceof RSAPrivateKey) {
                object2 = (RSAPrivateKey)object3;
                object = RSASHA1Verify.encodeSSHRSAPublicKey(((RSAPrivateKey)object2).getPublicKey());
                TypesWriter typesWriter = new TypesWriter();
                byte[] byArray = this.tm.getSessionIdentifier();
                typesWriter.writeString(byArray, 0, byArray.length);
                typesWriter.writeByte(50);
                typesWriter.writeString(string);
                typesWriter.writeString("ssh-connection");
                typesWriter.writeString("publickey");
                typesWriter.writeBoolean(true);
                typesWriter.writeString("ssh-rsa");
                typesWriter.writeString((byte[])object, 0, ((byte[])object).length);
                byArray = typesWriter.getBytes();
                RSASignature rSASignature = RSASHA1Verify.generateSignature(byArray, (RSAPrivateKey)object2);
                byte[] byArray4 = RSASHA1Verify.encodeSSHRSASignature(rSASignature);
                PacketUserauthRequestPublicKey packetUserauthRequestPublicKey = new PacketUserauthRequestPublicKey("ssh-connection", string, "ssh-rsa", (byte[])object, byArray4);
                this.tm.sendMessage(packetUserauthRequestPublicKey.getPayload());
            } else {
                throw new IOException("Unknown private key type returned by the PEM decoder.");
            }
            object2 = this.getNextMessage();
            if (object2[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (object2[0] == 51) {
                object = new PacketUserauthFailure((byte[])object2, 0, ((Object)object2).length);
                this.remainingMethods = ((PacketUserauthFailure)object).getAuthThatCanContinue();
                this.isPartialSuccess = ((PacketUserauthFailure)object).isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + (int)object2[0] + ")");
        }
        catch (IOException iOException) {
            this.tm.close(iOException, false);
            throw (IOException)new IOException("Publickey authentication failed.").initCause(iOException);
        }
    }

    public boolean authenticateNone(String string) {
        try {
            this.initialize(string);
            return this.authenticated;
        }
        catch (IOException iOException) {
            this.tm.close(iOException, false);
            throw (IOException)new IOException("None authentication failed.").initCause(iOException);
        }
    }

    public boolean authenticatePassword(String string, String string2) {
        try {
            this.initialize(string);
            if (!this.methodPossible("password")) {
                throw new IOException("Authentication method password not supported by the server at this stage.");
            }
            PacketUserauthRequestPassword packetUserauthRequestPassword = new PacketUserauthRequestPassword("ssh-connection", string, string2);
            this.tm.sendMessage(packetUserauthRequestPassword.getPayload());
            byte[] byArray = this.getNextMessage();
            if (byArray[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (byArray[0] == 51) {
                PacketUserauthFailure packetUserauthFailure = new PacketUserauthFailure(byArray, 0, byArray.length);
                this.remainingMethods = packetUserauthFailure.getAuthThatCanContinue();
                this.isPartialSuccess = packetUserauthFailure.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + byArray[0] + ")");
        }
        catch (IOException iOException) {
            this.tm.close(iOException, false);
            throw (IOException)new IOException("Password authentication failed.").initCause(iOException);
        }
    }

    public boolean authenticateInteractive(String string, String[] stringArray, InteractiveCallback interactiveCallback) {
        try {
            byte[] byArray;
            this.initialize(string);
            if (!this.methodPossible("keyboard-interactive")) {
                throw new IOException("Authentication method keyboard-interactive not supported by the server at this stage.");
            }
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            PacketUserauthRequestInteractive packetUserauthRequestInteractive = new PacketUserauthRequestInteractive("ssh-connection", string, stringArray);
            this.tm.sendMessage(packetUserauthRequestInteractive.getPayload());
            while (true) {
                String[] stringArray2;
                Object object;
                if ((byArray = this.getNextMessage())[0] == 52) {
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                if (byArray[0] == 51) {
                    object = new PacketUserauthFailure(byArray, 0, byArray.length);
                    this.remainingMethods = ((PacketUserauthFailure)object).getAuthThatCanContinue();
                    this.isPartialSuccess = ((PacketUserauthFailure)object).isPartialSuccess();
                    return false;
                }
                if (byArray[0] != 60) break;
                object = new PacketUserauthInfoRequest(byArray, 0, byArray.length);
                try {
                    stringArray2 = interactiveCallback.replyToChallenge(((PacketUserauthInfoRequest)object).getName(), ((PacketUserauthInfoRequest)object).getInstruction(), ((PacketUserauthInfoRequest)object).getNumPrompts(), ((PacketUserauthInfoRequest)object).getPrompt(), ((PacketUserauthInfoRequest)object).getEcho());
                }
                catch (Exception exception) {
                    throw (IOException)new IOException("Exception in callback.").initCause(exception);
                }
                if (stringArray2 == null) {
                    throw new IOException("Your callback may not return NULL!");
                }
                PacketUserauthInfoResponse packetUserauthInfoResponse = new PacketUserauthInfoResponse(stringArray2);
                this.tm.sendMessage(packetUserauthInfoResponse.getPayload());
            }
            throw new IOException("Unexpected SSH message (type " + byArray[0] + ")");
        }
        catch (IOException iOException) {
            this.tm.close(iOException, false);
            throw (IOException)new IOException("Keyboard-interactive authentication failed.").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(byte[] byArray, int n2) {
        Vector vector = this.packets;
        synchronized (vector) {
            if (byArray == null) {
                this.connectionClosed = true;
            } else {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                this.packets.addElement(byArray2);
            }
            this.packets.notifyAll();
            if (this.packets.size() > 5) {
                this.connectionClosed = true;
                throw new IOException("Error, peer is flooding us with authentication packets.");
            }
        }
    }
}

