/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SFTPException;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Vector;

public class SFTPv3Client {
    final Connection conn;
    final Session sess;
    final PrintStream debug;
    boolean flag_closed = false;
    InputStream is;
    OutputStream os;
    int protocol_version = 0;
    HashMap server_extensions = new HashMap();
    int next_request_id = 1000;
    String charsetName = null;

    public SFTPv3Client(Connection connection, PrintStream printStream) {
        if (connection == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.conn = connection;
        this.debug = printStream;
        if (printStream != null) {
            printStream.println("Opening session and starting SFTP subsystem.");
        }
        this.sess = connection.openSession();
        this.sess.startSubSystem("sftp");
        this.is = this.sess.getStdout();
        this.os = new BufferedOutputStream(this.sess.getStdin(), 2048);
        if (this.is == null || this.os == null) {
            throw new IOException("There is a problem with the streams of the underlying channel.");
        }
        this.init();
    }

    public SFTPv3Client(Connection connection) {
        this(connection, null);
    }

    public void setCharset(String string) {
        if (string == null) {
            this.charsetName = string;
            return;
        }
        try {
            Charset.forName(string);
        }
        catch (Exception exception) {
            throw (IOException)new IOException("This charset is not supported").initCause(exception);
        }
        this.charsetName = string;
    }

    public String getCharset() {
        return this.charsetName;
    }

    private final void checkHandleValidAndOpen(SFTPv3FileHandle sFTPv3FileHandle) {
        if (sFTPv3FileHandle.client != this) {
            throw new IOException("The file handle was created with another SFTPv3FileHandle instance.");
        }
        if (sFTPv3FileHandle.isClosed) {
            throw new IOException("The file handle is closed.");
        }
    }

    private final void sendMessage(int n2, int n3, byte[] byArray, int n4, int n5) {
        int n6 = n5 + 1;
        if (n2 != 1) {
            n6 += 4;
        }
        this.os.write(n6 >> 24);
        this.os.write(n6 >> 16);
        this.os.write(n6 >> 8);
        this.os.write(n6);
        this.os.write(n2);
        if (n2 != 1) {
            this.os.write(n3 >> 24);
            this.os.write(n3 >> 16);
            this.os.write(n3 >> 8);
            this.os.write(n3);
        }
        this.os.write(byArray, n4, n5);
        this.os.flush();
    }

    private final void sendMessage(int n2, int n3, byte[] byArray) {
        this.sendMessage(n2, n3, byArray, 0, byArray.length);
    }

    private final void readBytes(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = this.is.read(byArray, n2, n3);
            if (n4 < 0) {
                throw new IOException("Unexpected end of sftp stream.");
            }
            if (n4 == 0 || n4 > n3) {
                throw new IOException("Underlying stream implementation is bogus!");
            }
            n3 -= n4;
            n2 += n4;
        }
    }

    private final byte[] receiveMessage(int n2) {
        byte[] byArray = new byte[4];
        this.readBytes(byArray, 0, 4);
        int n3 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        if (n3 > n2 || n3 <= 0) {
            throw new IOException("Illegal sftp packet len: " + n3);
        }
        byte[] byArray2 = new byte[n3];
        this.readBytes(byArray2, 0, n3);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int generateNextRequestID() {
        SFTPv3Client sFTPv3Client = this;
        synchronized (sFTPv3Client) {
            return this.next_request_id++;
        }
    }

    private final void closeHandle(byte[] byArray) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(byArray, 0, byArray.length);
        this.sendMessage(4, n2, typesWriter.getBytes());
        this.expectStatusOKMessage(n2);
    }

    private SFTPv3FileAttributes readAttrs(TypesReader typesReader) {
        SFTPv3FileAttributes sFTPv3FileAttributes = new SFTPv3FileAttributes();
        int n2 = typesReader.readUINT32();
        if ((n2 & 1) != 0) {
            if (this.debug != null) {
                this.debug.println("SSH_FILEXFER_ATTR_SIZE");
            }
            sFTPv3FileAttributes.size = typesReader.readUINT64();
        }
        if ((n2 & 2) != 0) {
            if (this.debug != null) {
                this.debug.println("SSH_FILEXFER_ATTR_V3_UIDGID");
            }
            sFTPv3FileAttributes.uid = typesReader.readUINT32();
            sFTPv3FileAttributes.gid = typesReader.readUINT32();
        }
        if ((n2 & 4) != 0) {
            if (this.debug != null) {
                this.debug.println("SSH_FILEXFER_ATTR_PERMISSIONS");
            }
            sFTPv3FileAttributes.permissions = typesReader.readUINT32();
        }
        if ((n2 & 8) != 0) {
            if (this.debug != null) {
                this.debug.println("SSH_FILEXFER_ATTR_V3_ACMODTIME");
            }
            sFTPv3FileAttributes.atime = (long)typesReader.readUINT32() & 0xFFFFFFFFL;
            sFTPv3FileAttributes.mtime = (long)typesReader.readUINT32() & 0xFFFFFFFFL;
        }
        if ((n2 & Integer.MIN_VALUE) != 0) {
            int n3 = typesReader.readUINT32();
            if (this.debug != null) {
                this.debug.println("SSH_FILEXFER_ATTR_EXTENDED (" + n3 + ")");
            }
            while (n3 > 0) {
                typesReader.readByteString();
                typesReader.readByteString();
                --n3;
            }
        }
        return sFTPv3FileAttributes;
    }

    public SFTPv3FileAttributes fstat(SFTPv3FileHandle sFTPv3FileHandle) {
        this.checkHandleValidAndOpen(sFTPv3FileHandle);
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(sFTPv3FileHandle.fileHandle, 0, sFTPv3FileHandle.fileHandle.length);
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_FSTAT...");
            this.debug.flush();
        }
        this.sendMessage(8, n2, typesWriter.getBytes());
        byte[] byArray = this.receiveMessage(34000);
        if (this.debug != null) {
            this.debug.println("Got REPLY.");
            this.debug.flush();
        }
        TypesReader typesReader = new TypesReader(byArray);
        int n3 = typesReader.readByte();
        int n4 = typesReader.readUINT32();
        if (n4 != n2) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (n3 == 105) {
            return this.readAttrs(typesReader);
        }
        if (n3 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n3 + ")");
        }
        int n5 = typesReader.readUINT32();
        throw new SFTPException(typesReader.readString(), n5);
    }

    private SFTPv3FileAttributes statBoth(String string, int n2) {
        int n3 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_STAT/SSH_FXP_LSTAT...");
            this.debug.flush();
        }
        this.sendMessage(n2, n3, typesWriter.getBytes());
        byte[] byArray = this.receiveMessage(34000);
        if (this.debug != null) {
            this.debug.println("Got REPLY.");
            this.debug.flush();
        }
        TypesReader typesReader = new TypesReader(byArray);
        int n4 = typesReader.readByte();
        int n5 = typesReader.readUINT32();
        if (n5 != n3) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (n4 == 105) {
            return this.readAttrs(typesReader);
        }
        if (n4 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n4 + ")");
        }
        int n6 = typesReader.readUINT32();
        throw new SFTPException(typesReader.readString(), n6);
    }

    public SFTPv3FileAttributes stat(String string) {
        return this.statBoth(string, 17);
    }

    public SFTPv3FileAttributes lstat(String string) {
        return this.statBoth(string, 7);
    }

    public String readLink(String string) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_READLINK...");
            this.debug.flush();
        }
        this.sendMessage(19, n2, typesWriter.getBytes());
        byte[] byArray = this.receiveMessage(34000);
        if (this.debug != null) {
            this.debug.println("Got REPLY.");
            this.debug.flush();
        }
        TypesReader typesReader = new TypesReader(byArray);
        int n3 = typesReader.readByte();
        int n4 = typesReader.readUINT32();
        if (n4 != n2) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (n3 == 104) {
            int n5 = typesReader.readUINT32();
            if (n5 != 1) {
                throw new IOException("The server sent an invalid SSH_FXP_NAME packet.");
            }
            return typesReader.readString(this.charsetName);
        }
        if (n3 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n3 + ")");
        }
        int n6 = typesReader.readUINT32();
        throw new SFTPException(typesReader.readString(), n6);
    }

    private void expectStatusOKMessage(int n2) {
        byte[] byArray = this.receiveMessage(34000);
        if (this.debug != null) {
            this.debug.println("Got REPLY.");
            this.debug.flush();
        }
        TypesReader typesReader = new TypesReader(byArray);
        int n3 = typesReader.readByte();
        int n4 = typesReader.readUINT32();
        if (n4 != n2) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (n3 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n3 + ")");
        }
        int n5 = typesReader.readUINT32();
        if (n5 == 0) {
            return;
        }
        throw new SFTPException(typesReader.readString(), n5);
    }

    public void setstat(String string, SFTPv3FileAttributes sFTPv3FileAttributes) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        typesWriter.writeBytes(this.createAttrs(sFTPv3FileAttributes));
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_SETSTAT...");
            this.debug.flush();
        }
        this.sendMessage(9, n2, typesWriter.getBytes());
        this.expectStatusOKMessage(n2);
    }

    public void fsetstat(SFTPv3FileHandle sFTPv3FileHandle, SFTPv3FileAttributes sFTPv3FileAttributes) {
        this.checkHandleValidAndOpen(sFTPv3FileHandle);
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(sFTPv3FileHandle.fileHandle, 0, sFTPv3FileHandle.fileHandle.length);
        typesWriter.writeBytes(this.createAttrs(sFTPv3FileAttributes));
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_FSETSTAT...");
            this.debug.flush();
        }
        this.sendMessage(10, n2, typesWriter.getBytes());
        this.expectStatusOKMessage(n2);
    }

    public void createSymlink(String string, String string2) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string2, this.charsetName);
        typesWriter.writeString(string, this.charsetName);
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_SYMLINK...");
            this.debug.flush();
        }
        this.sendMessage(20, n2, typesWriter.getBytes());
        this.expectStatusOKMessage(n2);
    }

    public String canonicalPath(String string) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_REALPATH...");
            this.debug.flush();
        }
        this.sendMessage(16, n2, typesWriter.getBytes());
        byte[] byArray = this.receiveMessage(34000);
        if (this.debug != null) {
            this.debug.println("Got REPLY.");
            this.debug.flush();
        }
        TypesReader typesReader = new TypesReader(byArray);
        int n3 = typesReader.readByte();
        int n4 = typesReader.readUINT32();
        if (n4 != n2) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (n3 == 104) {
            int n5 = typesReader.readUINT32();
            if (n5 != 1) {
                throw new IOException("The server sent an invalid SSH_FXP_NAME packet.");
            }
            return typesReader.readString(this.charsetName);
        }
        if (n3 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n3 + ")");
        }
        int n6 = typesReader.readUINT32();
        throw new SFTPException(typesReader.readString(), n6);
    }

    private final Vector scanDirectory(byte[] byArray) {
        int n2;
        int n3;
        TypesReader typesReader;
        Vector<SFTPv3DirectoryEntry> vector = new Vector<SFTPv3DirectoryEntry>();
        block0: while (true) {
            int n4 = this.generateNextRequestID();
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeString(byArray, 0, byArray.length);
            if (this.debug != null) {
                this.debug.println("Sending SSH_FXP_READDIR...");
                this.debug.flush();
            }
            this.sendMessage(12, n4, typesWriter.getBytes());
            byte[] byArray2 = this.receiveMessage(65536);
            if (this.debug != null) {
                this.debug.println("Got REPLY.");
                this.debug.flush();
            }
            typesReader = new TypesReader(byArray2);
            n3 = typesReader.readByte();
            int n5 = typesReader.readUINT32();
            if (n5 != n4) {
                throw new IOException("The server sent an invalid id field.");
            }
            if (n3 != 104) break;
            n2 = typesReader.readUINT32();
            if (this.debug != null) {
                this.debug.println("Parsing " + n2 + " name entries...");
            }
            while (true) {
                if (n2 <= 0) continue block0;
                SFTPv3DirectoryEntry sFTPv3DirectoryEntry = new SFTPv3DirectoryEntry();
                sFTPv3DirectoryEntry.filename = typesReader.readString(this.charsetName);
                sFTPv3DirectoryEntry.longEntry = typesReader.readString(this.charsetName);
                sFTPv3DirectoryEntry.attributes = this.readAttrs(typesReader);
                vector.addElement(sFTPv3DirectoryEntry);
                if (this.debug != null) {
                    this.debug.println("File: '" + sFTPv3DirectoryEntry.filename + "'");
                }
                --n2;
            }
            break;
        }
        if (n3 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n3 + ")");
        }
        n2 = typesReader.readUINT32();
        if (n2 == 1) {
            return vector;
        }
        throw new SFTPException(typesReader.readString(), n2);
    }

    private final byte[] openDirectory(String string) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_OPENDIR...");
            this.debug.flush();
        }
        this.sendMessage(11, n2, typesWriter.getBytes());
        byte[] byArray = this.receiveMessage(34000);
        TypesReader typesReader = new TypesReader(byArray);
        int n3 = typesReader.readByte();
        int n4 = typesReader.readUINT32();
        if (n4 != n2) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (n3 == 102) {
            if (this.debug != null) {
                this.debug.println("Got SSH_FXP_HANDLE.");
                this.debug.flush();
            }
            byte[] byArray2 = typesReader.readByteString();
            return byArray2;
        }
        if (n3 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n3 + ")");
        }
        int n5 = typesReader.readUINT32();
        String string2 = typesReader.readString();
        throw new SFTPException(string2, n5);
    }

    private final String expandString(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = byArray[n2 + i2] & 0xFF;
            if (n4 >= 32 && n4 <= 126) {
                stringBuffer.append((char)n4);
                continue;
            }
            stringBuffer.append("{0x" + Integer.toHexString(n4) + "}");
        }
        return stringBuffer.toString();
    }

    private void init() {
        TypesReader typesReader;
        int n2;
        int n3 = 3;
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_INIT (3)...");
        }
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeUINT32(3);
        this.sendMessage(1, 0, typesWriter.getBytes());
        if (this.debug != null) {
            this.debug.println("Waiting for SSH_FXP_VERSION...");
        }
        if ((n2 = (typesReader = new TypesReader(this.receiveMessage(34000))).readByte()) != 2) {
            throw new IOException("The server did not send a SSH_FXP_VERSION packet (got " + n2 + ")");
        }
        this.protocol_version = typesReader.readUINT32();
        if (this.debug != null) {
            this.debug.println("SSH_FXP_VERSION: protocol_version = " + this.protocol_version);
        }
        if (this.protocol_version != 3) {
            throw new IOException("Server version " + this.protocol_version + " is currently not supported");
        }
        while (typesReader.remain() != 0) {
            String string = typesReader.readString();
            byte[] byArray = typesReader.readByteString();
            this.server_extensions.put(string, byArray);
            if (this.debug == null) continue;
            this.debug.println("SSH_FXP_VERSION: extension: " + string + " = '" + this.expandString(byArray, 0, byArray.length) + "'");
        }
    }

    public int getProtocolVersion() {
        return this.protocol_version;
    }

    public void close() {
        this.sess.close();
    }

    public Vector ls(String string) {
        byte[] byArray = this.openDirectory(string);
        Vector vector = this.scanDirectory(byArray);
        this.closeHandle(byArray);
        return vector;
    }

    public void mkdir(String string, int n2) {
        int n3 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        typesWriter.writeUINT32(4);
        typesWriter.writeUINT32(n2);
        this.sendMessage(14, n3, typesWriter.getBytes());
        this.expectStatusOKMessage(n3);
    }

    public void rm(String string) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        this.sendMessage(13, n2, typesWriter.getBytes());
        this.expectStatusOKMessage(n2);
    }

    public void rmdir(String string) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        this.sendMessage(15, n2, typesWriter.getBytes());
        this.expectStatusOKMessage(n2);
    }

    public void mv(String string, String string2) {
        int n2 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        typesWriter.writeString(string2, this.charsetName);
        this.sendMessage(18, n2, typesWriter.getBytes());
        this.expectStatusOKMessage(n2);
    }

    public SFTPv3FileHandle openFileRO(String string) {
        return this.openFile(string, 1, null);
    }

    public SFTPv3FileHandle openFileRW(String string) {
        return this.openFile(string, 3, null);
    }

    public SFTPv3FileHandle createFile(String string) {
        return this.createFile(string, null);
    }

    public SFTPv3FileHandle createFile(String string, SFTPv3FileAttributes sFTPv3FileAttributes) {
        return this.openFile(string, 11, sFTPv3FileAttributes);
    }

    public SFTPv3FileHandle createFileTruncate(String string) {
        return this.createFileTruncate(string, null);
    }

    public SFTPv3FileHandle createFileTruncate(String string, SFTPv3FileAttributes sFTPv3FileAttributes) {
        return this.openFile(string, 27, sFTPv3FileAttributes);
    }

    private byte[] createAttrs(SFTPv3FileAttributes sFTPv3FileAttributes) {
        TypesWriter typesWriter = new TypesWriter();
        int n2 = 0;
        if (sFTPv3FileAttributes == null) {
            typesWriter.writeUINT32(0);
        } else {
            if (sFTPv3FileAttributes.size != null) {
                n2 |= 1;
            }
            if (sFTPv3FileAttributes.uid != null && sFTPv3FileAttributes.gid != null) {
                n2 |= 2;
            }
            if (sFTPv3FileAttributes.permissions != null) {
                n2 |= 4;
            }
            if (sFTPv3FileAttributes.atime != null && sFTPv3FileAttributes.mtime != null) {
                n2 |= 8;
            }
            typesWriter.writeUINT32(n2);
            if (sFTPv3FileAttributes.size != null) {
                typesWriter.writeUINT64(sFTPv3FileAttributes.size);
            }
            if (sFTPv3FileAttributes.uid != null && sFTPv3FileAttributes.gid != null) {
                typesWriter.writeUINT32(sFTPv3FileAttributes.uid);
                typesWriter.writeUINT32(sFTPv3FileAttributes.gid);
            }
            if (sFTPv3FileAttributes.permissions != null) {
                typesWriter.writeUINT32(sFTPv3FileAttributes.permissions);
            }
            if (sFTPv3FileAttributes.atime != null && sFTPv3FileAttributes.mtime != null) {
                typesWriter.writeUINT32(sFTPv3FileAttributes.atime.intValue());
                typesWriter.writeUINT32(sFTPv3FileAttributes.mtime.intValue());
            }
        }
        return typesWriter.getBytes();
    }

    private SFTPv3FileHandle openFile(String string, int n2, SFTPv3FileAttributes sFTPv3FileAttributes) {
        int n3 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(string, this.charsetName);
        typesWriter.writeUINT32(n2);
        typesWriter.writeBytes(this.createAttrs(sFTPv3FileAttributes));
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_OPEN...");
            this.debug.flush();
        }
        this.sendMessage(3, n3, typesWriter.getBytes());
        byte[] byArray = this.receiveMessage(34000);
        TypesReader typesReader = new TypesReader(byArray);
        int n4 = typesReader.readByte();
        int n5 = typesReader.readUINT32();
        if (n5 != n3) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (n4 == 102) {
            if (this.debug != null) {
                this.debug.println("Got SSH_FXP_HANDLE.");
                this.debug.flush();
            }
            return new SFTPv3FileHandle(this, typesReader.readByteString());
        }
        if (n4 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n4 + ")");
        }
        int n6 = typesReader.readUINT32();
        String string2 = typesReader.readString();
        throw new SFTPException(string2, n6);
    }

    public int read(SFTPv3FileHandle sFTPv3FileHandle, long l2, byte[] byArray, int n2, int n3) {
        this.checkHandleValidAndOpen(sFTPv3FileHandle);
        if (n3 > 32768 || n3 <= 0) {
            throw new IllegalArgumentException("invalid len argument");
        }
        int n4 = this.generateNextRequestID();
        TypesWriter typesWriter = new TypesWriter();
        typesWriter.writeString(sFTPv3FileHandle.fileHandle, 0, sFTPv3FileHandle.fileHandle.length);
        typesWriter.writeUINT64(l2);
        typesWriter.writeUINT32(n3);
        if (this.debug != null) {
            this.debug.println("Sending SSH_FXP_READ...");
            this.debug.flush();
        }
        this.sendMessage(5, n4, typesWriter.getBytes());
        byte[] byArray2 = this.receiveMessage(34000);
        TypesReader typesReader = new TypesReader(byArray2);
        int n5 = typesReader.readByte();
        int n6 = typesReader.readUINT32();
        if (n6 != n4) {
            throw new IOException("The server sent an invalid id field.");
        }
        if (n5 == 103) {
            int n7;
            if (this.debug != null) {
                this.debug.println("Got SSH_FXP_DATA...");
                this.debug.flush();
            }
            if ((n7 = typesReader.readUINT32()) < 0 || n7 > n3) {
                throw new IOException("The server sent an invalid length field.");
            }
            typesReader.readBytes(byArray, n2, n7);
            return n7;
        }
        if (n5 != 101) {
            throw new IOException("The SFTP server sent an unexpected packet type (" + n5 + ")");
        }
        int n8 = typesReader.readUINT32();
        if (n8 == 1) {
            if (this.debug != null) {
                this.debug.println("Got SSH_FX_EOF.");
                this.debug.flush();
            }
            return -1;
        }
        String string = typesReader.readString();
        throw new SFTPException(string, n8);
    }

    public void write(SFTPv3FileHandle sFTPv3FileHandle, long l2, byte[] byArray, int n2, int n3) {
        this.checkHandleValidAndOpen(sFTPv3FileHandle);
        while (n3 > 0) {
            int n4 = n3;
            if (n4 > 32768) {
                n4 = 32768;
            }
            int n5 = this.generateNextRequestID();
            TypesWriter typesWriter = new TypesWriter();
            typesWriter.writeString(sFTPv3FileHandle.fileHandle, 0, sFTPv3FileHandle.fileHandle.length);
            typesWriter.writeUINT64(l2);
            typesWriter.writeString(byArray, n2, n4);
            if (this.debug != null) {
                this.debug.println("Sending SSH_FXP_WRITE...");
                this.debug.flush();
            }
            this.sendMessage(6, n5, typesWriter.getBytes());
            l2 += (long)n4;
            n2 += n4;
            n3 -= n4;
            byte[] byArray2 = this.receiveMessage(34000);
            TypesReader typesReader = new TypesReader(byArray2);
            int n6 = typesReader.readByte();
            int n7 = typesReader.readUINT32();
            if (n7 != n5) {
                throw new IOException("The server sent an invalid id field.");
            }
            if (n6 != 101) {
                throw new IOException("The SFTP server sent an unexpected packet type (" + n6 + ")");
            }
            int n8 = typesReader.readUINT32();
            if (n8 == 0) continue;
            String string = typesReader.readString();
            throw new SFTPException(string, n8);
        }
    }

    public void closeFile(SFTPv3FileHandle sFTPv3FileHandle) {
        if (sFTPv3FileHandle == null) {
            throw new IllegalArgumentException("the handle argument may not be null");
        }
        try {
            if (!sFTPv3FileHandle.isClosed) {
                this.closeHandle(sFTPv3FileHandle.fileHandle);
            }
        }
        finally {
            sFTPv3FileHandle.isClosed = true;
        }
    }
}

