/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.sftp.ErrorCodes;
import java.io.IOException;

public class SFTPException
extends IOException {
    private static final long serialVersionUID = 578654644222421811L;
    private final String sftpErrorMessage;
    private final int sftpErrorCode;

    private static String constructMessage(String string, int n2) {
        String[] stringArray = ErrorCodes.getDescription(n2);
        if (stringArray == null) {
            return string + " (UNKNOW SFTP ERROR CODE)";
        }
        return string + " (" + stringArray[0] + ": " + stringArray[1] + ")";
    }

    SFTPException(String string, int n2) {
        super(SFTPException.constructMessage(string, n2));
        this.sftpErrorMessage = string;
        this.sftpErrorCode = n2;
    }

    public String getServerErrorMessage() {
        return this.sftpErrorMessage;
    }

    public int getServerErrorCode() {
        return this.sftpErrorCode;
    }

    public String getServerErrorCodeSymbol() {
        String[] stringArray = ErrorCodes.getDescription(this.sftpErrorCode);
        if (stringArray == null) {
            return "UNKNOW SFTP ERROR CODE " + this.sftpErrorCode;
        }
        return stringArray[0];
    }

    public String getServerErrorCodeVerbose() {
        String[] stringArray = ErrorCodes.getDescription(this.sftpErrorCode);
        if (stringArray == null) {
            return "The error code " + this.sftpErrorCode + " is unknown.";
        }
        return stringArray[1];
    }
}

