/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient$LenNamePair;
import com.trilead.ssh2.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SCPClient {
    Connection conn;

    public SCPClient(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.conn = connection;
    }

    private void readResponse(InputStream inputStream) {
        int n2 = inputStream.read();
        if (n2 == 0) {
            return;
        }
        if (n2 == -1) {
            throw new IOException("Remote scp terminated unexpectedly.");
        }
        if (n2 != 1 && n2 != 2) {
            throw new IOException("Remote scp sent illegal error code.");
        }
        if (n2 == 2) {
            throw new IOException("Remote scp terminated with error.");
        }
        String string = this.receiveLine(inputStream);
        throw new IOException("Remote scp terminated with error (" + string + ").");
    }

    private String receiveLine(InputStream inputStream) {
        StringBuffer stringBuffer = new StringBuffer(30);
        while (true) {
            if (stringBuffer.length() > 8192) {
                throw new IOException("Remote scp sent a too long line");
            }
            int n2 = inputStream.read();
            if (n2 < 0) {
                throw new IOException("Remote scp terminated unexpectedly.");
            }
            if (n2 == 10) break;
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    private SCPClient$LenNamePair parseCLine(String string) {
        long l2;
        if (string.length() < 8) {
            throw new IOException("Malformed C line sent by remote SCP binary, line too short.");
        }
        if (string.charAt(4) != ' ' || string.charAt(5) == ' ') {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        int n2 = string.indexOf(32, 5);
        if (n2 == -1) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        String string2 = string.substring(5, n2);
        String string3 = string.substring(n2 + 1);
        if (string2.length() <= 0 || string3.length() <= 0) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        if (6 + string2.length() + string3.length() != string.length()) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        try {
            l2 = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (l2 < 0L) {
            throw new IOException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        SCPClient$LenNamePair sCPClient$LenNamePair = new SCPClient$LenNamePair(this);
        sCPClient$LenNamePair.length = l2;
        sCPClient$LenNamePair.filename = string3;
        return sCPClient$LenNamePair;
    }

    private void sendBytes(Session session, byte[] byArray, String string, String string2) {
        OutputStream outputStream = session.getStdin();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(session.getStdout(), 512);
        this.readResponse(bufferedInputStream);
        String string3 = "C" + string2 + " " + byArray.length + " " + string + "\n";
        outputStream.write(string3.getBytes("ISO-8859-1"));
        outputStream.flush();
        this.readResponse(bufferedInputStream);
        outputStream.write(byArray, 0, byArray.length);
        outputStream.write(0);
        outputStream.flush();
        this.readResponse(bufferedInputStream);
        outputStream.write("E\n".getBytes("ISO-8859-1"));
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFiles(Session session, String[] stringArray, String[] stringArray2, String string) {
        byte[] byArray = new byte[8192];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(session.getStdin(), 40000);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(session.getStdout(), 512);
        this.readResponse(bufferedInputStream);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            long l2;
            File file = new File(stringArray[i2]);
            String string2 = stringArray2 != null && stringArray2.length > i2 && stringArray2[i2] != null ? stringArray2[i2] : file.getName();
            String string3 = "C" + string + " " + l2 + " " + string2 + "\n";
            ((OutputStream)bufferedOutputStream).write(string3.getBytes("ISO-8859-1"));
            ((OutputStream)bufferedOutputStream).flush();
            this.readResponse(bufferedInputStream);
            FileInputStream fileInputStream = null;
            try {
                int n2;
                fileInputStream = new FileInputStream(file);
                for (l2 = file.length(); l2 > 0L; l2 -= (long)n2) {
                    n2 = l2 > (long)byArray.length ? byArray.length : (int)l2;
                    if (fileInputStream.read(byArray, 0, n2) != n2) {
                        throw new IOException("Cannot read enough from local file " + stringArray[i2]);
                    }
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                }
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).flush();
            this.readResponse(bufferedInputStream);
        }
        ((OutputStream)bufferedOutputStream).write("E\n".getBytes("ISO-8859-1"));
        ((OutputStream)bufferedOutputStream).flush();
    }

    private void receiveFiles(Session session, OutputStream[] outputStreamArray) {
        byte[] byArray = new byte[8192];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(session.getStdin(), 512);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(session.getStdout(), 40000);
        ((OutputStream)bufferedOutputStream).write(0);
        ((OutputStream)bufferedOutputStream).flush();
        for (int i2 = 0; i2 < outputStreamArray.length; ++i2) {
            int n2;
            String string;
            int n3;
            SCPClient$LenNamePair sCPClient$LenNamePair = null;
            do {
                if ((n3 = ((InputStream)bufferedInputStream).read()) < 0) {
                    throw new IOException("Remote scp terminated unexpectedly.");
                }
                string = this.receiveLine(bufferedInputStream);
            } while (n3 == 84);
            if (n3 == 1 || n3 == 2) {
                throw new IOException("Remote SCP error: " + string);
            }
            if (n3 != 67) {
                throw new IOException("Remote SCP error: " + (char)n3 + string);
            }
            sCPClient$LenNamePair = this.parseCLine(string);
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).flush();
            for (long i3 = sCPClient$LenNamePair.length; i3 > 0L; i3 -= (long)n2) {
                int n4 = i3 > (long)byArray.length ? byArray.length : (int)i3;
                n2 = ((InputStream)bufferedInputStream).read(byArray, 0, n4);
                if (n2 < 0) {
                    throw new IOException("Remote scp terminated connection unexpectedly");
                }
                outputStreamArray[i2].write(byArray, 0, n2);
            }
            this.readResponse(bufferedInputStream);
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFiles(Session session, String[] stringArray, String string) {
        byte[] byArray = new byte[8192];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(session.getStdin(), 512);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(session.getStdout(), 40000);
        ((OutputStream)bufferedOutputStream).write(0);
        ((OutputStream)bufferedOutputStream).flush();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Object object;
            int n2;
            SCPClient$LenNamePair sCPClient$LenNamePair = null;
            do {
                if ((n2 = ((InputStream)bufferedInputStream).read()) < 0) {
                    throw new IOException("Remote scp terminated unexpectedly.");
                }
                object = this.receiveLine(bufferedInputStream);
            } while (n2 == 84);
            if (n2 == 1 || n2 == 2) {
                throw new IOException("Remote SCP error: " + (String)object);
            }
            if (n2 != 67) {
                throw new IOException("Remote SCP error: " + (char)n2 + (String)object);
            }
            sCPClient$LenNamePair = this.parseCLine((String)object);
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).flush();
            File file = new File(string + File.separatorChar + sCPClient$LenNamePair.filename);
            object = null;
            try {
                int n3;
                object = new FileOutputStream(file);
                for (long i3 = sCPClient$LenNamePair.length; i3 > 0L; i3 -= (long)n3) {
                    int n4 = i3 > (long)byArray.length ? byArray.length : (int)i3;
                    n3 = ((InputStream)bufferedInputStream).read(byArray, 0, n4);
                    if (n3 < 0) {
                        throw new IOException("Remote scp terminated connection unexpectedly");
                    }
                    ((FileOutputStream)object).write(byArray, 0, n3);
                }
            }
            finally {
                if (object != null) {
                    ((FileOutputStream)object).close();
                }
            }
            this.readResponse(bufferedInputStream);
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).flush();
        }
    }

    public void put(String string, String string2) {
        this.put(new String[]{string}, string2, "0600");
    }

    public void put(String[] stringArray, String string) {
        this.put(stringArray, string, "0600");
    }

    public void put(String string, String string2, String string3) {
        this.put(new String[]{string}, string2, string3);
    }

    public void put(String string, String string2, String string3, String string4) {
        this.put(new String[]{string}, new String[]{string2}, string3, string4);
    }

    public void put(byte[] byArray, String string, String string2) {
        this.put(byArray, string, string2, "0600");
    }

    public void put(byte[] byArray, String string, String string2, String string3) {
        Session session = null;
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (string3.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        for (int i2 = 0; i2 < string3.length(); ++i2) {
            if (Character.isDigit(string3.charAt(i2))) continue;
            throw new IllegalArgumentException("Invalid mode.");
        }
        string2 = (string2 = string2.trim()).length() > 0 ? string2 : ".";
        String string4 = "scp -t -d " + string2;
        try {
            session = this.conn.openSession();
            session.execCommand(string4);
            this.sendBytes(session, byArray, string, string3);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Error during SCP transfer.").initCause(iOException);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void put(String[] stringArray, String string, String string2) {
        this.put(stringArray, null, string, string2);
    }

    public void put(String[] stringArray, String[] stringArray2, String string, String string2) {
        Session session = null;
        if (stringArray == null || string == null || string2 == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (string2.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (Character.isDigit(string2.charAt(i2))) continue;
            throw new IllegalArgumentException("Invalid mode.");
        }
        if (stringArray.length == 0) {
            return;
        }
        string = (string = string.trim()).length() > 0 ? string : ".";
        String string3 = "scp -t -d " + string;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (stringArray[i3] != null) continue;
            throw new IllegalArgumentException("Cannot accept null filename.");
        }
        try {
            session = this.conn.openSession();
            session.execCommand(string3);
            this.sendFiles(session, stringArray, stringArray2, string2);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Error during SCP transfer.").initCause(iOException);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void get(String string, String string2) {
        this.get(new String[]{string}, string2);
    }

    public void get(String string, OutputStream outputStream) {
        this.get(new String[]{string}, new OutputStream[]{outputStream});
    }

    private void get(String[] stringArray, OutputStream[] outputStreamArray) {
        Session session = null;
        if (stringArray == null || outputStreamArray == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (stringArray.length != outputStreamArray.length) {
            throw new IllegalArgumentException("Length of arguments does not match.");
        }
        if (stringArray.length == 0) {
            return;
        }
        String string = "scp -f";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null) {
                throw new IllegalArgumentException("Cannot accept null filename.");
            }
            String string2 = stringArray[i2].trim();
            if (string2.length() == 0) {
                throw new IllegalArgumentException("Cannot accept empty filename.");
            }
            string = string + " " + string2;
        }
        try {
            session = this.conn.openSession();
            session.execCommand(string);
            this.receiveFiles(session, outputStreamArray);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Error during SCP transfer.").initCause(iOException);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public void get(String[] stringArray, String string) {
        Session session = null;
        if (stringArray == null || string == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (stringArray.length == 0) {
            return;
        }
        String string2 = "scp -f";
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2] == null) {
                throw new IllegalArgumentException("Cannot accept null filename.");
            }
            String string3 = stringArray[i2].trim();
            if (string3.length() == 0) {
                throw new IllegalArgumentException("Cannot accept empty filename.");
            }
            string2 = string2 + " " + string3;
        }
        try {
            session = this.conn.openSession();
            session.execCommand(string2);
            this.receiveFiles(session, stringArray, string);
        }
        catch (IOException iOException) {
            throw (IOException)new IOException("Error during SCP transfer.").initCause(iOException);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

