/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.IOWarningException;
import com.trilead.ssh2.KnownHosts$KnownHostsEntry;
import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.crypto.digest.Digest;
import com.trilead.ssh2.crypto.digest.HMAC;
import com.trilead.ssh2.crypto.digest.MD5;
import com.trilead.ssh2.crypto.digest.SHA1;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.signature.DSAPublicKey;
import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.RSAPublicKey;
import com.trilead.ssh2.signature.RSASHA1Verify;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.Vector;

public class KnownHosts {
    private static final Logger LOGGER = Logger.getLogger(KnownHosts.class);
    public static final int HOSTKEY_IS_OK = 0;
    public static final int HOSTKEY_IS_NEW = 1;
    public static final int HOSTKEY_HAS_CHANGED = 2;
    private LinkedList publicKeys = new LinkedList();

    public KnownHosts() {
    }

    public KnownHosts(char[] cArray) {
        this.initialize(cArray);
    }

    public KnownHosts(File file) {
        this.initialize(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostkey(String[] stringArray, String string, byte[] byArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("hostnames may not be null");
        }
        if ("ssh-rsa".equals(string)) {
            RSAPublicKey rSAPublicKey = RSASHA1Verify.decodeSSHRSAPublicKey(byArray);
            LinkedList linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHosts$KnownHostsEntry(this, stringArray, rSAPublicKey));
            }
        } else if ("ssh-dss".equals(string)) {
            DSAPublicKey dSAPublicKey = DSASHA1Verify.decodeSSHDSAPublicKey(byArray);
            LinkedList linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHosts$KnownHostsEntry(this, stringArray, dSAPublicKey));
            }
        } else {
            throw new IOWarningException("Unknwon host key type (" + string + ")");
        }
    }

    public void addHostkeys(char[] cArray) {
        this.initialize(cArray);
    }

    public void addHostkeys(File file) {
        this.initialize(file);
    }

    public static final String createHashedHostname(String string) {
        SHA1 sHA1 = new SHA1();
        byte[] byArray = new byte[sHA1.getDigestLength()];
        new SecureRandom().nextBytes(byArray);
        byte[] byArray2 = KnownHosts.hmacSha1Hash(byArray, string);
        String string2 = new String(Base64.encode(byArray));
        String string3 = new String(Base64.encode(byArray2));
        return new String("|1|" + string2 + "|" + string3);
    }

    private static final byte[] hmacSha1Hash(byte[] byArray, String string) {
        SHA1 sHA1 = new SHA1();
        if (byArray.length != sHA1.getDigestLength()) {
            throw new IllegalArgumentException("Salt has wrong length (" + byArray.length + ")");
        }
        HMAC hMAC = new HMAC(sHA1, byArray, byArray.length);
        try {
            hMAC.update(string.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            hMAC.update(string.getBytes());
        }
        byte[] byArray2 = new byte[hMAC.getDigestLength()];
        hMAC.digest(byArray2);
        return byArray2;
    }

    private final boolean checkHashed(String string, String string2) {
        if (!string.startsWith("|1|")) {
            return false;
        }
        int n2 = string.indexOf(124, 3);
        if (n2 == -1) {
            return false;
        }
        String string3 = string.substring(3, n2);
        String string4 = string.substring(n2 + 1);
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            byArray = Base64.decode(string3.toCharArray());
            byArray2 = Base64.decode(string4.toCharArray());
        }
        catch (IOException iOException) {
            return false;
        }
        SHA1 sHA1 = new SHA1();
        if (byArray.length != sHA1.getDigestLength()) {
            return false;
        }
        byte[] byArray3 = KnownHosts.hmacSha1Hash(byArray, string2);
        for (int i2 = 0; i2 < byArray3.length; ++i2) {
            if (byArray3[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkKey(String string, Object object) {
        int n2 = 1;
        LinkedList linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHosts$KnownHostsEntry knownHosts$KnownHostsEntry : this.publicKeys) {
                if (!this.hostnameMatches(knownHosts$KnownHostsEntry.patterns, string)) continue;
                boolean bl2 = this.matchKeys(knownHosts$KnownHostsEntry.key, object);
                if (bl2) {
                    return 0;
                }
                n2 = 2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getAllKeys(String string) {
        Vector<Object> vector = new Vector<Object>();
        LinkedList linkedList = this.publicKeys;
        synchronized (linkedList) {
            for (KnownHosts$KnownHostsEntry knownHosts$KnownHostsEntry : this.publicKeys) {
                if (!this.hostnameMatches(knownHosts$KnownHostsEntry.patterns, string)) continue;
                vector.addElement(knownHosts$KnownHostsEntry.key);
            }
        }
        return vector;
    }

    public String[] getPreferredServerHostkeyAlgorithmOrder(String string) {
        String[] stringArray = this.recommendHostkeyAlgorithms(string);
        if (stringArray != null) {
            return stringArray;
        }
        InetAddress[] inetAddressArray = null;
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            stringArray = this.recommendHostkeyAlgorithms(inetAddressArray[i2].getHostAddress());
            if (stringArray == null) continue;
            return stringArray;
        }
        return null;
    }

    private final boolean hostnameMatches(String[] stringArray, String string) {
        boolean bl2 = false;
        boolean bl3 = false;
        string = string.toLowerCase();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2;
            if (stringArray[i2] == null) continue;
            String string3 = null;
            if (stringArray[i2].length() > 0 && stringArray[i2].charAt(0) == '!') {
                string3 = stringArray[i2].substring(1);
                bl3 = true;
            } else {
                string3 = stringArray[i2];
                bl3 = false;
            }
            if (bl2 && !bl3) continue;
            if (string3.charAt(0) == '|') {
                if (!this.checkHashed(string3, string)) continue;
                if (bl3) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if ((string3 = string3.toLowerCase()).indexOf(63) != -1 || string3.indexOf(42) != -1) {
                if (!this.pseudoRegex(string3.toCharArray(), 0, string.toCharArray(), 0)) continue;
                if (bl3) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (string3.compareTo(string) == 0) {
                if (bl3) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            int n2 = string3.indexOf(58);
            int n3 = string3.indexOf(58);
            if (n2 <= 0 || n2 >= string3.length() - 2 || n2 != n3 || !string3.startsWith(string2 = '[' + string + ']')) continue;
            if (bl3) {
                return false;
            }
            bl2 = true;
        }
        return bl2;
    }

    private void initialize(char[] cArray) {
        BufferedReader bufferedReader = new BufferedReader(new CharArrayReader(cArray));
        String string = bufferedReader.readLine();
        while (string != null) {
            String string2;
            String[] stringArray;
            if (!(string = string.trim()).startsWith("#") && (stringArray = string.split(" ")).length >= 3 && ("ssh-rsa".equals(string2 = stringArray[1]) || "ssh-dss".equals(string2))) {
                String[] stringArray2 = stringArray[0].split(",");
                byte[] byArray = Base64.decode(stringArray[2].toCharArray());
                try {
                    this.addHostkey(stringArray2, string2, byArray);
                }
                catch (IOWarningException iOWarningException) {
                    LOGGER.log(20, "Ignored invalid line '" + string + "'");
                }
            }
            string = bufferedReader.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(File file) {
        char[] cArray = new char[512];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        file.createNewFile();
        FileReader fileReader = new FileReader(file);
        try {
            int n2;
            while ((n2 = fileReader.read(cArray)) >= 0) {
                charArrayWriter.write(cArray, 0, n2);
            }
        }
        finally {
            ((Reader)fileReader).close();
        }
        this.initialize(charArrayWriter.toCharArray());
    }

    private final boolean matchKeys(Object object, Object object2) {
        if (object instanceof RSAPublicKey && object2 instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
            RSAPublicKey rSAPublicKey2 = (RSAPublicKey)object2;
            if (!rSAPublicKey.getE().equals(rSAPublicKey2.getE())) {
                return false;
            }
            return rSAPublicKey.getN().equals(rSAPublicKey2.getN());
        }
        if (object instanceof DSAPublicKey && object2 instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
            DSAPublicKey dSAPublicKey2 = (DSAPublicKey)object2;
            if (!dSAPublicKey.getG().equals(dSAPublicKey2.getG())) {
                return false;
            }
            if (!dSAPublicKey.getP().equals(dSAPublicKey2.getP())) {
                return false;
            }
            if (!dSAPublicKey.getQ().equals(dSAPublicKey2.getQ())) {
                return false;
            }
            return dSAPublicKey.getY().equals(dSAPublicKey2.getY());
        }
        return false;
    }

    private final boolean pseudoRegex(char[] cArray, int n2, char[] cArray2, int n3) {
        while (cArray.length != n2) {
            if (cArray[n2] == '*') {
                if (cArray.length == ++n2) {
                    return true;
                }
                if (cArray[n2] != '*' && cArray[n2] != '?') {
                    do {
                        if (cArray[n2] != cArray2[n3] || !this.pseudoRegex(cArray, n2 + 1, cArray2, n3 + 1)) continue;
                        return true;
                    } while (cArray2.length != ++n3);
                    return false;
                }
                do {
                    if (!this.pseudoRegex(cArray, n2, cArray2, n3)) continue;
                    return true;
                } while (cArray2.length != ++n3);
                return false;
            }
            if (cArray2.length == n3) {
                return false;
            }
            if (cArray[n2] != '?' && cArray[n2] != cArray2[n3]) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return cArray2.length == n3;
    }

    private String[] recommendHostkeyAlgorithms(String string) {
        String string2 = null;
        Vector vector = this.getAllKeys(string);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            String string3 = null;
            if (vector.elementAt(i2) instanceof RSAPublicKey) {
                string3 = "ssh-rsa";
            } else {
                if (!(vector.elementAt(i2) instanceof DSAPublicKey)) continue;
                string3 = "ssh-dss";
            }
            if (string2 == null || string2.compareTo(string3) == 0) continue;
            return null;
        }
        if (string2 == null) {
            return null;
        }
        if (string2.equals("ssh-rsa")) {
            return new String[]{"ssh-rsa", "ssh-dss"};
        }
        return new String[]{"ssh-dss", "ssh-rsa"};
    }

    public int verifyHostkey(String string, String string2, byte[] byArray) {
        Object object = null;
        if ("ssh-rsa".equals(string2)) {
            object = RSASHA1Verify.decodeSSHRSAPublicKey(byArray);
        } else if ("ssh-dss".equals(string2)) {
            object = DSASHA1Verify.decodeSSHDSAPublicKey(byArray);
        } else {
            throw new IllegalArgumentException("Unknown hostkey type " + string2);
        }
        int n2 = this.checkKey(string, object);
        if (n2 == 0) {
            return n2;
        }
        InetAddress[] inetAddressArray = null;
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return n2;
        }
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            int n3 = this.checkKey(inetAddressArray[i2].getHostAddress(), object);
            if (n3 == 0) {
                return n3;
            }
            if (n3 != 2) continue;
            n2 = 2;
        }
        return n2;
    }

    public static final void addHostkeyToFile(File file, String[] stringArray, String string, byte[] byArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Need at least one hostname specification");
        }
        if (string == null || byArray == null) {
            throw new IllegalArgumentException();
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 != 0) {
                charArrayWriter.write(44);
            }
            charArrayWriter.write(stringArray[i2]);
        }
        charArrayWriter.write(32);
        charArrayWriter.write(string);
        charArrayWriter.write(32);
        charArrayWriter.write(Base64.encode(byArray));
        charArrayWriter.write("\n");
        char[] cArray = charArrayWriter.toCharArray();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        long l2 = randomAccessFile.length();
        if (l2 > 0L) {
            randomAccessFile.seek(l2 - 1L);
            int n2 = randomAccessFile.read();
            if (n2 != 10) {
                randomAccessFile.write(10);
            }
        }
        randomAccessFile.write(new String(cArray).getBytes("ISO-8859-1"));
        randomAccessFile.close();
    }

    private static final byte[] rawFingerPrint(String string, String string2, byte[] byArray) {
        Digest digest = null;
        if ("md5".equals(string)) {
            digest = new MD5();
        } else if ("sha1".equals(string)) {
            digest = new SHA1();
        } else {
            throw new IllegalArgumentException("Unknown hash type " + string);
        }
        if (!"ssh-rsa".equals(string2) && !"ssh-dss".equals(string2)) {
            throw new IllegalArgumentException("Unknown key type " + string2);
        }
        if (byArray == null) {
            throw new IllegalArgumentException("hostkey is null");
        }
        digest.update(byArray);
        byte[] byArray2 = new byte[digest.getDigestLength()];
        digest.digest(byArray2);
        return byArray2;
    }

    private static final String rawToHexFingerprint(byte[] byArray) {
        char[] cArray = "0123456789abcdef".toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(':');
            }
            int n2 = byArray[i2] & 0xFF;
            stringBuffer.append(cArray[n2 >> 4]);
            stringBuffer.append(cArray[n2 & 0xF]);
        }
        return stringBuffer.toString();
    }

    private static final String rawToBubblebabbleFingerprint(byte[] byArray) {
        char[] cArray = "aeiouy".toCharArray();
        char[] cArray2 = "bcdfghklmnprstvzx".toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1;
        int n3 = byArray.length / 2 + 1;
        stringBuffer.append('x');
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 + 1 < n3 || byArray.length % 2 != 0) {
                stringBuffer.append(cArray[((byArray[2 * i2] >> 6 & 3) + n2) % 6]);
                stringBuffer.append(cArray2[byArray[2 * i2] >> 2 & 0xF]);
                stringBuffer.append(cArray[((byArray[2 * i2] & 3) + n2 / 6) % 6]);
                if (i2 + 1 >= n3) continue;
                stringBuffer.append(cArray2[byArray[2 * i2 + 1] >> 4 & 0xF]);
                stringBuffer.append('-');
                stringBuffer.append(cArray2[byArray[2 * i2 + 1] & 0xF]);
                n2 = (n2 * 5 + ((byArray[2 * i2] & 0xFF) * 7 + (byArray[2 * i2 + 1] & 0xFF))) % 36;
                continue;
            }
            stringBuffer.append(cArray[n2 % 6]);
            stringBuffer.append('x');
            stringBuffer.append(cArray[n2 / 6]);
        }
        stringBuffer.append('x');
        return stringBuffer.toString();
    }

    public static final String createHexFingerprint(String string, byte[] byArray) {
        byte[] byArray2 = KnownHosts.rawFingerPrint("md5", string, byArray);
        return KnownHosts.rawToHexFingerprint(byArray2);
    }

    public static final String createBubblebabbleFingerprint(String string, byte[] byArray) {
        byte[] byArray2 = KnownHosts.rawFingerPrint("sha1", string, byArray);
        return KnownHosts.rawToBubblebabbleFingerprint(byArray2);
    }
}

