/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

public class DHGexParameters {
    private final int min_group_len;
    private final int pref_group_len;
    private final int max_group_len;
    private static final int MIN_ALLOWED = 1024;
    private static final int MAX_ALLOWED = 8192;

    public DHGexParameters() {
        this(1024, 1024, 4096);
    }

    public DHGexParameters(int n2) {
        if (n2 < 1024 || n2 > 8192) {
            throw new IllegalArgumentException("pref_group_len out of range!");
        }
        this.pref_group_len = n2;
        this.min_group_len = 0;
        this.max_group_len = 0;
    }

    public DHGexParameters(int n2, int n3, int n4) {
        if (n2 < 1024 || n2 > 8192) {
            throw new IllegalArgumentException("min_group_len out of range!");
        }
        if (n3 < 1024 || n3 > 8192) {
            throw new IllegalArgumentException("pref_group_len out of range!");
        }
        if (n4 < 1024 || n4 > 8192) {
            throw new IllegalArgumentException("max_group_len out of range!");
        }
        if (n3 < n2 || n3 > n4) {
            throw new IllegalArgumentException("pref_group_len is incompatible with min and max!");
        }
        if (n4 < n2) {
            throw new IllegalArgumentException("max_group_len must not be smaller than min_group_len!");
        }
        this.min_group_len = n2;
        this.pref_group_len = n3;
        this.max_group_len = n4;
    }

    public int getMax_group_len() {
        return this.max_group_len;
    }

    public int getMin_group_len() {
        return this.min_group_len;
    }

    public int getPref_group_len() {
        return this.pref_group_len;
    }
}

