/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.Connection$1;
import com.trilead.ssh2.Connection$1TimeoutState;
import com.trilead.ssh2.Connection$2;
import com.trilead.ssh2.ConnectionInfo;
import com.trilead.ssh2.ConnectionMonitor;
import com.trilead.ssh2.DHGexParameters;
import com.trilead.ssh2.DebugLogger;
import com.trilead.ssh2.HTTPProxyException;
import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.LocalPortForwarder;
import com.trilead.ssh2.LocalStreamForwarder;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.auth.AgentProxy;
import com.trilead.ssh2.auth.AuthenticationManager;
import com.trilead.ssh2.channel.ChannelManager;
import com.trilead.ssh2.crypto.CryptoWishList;
import com.trilead.ssh2.crypto.cipher.BlockCipherFactory;
import com.trilead.ssh2.crypto.digest.MAC;
import com.trilead.ssh2.log.Logger;
import com.trilead.ssh2.packets.PacketIgnore;
import com.trilead.ssh2.transport.ClientServerHello;
import com.trilead.ssh2.transport.KexManager;
import com.trilead.ssh2.transport.TransportManager;
import com.trilead.ssh2.util.TimeoutService;
import com.trilead.ssh2.util.TimeoutService$TimeoutToken;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import java.util.Vector;

public class Connection {
    public static final String identification = "TrileadSSH2Java_213";
    private SecureRandom generator;
    private AuthenticationManager am;
    private boolean authenticated = false;
    private ChannelManager cm;
    private CryptoWishList cryptoWishList = new CryptoWishList();
    private DHGexParameters dhgexpara = new DHGexParameters();
    private final String hostname;
    private final int port;
    private TransportManager tm;
    private boolean tcpNoDelay = false;
    private ProxyData proxyData = null;
    private Vector connectionMonitors = new Vector();

    public static synchronized String[] getAvailableCiphers() {
        return BlockCipherFactory.getDefaultCipherList();
    }

    public static synchronized String[] getAvailableMACs() {
        return MAC.getMacList();
    }

    public static synchronized String[] getAvailableServerHostKeyAlgorithms() {
        return KexManager.getDefaultServerHostkeyAlgorithmList();
    }

    public Connection(String string) {
        this(string, 22);
    }

    public Connection(String string, int n2) {
        this.hostname = string;
        this.port = n2;
    }

    public synchronized boolean authenticateWithDSA(String string, String string2, String string3) {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("pem argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(string, string2.toCharArray(), string3, this.getOrCreateSecureRND());
        return this.authenticated;
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String string, InteractiveCallback interactiveCallback) {
        return this.authenticateWithKeyboardInteractive(string, null, interactiveCallback);
    }

    public synchronized boolean authenticateWithAgent(String string, AgentProxy agentProxy) {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(string, agentProxy);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithKeyboardInteractive(String string, String[] stringArray, InteractiveCallback interactiveCallback) {
        if (interactiveCallback == null) {
            throw new IllegalArgumentException("Callback may not ne NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticateInteractive(string, stringArray, interactiveCallback);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPassword(String string, String string2) {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("password argument is null");
        }
        this.authenticated = this.am.authenticatePassword(string, string2);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithNone(String string) {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        this.authenticated = this.am.authenticateNone(string);
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String string, char[] cArray, String string2) {
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        if (string == null) {
            throw new IllegalArgumentException("user argument is null");
        }
        if (cArray == null) {
            throw new IllegalArgumentException("pemPrivateKey argument is null");
        }
        this.authenticated = this.am.authenticatePublicKey(string, cArray, string2, this.getOrCreateSecureRND());
        return this.authenticated;
    }

    public synchronized boolean authenticateWithPublicKey(String string, File file, String string2) {
        int n2;
        if (file == null) {
            throw new IllegalArgumentException("pemFile argument is null");
        }
        char[] cArray = new char[256];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        FileReader fileReader = new FileReader(file);
        while ((n2 = fileReader.read(cArray)) >= 0) {
            charArrayWriter.write(cArray, 0, n2);
        }
        fileReader.close();
        return this.authenticateWithPublicKey(string, charArrayWriter.toCharArray(), string2);
    }

    public synchronized void addConnectionMonitor(ConnectionMonitor connectionMonitor) {
        if (connectionMonitor == null) {
            throw new IllegalArgumentException("cmon argument is null");
        }
        this.connectionMonitors.addElement(connectionMonitor);
        if (this.tm != null) {
            this.tm.setConnectionMonitors(this.connectionMonitors);
        }
    }

    public synchronized void close() {
        Throwable throwable = new Throwable("Closed due to user request.");
        this.close(throwable, false);
    }

    private void close(Throwable throwable, boolean bl2) {
        if (this.cm != null) {
            this.cm.closeAllChannels();
        }
        if (this.tm != null) {
            this.tm.close(throwable, !bl2);
            this.tm = null;
        }
        this.am = null;
        this.cm = null;
        this.authenticated = false;
    }

    public synchronized ConnectionInfo connect() {
        return this.connect(null, 0, 0);
    }

    public synchronized ConnectionInfo connect(ServerHostKeyVerifier serverHostKeyVerifier) {
        return this.connect(serverHostKeyVerifier, 0, 0);
    }

    public synchronized ConnectionInfo connect(ServerHostKeyVerifier serverHostKeyVerifier, int n2, int n3) {
        return this.connect(serverHostKeyVerifier, n2, 0, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ConnectionInfo connect(ServerHostKeyVerifier serverHostKeyVerifier, int n2, int n3, int n4) {
        if (this.tm != null) {
            throw new IOException("Connection to " + this.hostname + " is already in connected state!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("connectTimeout must be non-negative!");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("kexTimeout must be non-negative!");
        }
        Connection$1TimeoutState connection$1TimeoutState = new Connection$1TimeoutState(this);
        this.tm = new TransportManager(this.hostname, this.port);
        this.tm.setConnectionMonitors(this.connectionMonitors);
        Object object = this.tm;
        synchronized (object) {
        }
        try {
            Object object2;
            object = null;
            if (n4 > 0) {
                object2 = new Connection$1(this, connection$1TimeoutState);
                long l2 = System.currentTimeMillis() + (long)n4;
                object = TimeoutService.addTimeoutHandler(l2, (Runnable)object2);
            }
            try {
                this.tm.initialize(this.cryptoWishList, serverHostKeyVerifier, this.dhgexpara, n2, n3, this.getOrCreateSecureRND(), this.proxyData);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw (SocketTimeoutException)new SocketTimeoutException("The connect() operation on the socket timed out.").initCause(socketTimeoutException);
            }
            this.tm.setTcpNoDelay(this.tcpNoDelay);
            object2 = this.tm.getConnectionInfo(1);
            if (object != null) {
                TimeoutService.cancelTimeoutHandler((TimeoutService$TimeoutToken)object);
                Connection$1TimeoutState connection$1TimeoutState2 = connection$1TimeoutState;
                synchronized (connection$1TimeoutState2) {
                    if (connection$1TimeoutState.timeoutSocketClosed) {
                        throw new IOException("This exception will be replaced by the one below =)");
                    }
                    connection$1TimeoutState.isCancelled = true;
                }
            }
            return object2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw socketTimeoutException;
        }
        catch (IOException iOException) {
            this.close(new Throwable("There was a problem during connect."), false);
            Connection$1TimeoutState connection$1TimeoutState3 = connection$1TimeoutState;
            synchronized (connection$1TimeoutState3) {
                if (connection$1TimeoutState.timeoutSocketClosed) {
                    throw new SocketTimeoutException("The kexTimeout (" + n4 + " ms) expired.");
                }
            }
            if (iOException instanceof HTTPProxyException) {
                throw iOException;
            }
            throw (IOException)new IOException("There was a problem while connecting to " + this.hostname + ":" + this.port).initCause(iOException);
        }
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(int n2, String string, int n3) {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, n2, string, n3);
    }

    public synchronized LocalPortForwarder createLocalPortForwarder(InetSocketAddress inetSocketAddress, String string, int n2) {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward ports, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward ports, connection is not authenticated.");
        }
        return new LocalPortForwarder(this.cm, inetSocketAddress, string, n2);
    }

    public synchronized LocalStreamForwarder createLocalStreamForwarder(String string, int n2) {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot forward, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot forward, connection is not authenticated.");
        }
        return new LocalStreamForwarder(this.cm, string, n2);
    }

    public synchronized SCPClient createSCPClient() {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot create SCP client, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot create SCP client, connection is not authenticated.");
        }
        return new SCPClient(this);
    }

    public synchronized void forceKeyExchange() {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        this.tm.forceKeyExchange(this.cryptoWishList, this.dhgexpara);
    }

    public synchronized String getHostname() {
        return this.hostname;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized ConnectionInfo getConnectionInfo() {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot get details of connection, you need to establish a connection first.");
        }
        return this.tm.getConnectionInfo(1);
    }

    public synchronized ClientServerHello getVersionInfo() {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot get details of connection, you need to establish a connection first.");
        }
        return this.tm.getVersionInfo();
    }

    public synchronized String[] getRemainingAuthMethods(String string) {
        if (string == null) {
            throw new IllegalArgumentException("user argument may not be NULL!");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Connection is not established!");
        }
        if (this.authenticated) {
            throw new IllegalStateException("Connection is already authenticated!");
        }
        if (this.am == null) {
            this.am = new AuthenticationManager(this.tm);
        }
        if (this.cm == null) {
            this.cm = new ChannelManager(this.tm);
        }
        return this.am.getRemainingMethods(string);
    }

    public synchronized boolean isAuthenticationComplete() {
        return this.authenticated;
    }

    public synchronized boolean isAuthenticationPartialSuccess() {
        if (this.am == null) {
            return false;
        }
        return this.am.getPartialSuccess();
    }

    public synchronized boolean isAuthMethodAvailable(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("method argument may not be NULL!");
        }
        String[] stringArray = this.getRemainingAuthMethods(string);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].compareTo(string2) != 0) continue;
            return true;
        }
        return false;
    }

    private final SecureRandom getOrCreateSecureRND() {
        if (this.generator == null) {
            this.generator = new SecureRandom();
        }
        return this.generator;
    }

    public synchronized Session openSession() {
        if (this.tm == null) {
            throw new IllegalStateException("Cannot open session, you need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Cannot open session, connection is not authenticated.");
        }
        return new Session(this.cm, this.getOrCreateSecureRND());
    }

    public synchronized void sendIgnorePacket() {
        SecureRandom secureRandom = this.getOrCreateSecureRND();
        byte[] byArray = new byte[secureRandom.nextInt(16)];
        secureRandom.nextBytes(byArray);
        this.sendIgnorePacket(byArray);
    }

    public synchronized void sendIgnorePacket(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data argument must not be null.");
        }
        if (this.tm == null) {
            throw new IllegalStateException("Cannot send SSH_MSG_IGNORE packet, you need to establish a connection first.");
        }
        PacketIgnore packetIgnore = new PacketIgnore();
        packetIgnore.setData(byArray);
        this.tm.sendMessage(packetIgnore.getPayload());
    }

    private String[] removeDuplicates(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            boolean bl2 = false;
            String string = stringArray[i2];
            for (int i3 = 0; i3 < n2; ++i3) {
                if ((string != null || stringArray2[i3] != null) && (string == null || !string.equals(stringArray2[i3]))) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            stringArray2[n2++] = stringArray[i2];
        }
        if (n2 == stringArray2.length) {
            return stringArray2;
        }
        String[] stringArray3 = new String[n2];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n2);
        return stringArray3;
    }

    public synchronized void setClient2ServerCiphers(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        BlockCipherFactory.checkCipherList(stringArray);
        this.cryptoWishList.c2s_enc_algos = stringArray;
    }

    public synchronized void setClient2ServerMACs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        MAC.checkMacList(stringArray);
        this.cryptoWishList.c2s_mac_algos = stringArray;
    }

    public synchronized void setDHGexParameters(DHGexParameters dHGexParameters) {
        if (dHGexParameters == null) {
            throw new IllegalArgumentException();
        }
        this.dhgexpara = dHGexParameters;
    }

    public synchronized void setServer2ClientCiphers(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        BlockCipherFactory.checkCipherList(stringArray);
        this.cryptoWishList.s2c_enc_algos = stringArray;
    }

    public synchronized void setServer2ClientMACs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        MAC.checkMacList(stringArray);
        this.cryptoWishList.s2c_mac_algos = stringArray;
    }

    public synchronized void setServerHostKeyAlgorithms(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        stringArray = this.removeDuplicates(stringArray);
        KexManager.checkServerHostkeyAlgorithmsList(stringArray);
        this.cryptoWishList.serverHostKeyAlgorithms = stringArray;
    }

    public synchronized void setTCPNoDelay(boolean bl2) {
        this.tcpNoDelay = bl2;
        if (this.tm != null) {
            this.tm.setTcpNoDelay(bl2);
        }
    }

    public synchronized void setProxyData(ProxyData proxyData) {
        this.proxyData = proxyData;
    }

    public synchronized void requestRemotePortForwarding(String string, int n2, String string2, int n3) {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        if (string == null || string2 == null || n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        this.cm.requestGlobalForward(string, n2, string2, n3);
    }

    public synchronized void cancelRemotePortForwarding(int n2) {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        this.cm.requestCancelGlobalForward(n2);
    }

    public synchronized void setSecureRandom(SecureRandom secureRandom) {
        if (secureRandom == null) {
            throw new IllegalArgumentException();
        }
        this.generator = secureRandom;
    }

    public synchronized void enableDebugging(boolean bl2, DebugLogger debugLogger) {
        Logger.enabled = bl2;
        if (!bl2) {
            Logger.logger = null;
        } else if (debugLogger == null) {
            debugLogger = new Connection$2(this);
        }
    }

    public synchronized void ping() {
        if (this.tm == null) {
            throw new IllegalStateException("You need to establish a connection first.");
        }
        if (!this.authenticated) {
            throw new IllegalStateException("The connection is not authenticated.");
        }
        this.cm.requestGlobalTrileadPing();
    }

    static /* synthetic */ TransportManager access$000(Connection connection) {
        return connection.tm;
    }
}

