/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.Structure$FieldOrder;
import com.sun.jna.platform.win32.BaseTSD$SIZE_T;
import com.sun.jna.platform.win32.Guid$GUID;
import com.sun.jna.platform.win32.WinBase$FILETIME;
import com.sun.jna.platform.win32.WinBase$SYSTEMTIME;
import com.sun.jna.platform.win32.WinDef$BOOL;
import com.sun.jna.platform.win32.WinNT$HANDLE;
import com.sun.jna.platform.win32.WinNT$PSID;
import com.sun.jna.platform.win32.Winevt;
import com.sun.jna.platform.win32.Winevt$EVT_VARIANT$field1_union;
import com.sun.jna.platform.win32.Winevt$EVT_VARIANT_TYPE;
import com.sun.jna.win32.W32APITypeMapper;

@Structure$FieldOrder(value={"field1", "Count", "Type"})
public class Winevt$EVT_VARIANT
extends Structure {
    public Winevt$EVT_VARIANT$field1_union field1;
    public int Count;
    public int Type;
    private Object holder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Winevt$EVT_VARIANT() {
        super(W32APITypeMapper.DEFAULT);
    }

    public Winevt$EVT_VARIANT(Pointer pointer) {
        super(pointer, 0, W32APITypeMapper.DEFAULT);
    }

    public void use(Pointer pointer) {
        this.useMemory(pointer, 0);
    }

    private int getBaseType() {
        return this.Type & 0x7F;
    }

    public boolean isArray() {
        return (this.Type & 0x80) == 128;
    }

    public Winevt$EVT_VARIANT_TYPE getVariantType() {
        return Winevt$EVT_VARIANT_TYPE.values()[this.getBaseType()];
    }

    public void setValue(Winevt$EVT_VARIANT_TYPE winevt$EVT_VARIANT_TYPE, Object object) {
        this.allocateMemory();
        if (winevt$EVT_VARIANT_TYPE == null) {
            throw new IllegalArgumentException("setValue must not be called with type set to NULL");
        }
        this.holder = null;
        if (object == null || winevt$EVT_VARIANT_TYPE == Winevt$EVT_VARIANT_TYPE.EvtVarTypeNull) {
            this.Type = Winevt$EVT_VARIANT_TYPE.EvtVarTypeNull.ordinal();
            this.Count = 0;
            this.field1.writeField("pointerValue", Pointer.NULL);
        } else {
            switch (winevt$EVT_VARIANT_TYPE) {
                case EvtVarTypeAnsiString: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == String.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        StringArray stringArray = new StringArray((String[])object, false);
                        this.holder = stringArray;
                        this.Count = ((String[])object).length;
                        this.field1.writeField("pointerValue", stringArray);
                        break;
                    }
                    if (object.getClass() == String.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        Memory memory = new Memory(((String)object).length() + 1);
                        memory.setString(0L, (String)object);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from String/String[]");
                }
                case EvtVarTypeBoolean: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == WinDef$BOOL.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        Memory memory = new Memory(((WinDef$BOOL[])object).length * 4);
                        for (int i2 = 0; i2 < ((WinDef$BOOL[])object).length; ++i2) {
                            memory.setInt(i2 * 4, ((WinDef$BOOL[])object)[i2].intValue());
                        }
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    if (object.getClass() == WinDef$BOOL.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("intValue", ((WinDef$BOOL)object).intValue());
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from BOOL/BOOL[]");
                }
                case EvtVarTypeString: 
                case EvtVarTypeEvtXml: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == String.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        StringArray stringArray = new StringArray((String[])object, true);
                        this.holder = stringArray;
                        this.Count = ((String[])object).length;
                        this.field1.writeField("pointerValue", stringArray);
                        break;
                    }
                    if (object.getClass() == String.class) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        Memory memory = new Memory((((String)object).length() + 1) * 2);
                        memory.setWideString(0L, (String)object);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from String/String[]");
                }
                case EvtVarTypeSByte: 
                case EvtVarTypeByte: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Byte.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        Memory memory = new Memory(((byte[])object).length * 1);
                        memory.write(0L, (byte[])object, 0, ((byte[])object).length);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    if (object.getClass() == Byte.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("byteValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from byte/byte[]");
                }
                case EvtVarTypeInt16: 
                case EvtVarTypeUInt16: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Short.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        Memory memory = new Memory(((short[])object).length * 2);
                        memory.write(0L, (short[])object, 0, ((short[])object).length);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    if (object.getClass() == Short.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("shortValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from short/short[]");
                }
                case EvtVarTypeHexInt32: 
                case EvtVarTypeInt32: 
                case EvtVarTypeUInt32: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Integer.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        Memory memory = new Memory(((int[])object).length * 4);
                        memory.write(0L, (int[])object, 0, ((int[])object).length);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    if (object.getClass() == Integer.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("intValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from int/int[]");
                }
                case EvtVarTypeHexInt64: 
                case EvtVarTypeInt64: 
                case EvtVarTypeUInt64: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Long.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        Memory memory = new Memory(((long[])object).length * 4);
                        memory.write(0L, (long[])object, 0, ((long[])object).length);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    if (object.getClass() == Long.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("longValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from long/long[]");
                }
                case EvtVarTypeSingle: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Float.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        Memory memory = new Memory(((float[])object).length * 4);
                        memory.write(0L, (float[])object, 0, ((float[])object).length);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    if (object.getClass() == Float.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("floatValue", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from float/float[]");
                }
                case EvtVarTypeDouble: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Double.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal() | 0x80;
                        Memory memory = new Memory(((double[])object).length * 4);
                        memory.write(0L, (double[])object, 0, ((double[])object).length);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    if (object.getClass() == Double.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        this.Count = 0;
                        this.field1.writeField("doubleVal", object);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from double/double[]");
                }
                case EvtVarTypeBinary: {
                    if (object.getClass().isArray() && object.getClass().getComponentType() == Byte.TYPE) {
                        this.Type = winevt$EVT_VARIANT_TYPE.ordinal();
                        Memory memory = new Memory(((byte[])object).length * 1);
                        memory.write(0L, (byte[])object, 0, ((byte[])object).length);
                        this.holder = memory;
                        this.Count = 0;
                        this.field1.writeField("pointerValue", memory);
                        break;
                    }
                    throw new IllegalArgumentException(winevt$EVT_VARIANT_TYPE.name() + " must be set from byte[]");
                }
                default: {
                    throw new IllegalStateException(String.format("NOT IMPLEMENTED: getValue(%s) (Array: %b, Count: %d)", new Object[]{winevt$EVT_VARIANT_TYPE, this.isArray(), this.Count}));
                }
            }
        }
        this.write();
    }

    public Object getValue() {
        Winevt$EVT_VARIANT_TYPE winevt$EVT_VARIANT_TYPE = this.getVariantType();
        switch (winevt$EVT_VARIANT_TYPE) {
            case EvtVarTypeAnsiString: {
                return this.isArray() ? this.field1.getPointer().getPointer(0L).getStringArray(0L, this.Count) : this.field1.getPointer().getPointer(0L).getString(0L);
            }
            case EvtVarTypeBoolean: {
                if (this.isArray()) {
                    int[] nArray = this.field1.getPointer().getPointer(0L).getIntArray(0L, this.Count);
                    WinDef$BOOL[] winDef$BOOLArray = new WinDef$BOOL[nArray.length];
                    for (int i2 = 0; i2 < winDef$BOOLArray.length; ++i2) {
                        winDef$BOOLArray[i2] = new WinDef$BOOL((long)nArray[i2]);
                    }
                    return winDef$BOOLArray;
                }
                return new WinDef$BOOL((long)this.field1.getPointer().getInt(0L));
            }
            case EvtVarTypeString: 
            case EvtVarTypeEvtXml: {
                return this.isArray() ? this.field1.getPointer().getPointer(0L).getWideStringArray(0L, this.Count) : this.field1.getPointer().getPointer(0L).getWideString(0L);
            }
            case EvtVarTypeFileTime: {
                if (this.isArray()) {
                    WinBase$FILETIME winBase$FILETIME = (WinBase$FILETIME)Structure.newInstance(WinBase$FILETIME.class, this.field1.getPointer().getPointer(0L));
                    winBase$FILETIME.read();
                    return winBase$FILETIME.toArray(this.Count);
                }
                WinBase$FILETIME winBase$FILETIME = new WinBase$FILETIME(this.field1.getPointer());
                winBase$FILETIME.read();
                return winBase$FILETIME;
            }
            case EvtVarTypeSysTime: {
                if (this.isArray()) {
                    WinBase$SYSTEMTIME winBase$SYSTEMTIME = (WinBase$SYSTEMTIME)Structure.newInstance(WinBase$SYSTEMTIME.class, this.field1.getPointer().getPointer(0L));
                    winBase$SYSTEMTIME.read();
                    return winBase$SYSTEMTIME.toArray(this.Count);
                }
                WinBase$SYSTEMTIME winBase$SYSTEMTIME = (WinBase$SYSTEMTIME)Structure.newInstance(WinBase$SYSTEMTIME.class, this.field1.getPointer().getPointer(0L));
                winBase$SYSTEMTIME.read();
                return winBase$SYSTEMTIME;
            }
            case EvtVarTypeSByte: 
            case EvtVarTypeByte: {
                return this.isArray() ? (Object)this.field1.getPointer().getPointer(0L).getByteArray(0L, this.Count) : Byte.valueOf(this.field1.getPointer().getByte(0L));
            }
            case EvtVarTypeInt16: 
            case EvtVarTypeUInt16: {
                return this.isArray() ? (Object)this.field1.getPointer().getPointer(0L).getShortArray(0L, this.Count) : Short.valueOf(this.field1.getPointer().getShort(0L));
            }
            case EvtVarTypeHexInt32: 
            case EvtVarTypeInt32: 
            case EvtVarTypeUInt32: {
                return this.isArray() ? (Object)this.field1.getPointer().getPointer(0L).getIntArray(0L, this.Count) : Integer.valueOf(this.field1.getPointer().getInt(0L));
            }
            case EvtVarTypeHexInt64: 
            case EvtVarTypeInt64: 
            case EvtVarTypeUInt64: {
                return this.isArray() ? (Object)this.field1.getPointer().getPointer(0L).getLongArray(0L, this.Count) : Long.valueOf(this.field1.getPointer().getLong(0L));
            }
            case EvtVarTypeSingle: {
                return this.isArray() ? (Object)this.field1.getPointer().getPointer(0L).getFloatArray(0L, this.Count) : Float.valueOf(this.field1.getPointer().getFloat(0L));
            }
            case EvtVarTypeDouble: {
                return this.isArray() ? (Object)this.field1.getPointer().getPointer(0L).getDoubleArray(0L, this.Count) : Double.valueOf(this.field1.getPointer().getDouble(0L));
            }
            case EvtVarTypeBinary: {
                if (!$assertionsDisabled && this.isArray()) {
                    throw new AssertionError();
                }
                return this.field1.getPointer().getPointer(0L).getByteArray(0L, this.Count);
            }
            case EvtVarTypeNull: {
                return null;
            }
            case EvtVarTypeGuid: {
                if (this.isArray()) {
                    Guid$GUID guid$GUID = (Guid$GUID)Structure.newInstance(Guid$GUID.class, this.field1.getPointer().getPointer(0L));
                    guid$GUID.read();
                    return guid$GUID.toArray(this.Count);
                }
                Guid$GUID guid$GUID = (Guid$GUID)Structure.newInstance(Guid$GUID.class, this.field1.getPointer().getPointer(0L));
                guid$GUID.read();
                return guid$GUID;
            }
            case EvtVarTypeSid: {
                if (this.isArray()) {
                    WinNT$PSID winNT$PSID = (WinNT$PSID)Structure.newInstance(WinNT$PSID.class, this.field1.getPointer().getPointer(0L));
                    winNT$PSID.read();
                    return winNT$PSID.toArray(this.Count);
                }
                WinNT$PSID winNT$PSID = (WinNT$PSID)Structure.newInstance(WinNT$PSID.class, this.field1.getPointer().getPointer(0L));
                winNT$PSID.read();
                return winNT$PSID;
            }
            case EvtVarTypeSizeT: {
                if (this.isArray()) {
                    long[] lArray = this.field1.getPointer().getPointer(0L).getLongArray(0L, this.Count);
                    BaseTSD$SIZE_T[] baseTSD$SIZE_TArray = new BaseTSD$SIZE_T[lArray.length];
                    for (int i3 = 0; i3 < baseTSD$SIZE_TArray.length; ++i3) {
                        baseTSD$SIZE_TArray[i3] = new BaseTSD$SIZE_T(lArray[i3]);
                    }
                    return baseTSD$SIZE_TArray;
                }
                return new BaseTSD$SIZE_T(this.field1.getPointer().getLong(0L));
            }
            case EvtVarTypeEvtHandle: {
                if (this.isArray()) {
                    Pointer[] pointerArray = this.field1.getPointer().getPointer(0L).getPointerArray(0L, this.Count);
                    WinNT$HANDLE[] winNT$HANDLEArray = new WinNT$HANDLE[pointerArray.length];
                    for (int i4 = 0; i4 < winNT$HANDLEArray.length; ++i4) {
                        winNT$HANDLEArray[i4] = new WinNT$HANDLE(pointerArray[i4]);
                    }
                    return winNT$HANDLEArray;
                }
                return new WinNT$HANDLE(this.field1.getPointer().getPointer(0L));
            }
        }
        throw new IllegalStateException(String.format("NOT IMPLEMENTED: getValue(%s) (Array: %b, Count: %d)", new Object[]{winevt$EVT_VARIANT_TYPE, this.isArray(), this.Count}));
    }

    static {
        $assertionsDisabled = !Winevt.class.desiredAssertionStatus();
    }
}

