/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure$FieldOrder;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.OaIdl$CURRENCY;
import com.sun.jna.platform.win32.OaIdl$DATE;
import com.sun.jna.platform.win32.OaIdl$DECIMAL;
import com.sun.jna.platform.win32.OaIdl$SAFEARRAY$ByReference;
import com.sun.jna.platform.win32.OaIdl$SAFEARRAYBOUND;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant$VARIANT;
import com.sun.jna.platform.win32.WTypes$BSTR;
import com.sun.jna.platform.win32.WTypes$VARTYPE;
import com.sun.jna.platform.win32.WTypes$VARTYPEByReference;
import com.sun.jna.platform.win32.WinDef$LONG;
import com.sun.jna.platform.win32.WinDef$LONGByReference;
import com.sun.jna.platform.win32.WinDef$PVOID;
import com.sun.jna.platform.win32.WinDef$SCODE;
import com.sun.jna.platform.win32.WinDef$UINT;
import com.sun.jna.platform.win32.WinDef$ULONG;
import com.sun.jna.platform.win32.WinDef$USHORT;
import com.sun.jna.platform.win32.WinNT$HRESULT;
import com.sun.jna.ptr.PointerByReference;
import java.io.Closeable;

@Structure$FieldOrder(value={"cDims", "fFeatures", "cbElements", "cLocks", "pvData", "rgsabound"})
public class OaIdl$SAFEARRAY
extends Structure
implements Closeable {
    public WinDef$USHORT cDims;
    public WinDef$USHORT fFeatures;
    public WinDef$ULONG cbElements;
    public WinDef$ULONG cLocks;
    public WinDef$PVOID pvData;
    public OaIdl$SAFEARRAYBOUND[] rgsabound = new OaIdl$SAFEARRAYBOUND[]{new OaIdl$SAFEARRAYBOUND()};

    public OaIdl$SAFEARRAY() {
    }

    public OaIdl$SAFEARRAY(Pointer pointer) {
        super(pointer);
        this.read();
    }

    @Override
    public void read() {
        super.read();
        this.rgsabound = this.cDims.intValue() > 0 ? (OaIdl$SAFEARRAYBOUND[])this.rgsabound[0].toArray(this.cDims.intValue()) : new OaIdl$SAFEARRAYBOUND[]{new OaIdl$SAFEARRAYBOUND()};
    }

    public static OaIdl$SAFEARRAY$ByReference createSafeArray(int ... nArray) {
        return OaIdl$SAFEARRAY.createSafeArray(new WTypes$VARTYPE(12), nArray);
    }

    public static OaIdl$SAFEARRAY$ByReference createSafeArray(WTypes$VARTYPE wTypes$VARTYPE, int ... nArray) {
        OaIdl$SAFEARRAYBOUND[] oaIdl$SAFEARRAYBOUNDArray = (OaIdl$SAFEARRAYBOUND[])new OaIdl$SAFEARRAYBOUND().toArray(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            oaIdl$SAFEARRAYBOUNDArray[i2].lLbound = new WinDef$LONG(0L);
            oaIdl$SAFEARRAYBOUNDArray[i2].cElements = new WinDef$ULONG((long)nArray[nArray.length - i2 - 1]);
        }
        OaIdl$SAFEARRAY$ByReference oaIdl$SAFEARRAY$ByReference = OleAuto.INSTANCE.SafeArrayCreate(wTypes$VARTYPE, new WinDef$UINT((long)nArray.length), oaIdl$SAFEARRAYBOUNDArray);
        return oaIdl$SAFEARRAY$ByReference;
    }

    public void putElement(Object object, int ... nArray) {
        WinDef$LONG[] winDef$LONGArray = new WinDef$LONG[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            winDef$LONGArray[i2] = new WinDef$LONG((long)nArray[nArray.length - i2 - 1]);
        }
        switch (this.getVarType().intValue()) {
            case 11: {
                Memory memory = new Memory(2L);
                if (object instanceof Boolean) {
                    memory.setShort(0L, (short)((Boolean)object != false ? 65535 : 0));
                } else {
                    memory.setShort(0L, (short)(((Number)object).intValue() > 0 ? 65535 : 0));
                }
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 16: 
            case 17: {
                Memory memory = new Memory(1L);
                memory.setByte(0L, ((Number)object).byteValue());
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 2: 
            case 18: {
                Memory memory = new Memory(2L);
                memory.setShort(0L, ((Number)object).shortValue());
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 3: 
            case 19: 
            case 22: 
            case 23: {
                Memory memory = new Memory(4L);
                memory.setInt(0L, ((Number)object).intValue());
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 10: {
                Memory memory = new Memory(4L);
                memory.setInt(0L, ((Number)object).intValue());
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 4: {
                Memory memory = new Memory(4L);
                memory.setFloat(0L, ((Number)object).floatValue());
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 5: {
                Memory memory = new Memory(8L);
                memory.setDouble(0L, ((Number)object).doubleValue());
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 7: {
                Memory memory = new Memory(8L);
                memory.setDouble(0L, ((OaIdl$DATE)object).date);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 8: {
                if (object instanceof String) {
                    WTypes$BSTR wTypes$BSTR = OleAuto.INSTANCE.SysAllocString((String)object);
                    WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, wTypes$BSTR.getPointer());
                    OleAuto.INSTANCE.SysFreeString(wTypes$BSTR);
                    COMUtils.checkRC(winNT$HRESULT);
                    break;
                }
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, ((WTypes$BSTR)object).getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 12: {
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, ((Variant$VARIANT)object).getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 13: {
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, ((Unknown)object).getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 9: {
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, ((Dispatch)object).getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 6: {
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, ((OaIdl$CURRENCY)object).getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            case 14: {
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPutElement(this, winDef$LONGArray, ((OaIdl$DECIMAL)object).getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                break;
            }
            default: {
                throw new IllegalStateException("Can't parse array content - type not supported: " + this.getVarType().intValue());
            }
        }
    }

    public Object getElement(int ... nArray) {
        Object object;
        WinDef$LONG[] winDef$LONGArray = new WinDef$LONG[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            winDef$LONGArray[i2] = new WinDef$LONG((long)nArray[nArray.length - i2 - 1]);
        }
        switch (this.getVarType().intValue()) {
            case 11: {
                Memory memory = new Memory(2L);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                object = memory.getShort(0L) != 0;
                break;
            }
            case 16: 
            case 17: {
                Memory memory = new Memory(1L);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                object = memory.getByte(0L);
                break;
            }
            case 2: 
            case 18: {
                Memory memory = new Memory(2L);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                object = memory.getShort(0L);
                break;
            }
            case 3: 
            case 19: 
            case 22: 
            case 23: {
                Memory memory = new Memory(4L);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                object = memory.getInt(0L);
                break;
            }
            case 10: {
                Memory memory = new Memory(4L);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                object = new WinDef$SCODE((long)memory.getInt(0L));
                break;
            }
            case 4: {
                Memory memory = new Memory(4L);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                object = Float.valueOf(memory.getFloat(0L));
                break;
            }
            case 5: {
                Memory memory = new Memory(8L);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                object = memory.getDouble(0L);
                break;
            }
            case 7: {
                Memory memory = new Memory(8L);
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, memory);
                COMUtils.checkRC(winNT$HRESULT);
                object = new OaIdl$DATE(memory.getDouble(0L));
                break;
            }
            case 8: {
                PointerByReference pointerByReference = new PointerByReference();
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, pointerByReference.getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                WTypes$BSTR wTypes$BSTR = new WTypes$BSTR(pointerByReference.getValue());
                object = wTypes$BSTR.getValue();
                OleAuto.INSTANCE.SysFreeString(wTypes$BSTR);
                break;
            }
            case 12: {
                Variant$VARIANT variant$VARIANT = new Variant$VARIANT();
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, variant$VARIANT.getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                object = variant$VARIANT;
                break;
            }
            case 13: {
                PointerByReference pointerByReference = new PointerByReference();
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, pointerByReference.getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                object = new Unknown(pointerByReference.getValue());
                break;
            }
            case 9: {
                PointerByReference pointerByReference = new PointerByReference();
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, pointerByReference.getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                object = new Dispatch(pointerByReference.getValue());
                break;
            }
            case 6: {
                OaIdl$CURRENCY oaIdl$CURRENCY = new OaIdl$CURRENCY();
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, oaIdl$CURRENCY.getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                object = oaIdl$CURRENCY;
                break;
            }
            case 14: {
                OaIdl$DECIMAL oaIdl$DECIMAL = new OaIdl$DECIMAL();
                WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetElement(this, winDef$LONGArray, oaIdl$DECIMAL.getPointer());
                COMUtils.checkRC(winNT$HRESULT);
                object = oaIdl$DECIMAL;
                break;
            }
            default: {
                throw new IllegalStateException("Can't parse array content - type not supported: " + this.getVarType().intValue());
            }
        }
        return object;
    }

    public Pointer ptrOfIndex(int ... nArray) {
        WinDef$LONG[] winDef$LONGArray = new WinDef$LONG[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            winDef$LONGArray[i2] = new WinDef$LONG((long)nArray[nArray.length - i2 - 1]);
        }
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayPtrOfIndex(this, winDef$LONGArray, pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return pointerByReference.getValue();
    }

    public void destroy() {
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayDestroy(this);
        COMUtils.checkRC(winNT$HRESULT);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public int getLBound(int n2) {
        int n3 = this.getDimensionCount() - n2;
        WinDef$LONGByReference winDef$LONGByReference = new WinDef$LONGByReference();
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetLBound(this, new WinDef$UINT((long)n3), winDef$LONGByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return winDef$LONGByReference.getValue().intValue();
    }

    public int getUBound(int n2) {
        int n3 = this.getDimensionCount() - n2;
        WinDef$LONGByReference winDef$LONGByReference = new WinDef$LONGByReference();
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetUBound(this, new WinDef$UINT((long)n3), winDef$LONGByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return winDef$LONGByReference.getValue().intValue();
    }

    public int getDimensionCount() {
        return OleAuto.INSTANCE.SafeArrayGetDim(this).intValue();
    }

    public Pointer accessData() {
        PointerByReference pointerByReference = new PointerByReference();
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayAccessData(this, pointerByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return pointerByReference.getValue();
    }

    public void unaccessData() {
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayUnaccessData(this);
        COMUtils.checkRC(winNT$HRESULT);
    }

    public void lock() {
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayLock(this);
        COMUtils.checkRC(winNT$HRESULT);
    }

    public void unlock() {
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayUnlock(this);
        COMUtils.checkRC(winNT$HRESULT);
    }

    public void redim(int n2, int n3) {
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayRedim(this, new OaIdl$SAFEARRAYBOUND(n2, n3));
        COMUtils.checkRC(winNT$HRESULT);
    }

    public WTypes$VARTYPE getVarType() {
        WTypes$VARTYPEByReference wTypes$VARTYPEByReference = new WTypes$VARTYPEByReference();
        WinNT$HRESULT winNT$HRESULT = OleAuto.INSTANCE.SafeArrayGetVartype(this, wTypes$VARTYPEByReference);
        COMUtils.checkRC(winNT$HRESULT);
        return wTypes$VARTYPEByReference.getValue();
    }

    public long getElemsize() {
        return OleAuto.INSTANCE.SafeArrayGetElemsize(this).longValue();
    }
}

