/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Structure$FieldOrder;
import java.security.SecureRandom;
import java.util.Arrays;

@Structure$FieldOrder(value={"Data1", "Data2", "Data3", "Data4"})
public class Guid$GUID
extends Structure {
    public int Data1;
    public short Data2;
    public short Data3;
    public byte[] Data4 = new byte[8];

    public Guid$GUID() {
    }

    public Guid$GUID(Guid$GUID guid$GUID) {
        this.Data1 = guid$GUID.Data1;
        this.Data2 = guid$GUID.Data2;
        this.Data3 = guid$GUID.Data3;
        this.Data4 = guid$GUID.Data4;
        this.writeFieldsToMemory();
    }

    public Guid$GUID(String string) {
        this(Guid$GUID.fromString(string));
    }

    public Guid$GUID(byte[] byArray) {
        this(Guid$GUID.fromBinary(byArray));
    }

    public Guid$GUID(Pointer pointer) {
        super(pointer);
        this.read();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Guid$GUID guid$GUID = (Guid$GUID)object;
        return this.Data1 == guid$GUID.Data1 && this.Data2 == guid$GUID.Data2 && this.Data3 == guid$GUID.Data3 && Arrays.equals(this.Data4, guid$GUID.Data4);
    }

    @Override
    public int hashCode() {
        return this.Data1 + this.Data2 & 65535 + this.Data3 & 65535 + Arrays.hashCode(this.Data4);
    }

    public static Guid$GUID fromBinary(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Invalid data length: " + byArray.length);
        }
        Guid$GUID guid$GUID = new Guid$GUID();
        long l2 = byArray[0] & 0xFF;
        l2 <<= 8;
        l2 |= (long)(byArray[1] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[2] & 0xFF);
        l2 <<= 8;
        guid$GUID.Data1 = (int)(l2 |= (long)(byArray[3] & 0xFF));
        int n2 = byArray[4] & 0xFF;
        n2 <<= 8;
        guid$GUID.Data2 = (short)(n2 |= byArray[5] & 0xFF);
        int n3 = byArray[6] & 0xFF;
        n3 <<= 8;
        guid$GUID.Data3 = (short)(n3 |= byArray[7] & 0xFF);
        guid$GUID.Data4[0] = byArray[8];
        guid$GUID.Data4[1] = byArray[9];
        guid$GUID.Data4[2] = byArray[10];
        guid$GUID.Data4[3] = byArray[11];
        guid$GUID.Data4[4] = byArray[12];
        guid$GUID.Data4[5] = byArray[13];
        guid$GUID.Data4[6] = byArray[14];
        guid$GUID.Data4[7] = byArray[15];
        guid$GUID.writeFieldsToMemory();
        return guid$GUID;
    }

    public static Guid$GUID fromString(String string) {
        int n2;
        int n3 = 0;
        char[] cArray = new char[32];
        char[] cArray2 = string.toCharArray();
        byte[] byArray = new byte[16];
        Guid$GUID guid$GUID = new Guid$GUID();
        if (string.length() > 38) {
            throw new IllegalArgumentException("Invalid guid length: " + string.length());
        }
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            if (cArray2[n2] == '{' || cArray2[n2] == '-' || cArray2[n2] == '}') continue;
            cArray[n3++] = cArray2[n2];
        }
        for (n2 = 0; n2 < 32; n2 += 2) {
            byArray[n2 / 2] = (byte)((Character.digit(cArray[n2], 16) << 4) + Character.digit(cArray[n2 + 1], 16) & 0xFF);
        }
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Invalid data length: " + byArray.length);
        }
        long l2 = byArray[0] & 0xFF;
        l2 <<= 8;
        l2 |= (long)(byArray[1] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[2] & 0xFF);
        l2 <<= 8;
        guid$GUID.Data1 = (int)(l2 |= (long)(byArray[3] & 0xFF));
        int n4 = byArray[4] & 0xFF;
        n4 <<= 8;
        guid$GUID.Data2 = (short)(n4 |= byArray[5] & 0xFF);
        int n5 = byArray[6] & 0xFF;
        n5 <<= 8;
        guid$GUID.Data3 = (short)(n5 |= byArray[7] & 0xFF);
        guid$GUID.Data4[0] = byArray[8];
        guid$GUID.Data4[1] = byArray[9];
        guid$GUID.Data4[2] = byArray[10];
        guid$GUID.Data4[3] = byArray[11];
        guid$GUID.Data4[4] = byArray[12];
        guid$GUID.Data4[5] = byArray[13];
        guid$GUID.Data4[6] = byArray[14];
        guid$GUID.Data4[7] = byArray[15];
        guid$GUID.writeFieldsToMemory();
        return guid$GUID;
    }

    public static Guid$GUID newGuid() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        return new Guid$GUID(byArray);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[]{(byte)(this.Data1 >> 24), (byte)(this.Data1 >> 16), (byte)(this.Data1 >> 8), (byte)(this.Data1 >> 0)};
        byte[] byArray3 = new byte[]{(byte)(this.Data2 >> 24), (byte)(this.Data2 >> 16), (byte)(this.Data2 >> 8), (byte)(this.Data2 >> 0)};
        byte[] byArray4 = new byte[]{(byte)(this.Data3 >> 24), (byte)(this.Data3 >> 16), (byte)(this.Data3 >> 8), (byte)(this.Data3 >> 0)};
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        System.arraycopy(byArray3, 2, byArray, 4, 2);
        System.arraycopy(byArray4, 2, byArray, 6, 2);
        System.arraycopy(this.Data4, 0, byArray, 8, 8);
        return byArray;
    }

    public String toGuidString() {
        String string = "0123456789ABCDEF";
        byte[] byArray = this.toByteArray();
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        stringBuilder.append("{");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            char c2 = "0123456789ABCDEF".charAt((byArray[i2] & 0xF0) >> 4);
            char c3 = "0123456789ABCDEF".charAt(byArray[i2] & 0xF);
            stringBuilder.append(c2).append(c3);
            if (i2 != 3 && i2 != 5 && i2 != 7 && i2 != 9) continue;
            stringBuilder.append("-");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected void writeFieldsToMemory() {
        for (String string : this.getFieldOrder()) {
            this.writeField(string);
        }
    }
}

