/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util$EventLogType;
import com.sun.jna.platform.win32.WinNT$EVENTLOGRECORD;
import java.util.ArrayList;

public class Advapi32Util$EventLogRecord {
    private WinNT$EVENTLOGRECORD _record;
    private String _source;
    private byte[] _data;
    private String[] _strings;

    public WinNT$EVENTLOGRECORD getRecord() {
        return this._record;
    }

    public int getInstanceId() {
        return this._record.EventID.intValue();
    }

    @Deprecated
    public int getEventId() {
        return this._record.EventID.intValue();
    }

    public String getSource() {
        return this._source;
    }

    public int getStatusCode() {
        return this._record.EventID.intValue() & 0xFFFF;
    }

    public int getRecordNumber() {
        return this._record.RecordNumber.intValue();
    }

    public int getLength() {
        return this._record.Length.intValue();
    }

    public String[] getStrings() {
        return this._strings;
    }

    public Advapi32Util$EventLogType getType() {
        switch (this._record.EventType.intValue()) {
            case 0: 
            case 4: {
                return Advapi32Util$EventLogType.Informational;
            }
            case 16: {
                return Advapi32Util$EventLogType.AuditFailure;
            }
            case 8: {
                return Advapi32Util$EventLogType.AuditSuccess;
            }
            case 1: {
                return Advapi32Util$EventLogType.Error;
            }
            case 2: {
                return Advapi32Util$EventLogType.Warning;
            }
        }
        throw new RuntimeException("Invalid type: " + this._record.EventType.intValue());
    }

    public byte[] getData() {
        return this._data;
    }

    public Advapi32Util$EventLogRecord(Pointer pointer) {
        this._record = new WinNT$EVENTLOGRECORD(pointer);
        this._source = pointer.getWideString(this._record.size());
        if (this._record.DataLength.intValue() > 0) {
            this._data = pointer.getByteArray(this._record.DataOffset.intValue(), this._record.DataLength.intValue());
        }
        if (this._record.NumStrings.intValue() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            long l2 = this._record.StringOffset.intValue();
            for (int i2 = this._record.NumStrings.intValue(); i2 > 0; --i2) {
                String string = pointer.getWideString(l2);
                arrayList.add(string);
                l2 += (long)(string.length() * Native.WCHAR_SIZE);
                l2 += (long)Native.WCHAR_SIZE;
            }
            this._strings = arrayList.toArray(new String[0]);
        }
    }
}

