/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.RasterRangesUtils;
import com.sun.jna.platform.WindowUtils$1;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$1;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$2;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$3;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$4;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$5;
import com.sun.jna.platform.WindowUtils$X11WindowUtils$PixmapSource;
import com.sun.jna.platform.unix.X11;
import com.sun.jna.platform.unix.X11$Display;
import com.sun.jna.platform.unix.X11$GC;
import com.sun.jna.platform.unix.X11$Pixmap;
import com.sun.jna.platform.unix.X11$VisualID;
import com.sun.jna.platform.unix.X11$Window;
import com.sun.jna.platform.unix.X11$WindowByReference;
import com.sun.jna.platform.unix.X11$XRectangle;
import com.sun.jna.platform.unix.X11$XVisualInfo;
import com.sun.jna.platform.unix.X11$XWindowAttributes;
import com.sun.jna.platform.unix.X11$Xrender;
import com.sun.jna.platform.unix.X11$Xrender$XRenderPictFormat;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.Raster;
import java.util.ArrayList;
import javax.swing.RootPaneContainer;

class WindowUtils$X11WindowUtils
extends WindowUtils$NativeWindowUtils {
    private boolean didCheck;
    private long[] alphaVisualIDs = new long[0];
    private static final long OPAQUE = 0xFFFFFFFFL;
    private static final String OPACITY = "_NET_WM_WINDOW_OPACITY";

    private WindowUtils$X11WindowUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X11$Pixmap createBitmap(X11$Display x11$Display, X11$Window x11$Window, Raster raster) {
        X11 x11 = X11.INSTANCE;
        Rectangle rectangle = raster.getBounds();
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y + rectangle.height;
        X11$Pixmap x11$Pixmap = x11.XCreatePixmap(x11$Display, x11$Window, n2, n3, 1);
        X11$GC x11$GC = x11.XCreateGC(x11$Display, x11$Pixmap, new NativeLong(0L), null);
        if (x11$GC == null) {
            return null;
        }
        x11.XSetForeground(x11$Display, x11$GC, new NativeLong(0L));
        x11.XFillRectangle(x11$Display, x11$Pixmap, x11$GC, 0, 0, n2, n3);
        ArrayList arrayList = new ArrayList();
        try {
            int n4;
            RasterRangesUtils.outputOccupiedRanges(raster, new WindowUtils$X11WindowUtils$1(arrayList));
            X11$XRectangle[] x11$XRectangleArray = (X11$XRectangle[])new X11$XRectangle().toArray(arrayList.size());
            for (n4 = 0; n4 < x11$XRectangleArray.length; ++n4) {
                Rectangle rectangle2 = (Rectangle)arrayList.get(n4);
                x11$XRectangleArray[n4].x = (short)rectangle2.x;
                x11$XRectangleArray[n4].y = (short)rectangle2.y;
                x11$XRectangleArray[n4].width = (short)rectangle2.width;
                x11$XRectangleArray[n4].height = (short)rectangle2.height;
                Pointer pointer = x11$XRectangleArray[n4].getPointer();
                pointer.setShort(0L, (short)rectangle2.x);
                pointer.setShort(2L, (short)rectangle2.y);
                pointer.setShort(4L, (short)rectangle2.width);
                pointer.setShort(6L, (short)rectangle2.height);
                x11$XRectangleArray[n4].setAutoSynch(false);
            }
            n4 = 1;
            x11.XSetForeground(x11$Display, x11$GC, new NativeLong(1L));
            x11.XFillRectangles(x11$Display, x11$Pixmap, x11$GC, x11$XRectangleArray, x11$XRectangleArray.length);
        }
        finally {
            x11.XFreeGC(x11$Display, x11$GC);
        }
        return x11$Pixmap;
    }

    @Override
    public boolean isWindowAlphaSupported() {
        return this.getAlphaVisualIDs().length > 0;
    }

    private static long getVisualID(GraphicsConfiguration graphicsConfiguration) {
        try {
            Object object = graphicsConfiguration.getClass().getMethod("getVisual", null).invoke((Object)graphicsConfiguration, (Object[])null);
            return ((Number)object).longValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1L;
        }
    }

    @Override
    public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
        if (this.isWindowAlphaSupported()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
                GraphicsConfiguration[] graphicsConfigurationArray = graphicsDeviceArray[i2].getConfigurations();
                for (int i3 = 0; i3 < graphicsConfigurationArray.length; ++i3) {
                    long l2 = WindowUtils$X11WindowUtils.getVisualID(graphicsConfigurationArray[i3]);
                    long[] lArray = this.getAlphaVisualIDs();
                    for (int i4 = 0; i4 < lArray.length; ++i4) {
                        if (l2 != lArray[i4]) continue;
                        return graphicsConfigurationArray[i3];
                    }
                }
            }
        }
        return super.getAlphaCompatibleGraphicsConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long[] getAlphaVisualIDs() {
        if (this.didCheck) {
            return this.alphaVisualIDs;
        }
        this.didCheck = true;
        X11 x11 = X11.INSTANCE;
        X11$Display x11$Display = x11.XOpenDisplay(null);
        if (x11$Display == null) {
            return this.alphaVisualIDs;
        }
        Structure structure = null;
        try {
            int n2 = x11.XDefaultScreen(x11$Display);
            X11$XVisualInfo x11$XVisualInfo = new X11$XVisualInfo();
            x11$XVisualInfo.screen = n2;
            x11$XVisualInfo.depth = 32;
            x11$XVisualInfo.c_class = 4;
            NativeLong nativeLong = new NativeLong(14L);
            IntByReference intByReference = new IntByReference();
            structure = x11.XGetVisualInfo(x11$Display, nativeLong, x11$XVisualInfo, intByReference);
            if (structure != null) {
                int n3;
                ArrayList<X11$VisualID> arrayList = new ArrayList<X11$VisualID>();
                X11$XVisualInfo[] x11$XVisualInfoArray = (X11$XVisualInfo[])structure.toArray(intByReference.getValue());
                for (n3 = 0; n3 < x11$XVisualInfoArray.length; ++n3) {
                    X11$Xrender$XRenderPictFormat x11$Xrender$XRenderPictFormat = X11$Xrender.INSTANCE.XRenderFindVisualFormat(x11$Display, x11$XVisualInfoArray[n3].visual);
                    if (x11$Xrender$XRenderPictFormat.type != 1 || x11$Xrender$XRenderPictFormat.direct.alphaMask == 0) continue;
                    arrayList.add(x11$XVisualInfoArray[n3].visualid);
                }
                this.alphaVisualIDs = new long[arrayList.size()];
                for (n3 = 0; n3 < this.alphaVisualIDs.length; ++n3) {
                    this.alphaVisualIDs[n3] = ((Number)arrayList.get(n3)).longValue();
                }
                long[] lArray = this.alphaVisualIDs;
                return lArray;
            }
        }
        finally {
            if (structure != null) {
                x11.XFree(structure.getPointer());
            }
            x11.XCloseDisplay(x11$Display);
        }
        return this.alphaVisualIDs;
    }

    private static X11$Window getContentWindow(Window window, X11$Display x11$Display, X11$Window x11$Window, Point point) {
        if (window instanceof Frame && !((Frame)window).isUndecorated() || window instanceof Dialog && !((Dialog)window).isUndecorated()) {
            int[] nArray;
            X11 x11 = X11.INSTANCE;
            X11$WindowByReference x11$WindowByReference = new X11$WindowByReference();
            X11$WindowByReference x11$WindowByReference2 = new X11$WindowByReference();
            PointerByReference pointerByReference = new PointerByReference();
            IntByReference intByReference = new IntByReference();
            x11.XQueryTree(x11$Display, x11$Window, x11$WindowByReference, x11$WindowByReference2, pointerByReference, intByReference);
            Pointer pointer = pointerByReference.getValue();
            int[] nArray2 = nArray = pointer.getIntArray(0L, intByReference.getValue());
            int n2 = nArray2.length;
            int n3 = 0;
            if (n3 < n2) {
                int n4 = nArray2[n3];
                X11$Window x11$Window2 = new X11$Window((long)n4);
                X11$XWindowAttributes x11$XWindowAttributes = new X11$XWindowAttributes();
                x11.XGetWindowAttributes(x11$Display, x11$Window2, x11$XWindowAttributes);
                point.x = -x11$XWindowAttributes.x;
                point.y = -x11$XWindowAttributes.y;
                x11$Window = x11$Window2;
            }
            if (pointer != null) {
                x11.XFree(pointer);
            }
        }
        return x11$Window;
    }

    private static X11$Window getDrawable(Component component) {
        int n2 = (int)Native.getComponentID(component);
        if (n2 == 0) {
            return null;
        }
        return new X11$Window((long)n2);
    }

    @Override
    public void setWindowAlpha(Window window, float f2) {
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("This X11 display does not provide a 32-bit visual");
        }
        WindowUtils$X11WindowUtils$2 windowUtils$X11WindowUtils$2 = new WindowUtils$X11WindowUtils$2(this, window, f2);
        this.whenDisplayable(window, windowUtils$X11WindowUtils$2);
    }

    @Override
    public void setWindowTransparent(Window window, boolean bl2) {
        boolean bl3;
        if (!(window instanceof RootPaneContainer)) {
            throw new IllegalArgumentException("Window must be a RootPaneContainer");
        }
        if (!this.isWindowAlphaSupported()) {
            throw new UnsupportedOperationException("This X11 display does not provide a 32-bit visual");
        }
        if (!window.getGraphicsConfiguration().equals(this.getAlphaCompatibleGraphicsConfiguration())) {
            throw new IllegalArgumentException("Window GraphicsConfiguration '" + window.getGraphicsConfiguration() + "' does not support transparency");
        }
        boolean bl4 = bl3 = window.getBackground() != null && window.getBackground().getAlpha() == 0;
        if (bl2 == bl3) {
            return;
        }
        this.whenDisplayable(window, new WindowUtils$X11WindowUtils$3(this, window, bl2));
    }

    private void setWindowShape(Window window, WindowUtils$X11WindowUtils$PixmapSource windowUtils$X11WindowUtils$PixmapSource) {
        WindowUtils$X11WindowUtils$4 windowUtils$X11WindowUtils$4 = new WindowUtils$X11WindowUtils$4(this, window, windowUtils$X11WindowUtils$PixmapSource);
        this.whenDisplayable(window, windowUtils$X11WindowUtils$4);
    }

    @Override
    protected void setMask(Component component, Raster raster) {
        this.setWindowShape(this.getWindow(component), new WindowUtils$X11WindowUtils$5(this, raster));
    }

    /* synthetic */ WindowUtils$X11WindowUtils(WindowUtils$1 windowUtils$1) {
        this();
    }

    static /* synthetic */ X11$Window access$900(Component component) {
        return WindowUtils$X11WindowUtils.getDrawable(component);
    }

    static /* synthetic */ X11$Window access$1000(Window window, X11$Display x11$Display, X11$Window x11$Window, Point point) {
        return WindowUtils$X11WindowUtils.getContentWindow(window, x11$Display, x11$Window, point);
    }

    static /* synthetic */ X11$Pixmap access$1100(X11$Display x11$Display, X11$Window x11$Window, Raster raster) {
        return WindowUtils$X11WindowUtils.createBitmap(x11$Display, x11$Window, raster);
    }
}

