/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform;

import com.sun.jna.platform.RasterRangesUtils;
import com.sun.jna.platform.WindowUtils;
import com.sun.jna.platform.WindowUtils$HeavyweightForcer;
import com.sun.jna.platform.WindowUtils$Holder;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils$1;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils$2;
import com.sun.jna.platform.WindowUtils$NativeWindowUtils$3;
import com.sun.jna.platform.win32.WinDef$HICON;
import com.sun.jna.platform.win32.WinDef$HWND;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public abstract class WindowUtils$NativeWindowUtils {
    protected Window getWindow(Component component) {
        return component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
    }

    protected void whenDisplayable(Component component, Runnable runnable) {
        if (component.isDisplayable() && (!WindowUtils$Holder.requiresVisible || component.isVisible())) {
            runnable.run();
        } else if (WindowUtils$Holder.requiresVisible) {
            this.getWindow(component).addWindowListener(new WindowUtils$NativeWindowUtils$1(this, runnable));
        } else {
            component.addHierarchyListener(new WindowUtils$NativeWindowUtils$2(this, runnable));
        }
    }

    protected Raster toRaster(Shape shape) {
        WritableRaster writableRaster = null;
        if (shape != WindowUtils.MASK_NONE) {
            Rectangle rectangle = shape.getBounds();
            if (rectangle.width > 0 && rectangle.height > 0) {
                BufferedImage bufferedImage = new BufferedImage(rectangle.x + rectangle.width, rectangle.y + rectangle.height, 12);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(Color.black);
                graphics2D.fillRect(0, 0, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics2D.setColor(Color.white);
                graphics2D.fill(shape);
                writableRaster = bufferedImage.getRaster();
            }
        }
        return writableRaster;
    }

    protected Raster toRaster(Component component, Icon icon) {
        WritableRaster writableRaster = null;
        if (icon != null) {
            Rectangle rectangle = new Rectangle(0, 0, icon.getIconWidth(), icon.getIconHeight());
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            icon.paintIcon(component, graphics2D, 0, 0);
            writableRaster = bufferedImage.getAlphaRaster();
        }
        return writableRaster;
    }

    protected Shape toShape(Raster raster) {
        Area area = new Area(new Rectangle(0, 0, 0, 0));
        RasterRangesUtils.outputOccupiedRanges(raster, new WindowUtils$NativeWindowUtils$3(this, area));
        return area;
    }

    public void setWindowAlpha(Window window, float f2) {
    }

    public boolean isWindowAlphaSupported() {
        return false;
    }

    public GraphicsConfiguration getAlphaCompatibleGraphicsConfiguration() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return graphicsDevice.getDefaultConfiguration();
    }

    public void setWindowTransparent(Window window, boolean bl2) {
    }

    protected void setDoubleBuffered(Component component, boolean bl2) {
        if (component instanceof JComponent) {
            ((JComponent)component).setDoubleBuffered(bl2);
        }
        if (component instanceof JRootPane && bl2) {
            ((JRootPane)component).setDoubleBuffered(true);
        } else if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                this.setDoubleBuffered(componentArray[i2], bl2);
            }
        }
    }

    protected void setLayersTransparent(Window window, boolean bl2) {
        Color color;
        Color color2 = color = bl2 ? new Color(0, 0, 0, 0) : null;
        if (window instanceof RootPaneContainer) {
            JComponent jComponent;
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            JRootPane jRootPane = rootPaneContainer.getRootPane();
            JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
            Container container = jRootPane.getContentPane();
            JComponent jComponent2 = jComponent = container instanceof JComponent ? (JComponent)container : null;
            if (bl2) {
                jLayeredPane.putClientProperty("transparent-old-opaque", jLayeredPane.isOpaque());
                jLayeredPane.setOpaque(false);
                jRootPane.putClientProperty("transparent-old-opaque", jRootPane.isOpaque());
                jRootPane.setOpaque(false);
                if (jComponent != null) {
                    jComponent.putClientProperty("transparent-old-opaque", jComponent.isOpaque());
                    jComponent.setOpaque(false);
                }
                jRootPane.putClientProperty("transparent-old-bg", jRootPane.getParent().getBackground());
            } else {
                jLayeredPane.setOpaque(Boolean.TRUE.equals(jLayeredPane.getClientProperty("transparent-old-opaque")));
                jLayeredPane.putClientProperty("transparent-old-opaque", null);
                jRootPane.setOpaque(Boolean.TRUE.equals(jRootPane.getClientProperty("transparent-old-opaque")));
                jRootPane.putClientProperty("transparent-old-opaque", null);
                if (jComponent != null) {
                    jComponent.setOpaque(Boolean.TRUE.equals(jComponent.getClientProperty("transparent-old-opaque")));
                    jComponent.putClientProperty("transparent-old-opaque", null);
                }
                color = (Color)jRootPane.getClientProperty("transparent-old-bg");
                jRootPane.putClientProperty("transparent-old-bg", null);
            }
        }
        window.setBackground(color);
    }

    protected void setMask(Component component, Raster raster) {
        throw new UnsupportedOperationException("Window masking is not available");
    }

    protected void setWindowMask(Component component, Raster raster) {
        if (component.isLightweight()) {
            throw new IllegalArgumentException("Component must be heavyweight: " + component);
        }
        this.setMask(component, raster);
    }

    public void setWindowMask(Component component, Shape shape) {
        this.setWindowMask(component, this.toRaster(shape));
    }

    public void setWindowMask(Component component, Icon icon) {
        this.setWindowMask(component, this.toRaster(component, icon));
    }

    protected void setForceHeavyweightPopups(Window window, boolean bl2) {
        if (!(window instanceof WindowUtils$HeavyweightForcer)) {
            Window[] windowArray = window.getOwnedWindows();
            for (int i2 = 0; i2 < windowArray.length; ++i2) {
                if (!(windowArray[i2] instanceof WindowUtils$HeavyweightForcer)) continue;
                if (bl2) {
                    return;
                }
                windowArray[i2].dispose();
            }
            Boolean bl3 = Boolean.valueOf(System.getProperty("jna.force_hw_popups", "true"));
            if (bl2 && bl3.booleanValue()) {
                new WindowUtils$HeavyweightForcer(window);
            }
        }
    }

    protected BufferedImage getWindowIcon(WinDef$HWND winDef$HWND) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected Dimension getIconSize(WinDef$HICON winDef$HICON) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected List getAllWindows(boolean bl2) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected String getWindowTitle(WinDef$HWND winDef$HWND) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected String getProcessFilePath(WinDef$HWND winDef$HWND) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }

    protected Rectangle getWindowLocationAndSize(WinDef$HWND winDef$HWND) {
        throw new UnsupportedOperationException("This platform is not supported, yet.");
    }
}

