/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.connector;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Buffer;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.USocketFactory$Socket;
import java.io.IOException;

public class SSHAgentConnector
implements Connector {
    private USocketFactory factory;
    private String usocketPath;

    public SSHAgentConnector(USocketFactory uSocketFactory) {
        this(uSocketFactory, null);
    }

    public SSHAgentConnector(USocketFactory uSocketFactory, String string) {
        this.factory = uSocketFactory;
        this.usocketPath = string;
        USocketFactory$Socket uSocketFactory$Socket = null;
        try {
            uSocketFactory$Socket = this.open();
        }
        catch (IOException iOException) {
            throw new AgentProxyException(iOException.toString());
        }
        catch (Exception exception) {
            throw new AgentProxyException(exception.toString());
        }
        finally {
            try {
                if (uSocketFactory$Socket != null) {
                    uSocketFactory$Socket.close();
                }
            }
            catch (IOException iOException) {
                throw new AgentProxyException(iOException.toString());
            }
        }
    }

    public String getName() {
        return "ssh-agent";
    }

    public static boolean isConnectorAvailable() {
        return SSHAgentConnector.isConnectorAvailable(null);
    }

    public static boolean isConnectorAvailable(String string) {
        return System.getenv("SSH_AUTH_SOCK") != null || string != null;
    }

    public boolean isAvailable() {
        return SSHAgentConnector.isConnectorAvailable();
    }

    private USocketFactory$Socket open() {
        String string = this.usocketPath;
        if (string == null) {
            string = System.getenv("SSH_AUTH_SOCK");
        }
        if (string == null) {
            throw new IOException("SSH_AUTH_SOCK is not defined.");
        }
        return this.factory.open(string);
    }

    public void query(Buffer buffer) {
        USocketFactory$Socket uSocketFactory$Socket = null;
        try {
            uSocketFactory$Socket = this.open();
            uSocketFactory$Socket.write(buffer.buffer, 0, buffer.getLength());
            buffer.rewind();
            int n2 = uSocketFactory$Socket.readFull(buffer.buffer, 0, 4);
            n2 = buffer.getInt();
            buffer.rewind();
            buffer.checkFreeSize(n2);
            n2 = uSocketFactory$Socket.readFull(buffer.buffer, 0, n2);
        }
        catch (IOException iOException) {
            throw new AgentProxyException(iOException.toString());
        }
        finally {
            try {
                if (uSocketFactory$Socket != null) {
                    uSocketFactory$Socket.close();
                }
            }
            catch (IOException iOException) {
                throw new AgentProxyException(iOException.toString());
            }
        }
    }
}

