/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy.connector;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Buffer;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.connector.PageantConnector$COPYDATASTRUCT32;
import com.jcraft.jsch.agentproxy.connector.PageantConnector$COPYDATASTRUCT64;
import com.jcraft.jsch.agentproxy.connector.PageantConnector$User32;
import com.sun.jna.Memory;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinBase$SECURITY_ATTRIBUTES;
import com.sun.jna.platform.win32.WinDef$HWND;
import com.sun.jna.platform.win32.WinNT$HANDLE;

public class PageantConnector
implements Connector {
    private PageantConnector$User32 libU = null;
    private Kernel32 libK = null;

    public PageantConnector() {
        try {
            this.libU = PageantConnector$User32.INSTANCE;
            this.libK = Kernel32.INSTANCE;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new AgentProxyException(unsatisfiedLinkError.toString());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new AgentProxyException(noClassDefFoundError.toString());
        }
    }

    public String getName() {
        return "pageant";
    }

    public static boolean isConnectorAvailable() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public boolean isAvailable() {
        return PageantConnector.isConnectorAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(Buffer buffer) {
        WinNT$HANDLE winNT$HANDLE = null;
        Pointer pointer = null;
        WinDef$HWND winDef$HWND = this.libU.FindWindow("Pageant", "Pageant");
        if (winDef$HWND == null) {
            throw new AgentProxyException("Pageant is not runnning.");
        }
        String string = String.format("PageantRequest%08x", this.libK.GetCurrentThreadId());
        WinBase$SECURITY_ATTRIBUTES winBase$SECURITY_ATTRIBUTES = null;
        winNT$HANDLE = this.libK.CreateFileMapping(WinBase.INVALID_HANDLE_VALUE, winBase$SECURITY_ATTRIBUTES, 4, 0, 8192, string);
        pointer = Kernel32.INSTANCE.MapViewOfFile(winNT$HANDLE, 2, 0, 0, 0);
        byte[] byArray = null;
        long l2 = 0L;
        try {
            Structure structure;
            pointer.write(0L, buffer.buffer, 0, buffer.getLength());
            if (Platform.is64Bit()) {
                structure = new PageantConnector$COPYDATASTRUCT64(this);
                byArray = this.install64(string, (PageantConnector$COPYDATASTRUCT64)structure);
                l2 = this.sendMessage(winDef$HWND, byArray);
            } else {
                structure = new PageantConnector$COPYDATASTRUCT32(this);
                byArray = this.install32(string, (PageantConnector$COPYDATASTRUCT32)structure);
                l2 = this.sendMessage(winDef$HWND, byArray);
            }
            buffer.rewind();
            if (l2 != 0L) {
                pointer.read(0L, buffer.buffer, 0, 4);
                int n2 = buffer.getInt();
                buffer.rewind();
                buffer.checkFreeSize(n2);
                pointer.read(4L, buffer.buffer, 0, n2);
            }
        }
        finally {
            if (pointer != null) {
                this.libK.UnmapViewOfFile(pointer);
            }
            if (winNT$HANDLE != null) {
                this.libK.CloseHandle(winNT$HANDLE);
            }
        }
    }

    private byte[] install32(String string, PageantConnector$COPYDATASTRUCT32 pageantConnector$COPYDATASTRUCT32) {
        pageantConnector$COPYDATASTRUCT32.dwData = -2142351174;
        pageantConnector$COPYDATASTRUCT32.cbData = string.length() + 1;
        pageantConnector$COPYDATASTRUCT32.lpData = new Memory(string.length() + 1);
        byte[] byArray = string.getBytes();
        pageantConnector$COPYDATASTRUCT32.lpData.write(0L, byArray, 0, byArray.length);
        pageantConnector$COPYDATASTRUCT32.lpData.setByte(byArray.length, (byte)0);
        pageantConnector$COPYDATASTRUCT32.write();
        byArray = new byte[12];
        Pointer pointer = pageantConnector$COPYDATASTRUCT32.getPointer();
        pointer.read(0L, byArray, 0, 12);
        return byArray;
    }

    private byte[] install64(String string, PageantConnector$COPYDATASTRUCT64 pageantConnector$COPYDATASTRUCT64) {
        pageantConnector$COPYDATASTRUCT64.dwData = -2142351174;
        pageantConnector$COPYDATASTRUCT64.cbData = string.length() + 1;
        pageantConnector$COPYDATASTRUCT64.lpData = new Memory(string.length() + 1);
        byte[] byArray = string.getBytes();
        pageantConnector$COPYDATASTRUCT64.lpData.write(0L, byArray, 0, byArray.length);
        pageantConnector$COPYDATASTRUCT64.lpData.setByte(byArray.length, (byte)0);
        pageantConnector$COPYDATASTRUCT64.write();
        byArray = new byte[24];
        Pointer pointer = pageantConnector$COPYDATASTRUCT64.getPointer();
        pointer.read(0L, byArray, 0, 24);
        return byArray;
    }

    long sendMessage(WinDef$HWND winDef$HWND, byte[] byArray) {
        long l2 = this.libU.SendMessage(winDef$HWND, 74, null, byArray);
        return l2;
    }
}

