/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.agentproxy;

import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory$Default;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.PageantConnector;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import com.jcraft.jsch.agentproxy.usocket.NCUSocketFactory;
import java.util.ArrayList;

public abstract class ConnectorFactory {
    protected String connectors = "pageant,ssh-agent";
    protected String usocketFactories = "nc,jna";
    protected String usocketPath = null;

    public void setPreferredConnectors(String string) {
        this.connectors = string;
    }

    public String getPreferredConnectors() {
        return this.connectors;
    }

    public void setPreferredUSocketFactories(String string) {
        this.usocketFactories = string;
    }

    public String getPreferredUSocketFactories() {
        return this.usocketFactories;
    }

    public void setUSocketPath(String string) {
        this.usocketPath = string;
    }

    public String getUSocketPath() {
        return this.usocketPath;
    }

    public Connector createConnector() {
        int n2;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.connectors.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].trim().equals("pageant")) {
                if (!PageantConnector.isConnectorAvailable()) continue;
                try {
                    return new PageantConnector();
                }
                catch (AgentProxyException agentProxyException) {
                    arrayList.add("pageant");
                    continue;
                }
            }
            if (!stringArray[i2].trim().equals("ssh-agent") || !SSHAgentConnector.isConnectorAvailable(this.usocketPath)) continue;
            object = this.usocketFactories.split(",");
            for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                USocketFactory uSocketFactory;
                if (object[n2].trim().equals("nc")) {
                    try {
                        uSocketFactory = new NCUSocketFactory();
                        return new SSHAgentConnector(uSocketFactory, this.usocketPath);
                    }
                    catch (AgentProxyException agentProxyException) {
                        arrayList.add("ssh-agent:nc");
                        continue;
                    }
                }
                if (!object[n2].trim().equals("jna")) continue;
                try {
                    uSocketFactory = new JNAUSocketFactory();
                    return new SSHAgentConnector(uSocketFactory, this.usocketPath);
                }
                catch (AgentProxyException agentProxyException) {
                    arrayList.add("ssh-agent:jna");
                }
            }
        }
        String string = "connector is not available: ";
        object = "";
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            string = string + (String)object + (String)arrayList.get(n2);
            object = ",";
        }
        throw new AgentProxyException(string);
    }

    public static ConnectorFactory getDefault() {
        return new ConnectorFactory$Default();
    }
}

