/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32.symmetric;

import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.symmetric.EWAHPointer32;
import com.googlecode.javaewah32.symmetric.UpdateableBitmapFunction32;
import java.util.Arrays;

public final class ThresholdFuncBitmap32
extends UpdateableBitmapFunction32 {
    private final int min;
    private int[] buffers;
    private int bufferUsed;
    private final int[] bufcounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap32(int n2) {
        this.min = n2;
        this.buffers = new int[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage32 bitmapStorage32, int n2, int n3) {
        int n4 = n3 - n2;
        if (this.hammingWeight >= this.min) {
            bitmapStorage32.addStreamOfEmptyWords(true, n4);
        } else if (this.litWeight + this.hammingWeight < this.min) {
            bitmapStorage32.addStreamOfEmptyWords(false, n4);
        } else {
            int n5 = this.min - this.hammingWeight;
            if (n5 == 1) {
                this.orLiterals(bitmapStorage32, n2, n4);
                return;
            }
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed == n5) {
                this.andLiterals(bitmapStorage32, n2, n4);
            } else {
                this.generalLiterals(n5, bitmapStorage32, n2, n4);
            }
        }
    }

    private int threshold2buf(int n2, int[] nArray, int n3) {
        int n4;
        int n5 = 0;
        int[] nArray2 = this.bufcounters;
        System.arraycopy(zeroes64, 0, nArray2, 0, 64);
        for (n4 = 0; n4 < n3; ++n4) {
            int n6;
            for (int i2 = nArray[n4]; i2 != 0; i2 ^= n6) {
                n6 = i2 & -i2;
                int n7 = Integer.bitCount(n6 - 1);
                nArray2[n7] = nArray2[n7] + 1;
            }
        }
        for (n4 = 0; n4 < 64; ++n4) {
            if (nArray2[n4] < n2) continue;
            n5 = (int)((long)n5 | 1L << n4);
        }
        return n5;
    }

    private static int threshold3(int n2, int[] nArray, int n3) {
        if (nArray.length == 0) {
            return 0;
        }
        int[] nArray2 = new int[n2];
        nArray2[0] = nArray[0];
        for (int i2 = 1; i2 < n3; ++i2) {
            int n4;
            int n5 = nArray[i2];
            for (int i3 = n4 = Math.min(n2 - 1, i2); i3 >= 1; --i3) {
                int n6 = i3;
                nArray2[n6] = nArray2[n6] | n5 & nArray2[i3 - 1];
            }
            nArray2[0] = nArray2[0] | n5;
        }
        return nArray2[n2 - 1];
    }

    private int threshold4(int n2, int[] nArray, int n3) {
        if (n2 >= 128) {
            return this.threshold2buf(n2, nArray, n3);
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 += Integer.bitCount(nArray[i2]);
        }
        if (2 * n4 >= n3 * n2) {
            return ThresholdFuncBitmap32.threshold3(n2, nArray, n3);
        }
        return this.threshold2buf(n2, nArray, n3);
    }

    private void orLiterals(BitmapStorage32 bitmapStorage32, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = 0;
            for (EWAHPointer32 eWAHPointer32 : this.getLiterals()) {
                n4 |= eWAHPointer32.iterator.getLiteralWordAt(i2 + n2 - eWAHPointer32.beginOfRun());
            }
            bitmapStorage32.addWord(n4);
        }
    }

    private void andLiterals(BitmapStorage32 bitmapStorage32, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = -1;
            for (EWAHPointer32 eWAHPointer32 : this.getLiterals()) {
                n4 &= eWAHPointer32.iterator.getLiteralWordAt(i2 + n2 - eWAHPointer32.beginOfRun());
            }
            bitmapStorage32.addWord(n4);
        }
    }

    private void generalLiterals(int n2, BitmapStorage32 bitmapStorage32, int n3, int n4) {
        if (this.bufferUsed > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (EWAHPointer32 eWAHPointer32 : this.getLiterals()) {
                this.buffers[n5++] = eWAHPointer32.iterator.getLiteralWordAt(i2 + n3 - eWAHPointer32.beginOfRun());
            }
            bitmapStorage32.addWord(this.threshold4(n2, this.buffers, this.bufferUsed));
        }
    }
}

